/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.junit.Assert;
import org.junit.Test;

public class KeyGroupRangeTest {
    @Test
    public void testKeyGroupIntersection() {
        KeyGroupRange keyGroupRange1 = KeyGroupRange.of((int)0, (int)10);
        KeyGroupRange keyGroupRange2 = KeyGroupRange.of((int)3, (int)7);
        KeyGroupRange intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assert.assertEquals((long)3L, (long)intersection.getStartKeyGroup());
        Assert.assertEquals((long)7L, (long)intersection.getEndKeyGroup());
        Assert.assertEquals((Object)intersection, (Object)keyGroupRange2.getIntersection(keyGroupRange1));
        Assert.assertEquals((Object)keyGroupRange1, (Object)keyGroupRange1.getIntersection(keyGroupRange1));
        keyGroupRange1 = KeyGroupRange.of((int)0, (int)5);
        keyGroupRange2 = KeyGroupRange.of((int)6, (int)10);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assert.assertEquals((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE, (Object)intersection);
        Assert.assertEquals((Object)intersection, (Object)keyGroupRange2.getIntersection(keyGroupRange1));
        keyGroupRange1 = KeyGroupRange.of((int)0, (int)10);
        keyGroupRange2 = KeyGroupRange.of((int)5, (int)20);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assert.assertEquals((long)5L, (long)intersection.getStartKeyGroup());
        Assert.assertEquals((long)10L, (long)intersection.getEndKeyGroup());
        Assert.assertEquals((Object)intersection, (Object)keyGroupRange2.getIntersection(keyGroupRange1));
        keyGroupRange1 = KeyGroupRange.of((int)3, (int)12);
        keyGroupRange2 = KeyGroupRange.of((int)0, (int)10);
        intersection = keyGroupRange1.getIntersection(keyGroupRange2);
        Assert.assertEquals((long)3L, (long)intersection.getStartKeyGroup());
        Assert.assertEquals((long)10L, (long)intersection.getEndKeyGroup());
        Assert.assertEquals((Object)intersection, (Object)keyGroupRange2.getIntersection(keyGroupRange1));
    }

    @Test
    public void testKeyGroupRangeBasics() {
        this.testKeyGroupRangeBasicsInternal(0, 0);
        this.testKeyGroupRangeBasicsInternal(0, 1);
        this.testKeyGroupRangeBasicsInternal(1, 2);
        this.testKeyGroupRangeBasicsInternal(42, 42);
        this.testKeyGroupRangeBasicsInternal(3, 7);
        this.testKeyGroupRangeBasicsInternal(0, Short.MAX_VALUE);
        this.testKeyGroupRangeBasicsInternal(32766, Short.MAX_VALUE);
        try {
            this.testKeyGroupRangeBasicsInternal(-3, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testKeyGroupRangeBasicsInternal(int startKeyGroup, int endKeyGroup) {
        KeyGroupRange keyGroupRange = KeyGroupRange.of((int)startKeyGroup, (int)endKeyGroup);
        int numberOfKeyGroup = keyGroupRange.getNumberOfKeyGroups();
        Assert.assertEquals((long)Math.max(0, endKeyGroup - startKeyGroup + 1), (long)numberOfKeyGroup);
        if (keyGroupRange.getNumberOfKeyGroups() > 0) {
            Assert.assertEquals((long)startKeyGroup, (long)keyGroupRange.getStartKeyGroup());
            Assert.assertEquals((long)endKeyGroup, (long)keyGroupRange.getEndKeyGroup());
            int c = startKeyGroup;
            Iterator i$ = keyGroupRange.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Assert.assertEquals((long)c, (long)i);
                Assert.assertTrue((boolean)keyGroupRange.contains(i));
                ++c;
            }
            Assert.assertEquals((long)(endKeyGroup + 1), (long)c);
            Assert.assertFalse((boolean)keyGroupRange.contains(startKeyGroup - 1));
            Assert.assertFalse((boolean)keyGroupRange.contains(endKeyGroup + 1));
        } else {
            Assert.assertEquals((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE, (Object)keyGroupRange);
        }
    }
}

