/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackendTest;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.FutureUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={TypeSerializerSerializationUtil.class})
public class MemoryStateBackendTest
extends StateBackendTestBase<MemoryStateBackend> {
    @Override
    protected MemoryStateBackend getStateBackend() throws Exception {
        return new MemoryStateBackend(this.useAsyncMode());
    }

    protected boolean useAsyncMode() {
        return false;
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testMapStateRestoreWithWrongSerializers() {
    }

    @Test
    public void testNumStateEntries() throws Exception {
        AbstractKeyedStateBackend backend = this.createKeyedBackend(IntSerializer.INSTANCE);
        ValueStateDescriptor kvId = new ValueStateDescriptor("id", String.class, null);
        kvId.initializeSerializerUnlessSet(new ExecutionConfig());
        HeapKeyedStateBackend heapBackend = (HeapKeyedStateBackend)backend;
        Assert.assertEquals((long)0L, (long)heapBackend.numStateEntries());
        ValueState state = (ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
        backend.setCurrentKey((Object)0);
        state.update((Object)"hello");
        state.update((Object)"ciao");
        Assert.assertEquals((long)1L, (long)heapBackend.numStateEntries());
        backend.setCurrentKey((Object)42);
        state.update((Object)"foo");
        Assert.assertEquals((long)2L, (long)heapBackend.numStateEntries());
        backend.setCurrentKey((Object)0);
        state.clear();
        Assert.assertEquals((long)1L, (long)heapBackend.numStateEntries());
        backend.setCurrentKey((Object)42);
        state.clear();
        Assert.assertEquals((long)0L, (long)heapBackend.numStateEntries());
        backend.dispose();
    }

    @Test
    public void testOversizedState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            CheckpointStreamFactory streamFactory = backend.createStreamFactory(new JobID(), "test_op");
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            try {
                CheckpointStreamFactory.CheckpointStateOutputStream outStream = streamFactory.createCheckpointStateOutputStream(12L, 459L);
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)outStream);
                oos.writeObject(state);
                oos.flush();
                outStream.closeAndGetHandle();
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            CheckpointStreamFactory streamFactory = backend.createStreamFactory(new JobID(), "test_op");
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            CheckpointStreamFactory.CheckpointStateOutputStream os = streamFactory.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            oos.writeObject(state);
            oos.flush();
            StreamStateHandle handle = os.closeAndGetHandle();
            Assert.assertNotNull((Object)handle);
            try (ObjectInputStream ois = new ObjectInputStream((InputStream)handle.openInputStream());){
                Assert.assertEquals(state, (Object)ois.readObject());
                Assert.assertTrue((ois.available() <= 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOversizedStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            CheckpointStreamFactory streamFactory = backend.createStreamFactory(new JobID(), "test_op");
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            CheckpointStreamFactory.CheckpointStateOutputStream os = streamFactory.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            try {
                oos.writeObject(state);
                oos.flush();
                os.closeAndGetHandle();
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperatorStateRestoreFailsIfSerializerDeserializationFails() throws Exception {
        MemoryStateBackend abstractStateBackend = new MemoryStateBackend(4096);
        Environment env = (Environment)Mockito.mock(Environment.class);
        Mockito.when((Object)env.getExecutionConfig()).thenReturn((Object)new ExecutionConfig());
        Mockito.when((Object)env.getUserClassLoader()).thenReturn((Object)OperatorStateBackendTest.class.getClassLoader());
        OperatorStateBackend operatorStateBackend = abstractStateBackend.createOperatorStateBackend(env, "test-op-name");
        ListStateDescriptor stateDescriptor1 = new ListStateDescriptor("test1", (TypeSerializer)new JavaSerializer());
        ListStateDescriptor stateDescriptor2 = new ListStateDescriptor("test2", (TypeSerializer)new JavaSerializer());
        ListStateDescriptor stateDescriptor3 = new ListStateDescriptor("test3", (TypeSerializer)new JavaSerializer());
        ListState listState1 = operatorStateBackend.getListState(stateDescriptor1);
        ListState listState2 = operatorStateBackend.getListState(stateDescriptor2);
        ListState listState3 = operatorStateBackend.getUnionListState(stateDescriptor3);
        listState1.add((Object)42);
        listState1.add((Object)4711);
        listState2.add((Object)7);
        listState2.add((Object)13);
        listState2.add((Object)23);
        listState3.add((Object)17);
        listState3.add((Object)18);
        listState3.add((Object)19);
        listState3.add((Object)20);
        CheckpointStreamFactory streamFactory = abstractStateBackend.createStreamFactory(new JobID(), "testOperator");
        RunnableFuture runnableFuture = operatorStateBackend.snapshot(1L, 1L, streamFactory, CheckpointOptions.forFullCheckpoint());
        OperatorStateHandle stateHandle = (OperatorStateHandle)FutureUtil.runIfNotDoneAndGet((RunnableFuture)runnableFuture);
        try {
            operatorStateBackend.close();
            operatorStateBackend.dispose();
            operatorStateBackend = abstractStateBackend.createOperatorStateBackend(env, "testOperator");
            TypeSerializerSerializationUtil.TypeSerializerSerializationProxy mockProxy = (TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.mock(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class);
            ((TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.doThrow((Throwable)new IOException()).when((Object)mockProxy)).read((DataInputView)Matchers.any(DataInputViewStreamWrapper.class));
            PowerMockito.whenNew(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class).withAnyArguments().thenReturn((Object)mockProxy);
            operatorStateBackend.restore(Collections.singletonList(stateHandle));
            Assert.fail((String)"The operator state restore should have failed if the previous state serializer could not be loaded.");
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Unable to restore operator state"));
        }
        finally {
            stateHandle.discardState();
        }
    }

    @Test
    public void testKeyedStateRestoreFailsIfSerializerDeserializationFails() throws Exception {
        CheckpointStreamFactory streamFactory = this.createStreamFactory();
        AbstractKeyedStateBackend backend = this.createKeyedBackend(IntSerializer.INSTANCE);
        ValueStateDescriptor kvId = new ValueStateDescriptor("id", String.class, null);
        kvId.initializeSerializerUnlessSet(new ExecutionConfig());
        HeapKeyedStateBackend heapBackend = (HeapKeyedStateBackend)backend;
        Assert.assertEquals((long)0L, (long)heapBackend.numStateEntries());
        ValueState state = (ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)kvId);
        backend.setCurrentKey((Object)0);
        state.update((Object)"hello");
        state.update((Object)"ciao");
        KeyedStateHandle snapshot = this.runSnapshot(((HeapKeyedStateBackend)backend).snapshot(682375462378L, 2L, streamFactory, CheckpointOptions.forFullCheckpoint()));
        backend.dispose();
        Environment env = (Environment)Mockito.mock(Environment.class);
        Mockito.when((Object)env.getExecutionConfig()).thenReturn((Object)new ExecutionConfig());
        Mockito.when((Object)env.getUserClassLoader()).thenReturn((Object)OperatorStateBackendTest.class.getClassLoader());
        TypeSerializerSerializationUtil.TypeSerializerSerializationProxy mockProxy = (TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.mock(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class);
        ((TypeSerializerSerializationUtil.TypeSerializerSerializationProxy)Mockito.doThrow((Throwable)new IOException()).when((Object)mockProxy)).read((DataInputView)Matchers.any(DataInputViewStreamWrapper.class));
        PowerMockito.whenNew(TypeSerializerSerializationUtil.TypeSerializerSerializationProxy.class).withAnyArguments().thenReturn((Object)mockProxy);
        try {
            this.restoreKeyedBackend(IntSerializer.INSTANCE, snapshot, env);
            Assert.fail((String)"The keyed state restore should have failed if the previous state serializer could not be loaded.");
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Unable to restore keyed state"));
        }
    }

    @Override
    @Ignore
    @Test
    public void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

