/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.MultiStreamStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiStreamStateHandleTest {
    private static final int TEST_DATA_LENGTH = 123;
    private Random random;
    private byte[] testData;
    private List<StreamStateHandle> streamStateHandles;

    @Before
    public void setup() {
        int len;
        this.random = new Random(66L);
        this.testData = new byte[123];
        for (int i = 0; i < this.testData.length; ++i) {
            this.testData[i] = (byte)i;
        }
        this.streamStateHandles = new ArrayList<StreamStateHandle>();
        for (int idx = 0; idx < this.testData.length; idx += len) {
            len = this.random.nextInt(5);
            byte[] sub = Arrays.copyOfRange(this.testData, idx, idx + len);
            this.streamStateHandles.add((StreamStateHandle)new ByteStreamStateHandle(String.valueOf(idx), sub));
        }
    }

    @Test
    public void testMetaData() throws IOException {
        MultiStreamStateHandle multiStreamStateHandle = new MultiStreamStateHandle(this.streamStateHandles);
        Assert.assertEquals((long)123L, (long)multiStreamStateHandle.getStateSize());
    }

    @Test
    public void testLinearRead() throws IOException {
        MultiStreamStateHandle multiStreamStateHandle = new MultiStreamStateHandle(this.streamStateHandles);
        try (FSDataInputStream in = multiStreamStateHandle.openInputStream();){
            for (int i = 0; i < 123; ++i) {
                Assert.assertEquals((long)i, (long)in.getPos());
                Assert.assertEquals((long)this.testData[i], (long)in.read());
            }
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)123L, (long)in.getPos());
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)123L, (long)in.getPos());
        }
    }

    @Test
    public void testRandomRead() throws IOException {
        MultiStreamStateHandle multiStreamStateHandle = new MultiStreamStateHandle(this.streamStateHandles);
        try (FSDataInputStream in = multiStreamStateHandle.openInputStream();){
            for (int i = 0; i < 1000; ++i) {
                int pos = this.random.nextInt(123);
                int readLen = this.random.nextInt(123);
                in.seek((long)pos);
                while (--readLen > 0 && pos < 123) {
                    Assert.assertEquals((long)pos, (long)in.getPos());
                    Assert.assertEquals((long)this.testData[pos++], (long)in.read());
                }
            }
            in.seek(123L);
            Assert.assertEquals((long)123L, (long)in.getPos());
            Assert.assertEquals((long)-1L, (long)in.read());
            try {
                in.seek(124L);
                Assert.fail();
            }
            catch (Exception i) {
                // empty catch block
            }
        }
    }

    @Test
    public void testEmptyList() throws IOException {
        MultiStreamStateHandle multiStreamStateHandle = new MultiStreamStateHandle(Collections.emptyList());
        try (FSDataInputStream in = multiStreamStateHandle.openInputStream();){
            Assert.assertEquals((long)0L, (long)in.getPos());
            in.seek(0L);
            Assert.assertEquals((long)0L, (long)in.getPos());
            Assert.assertEquals((long)-1L, (long)in.read());
            try {
                in.seek(1L);
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

