/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsSavepointStreamFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FsSavepointStreamFactoryTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testSavepointStreamDirectoryLayout() throws Exception {
        File testRoot = this.folder.newFolder();
        JobID jobId = new JobID();
        FsSavepointStreamFactory savepointStreamFactory = new FsSavepointStreamFactory(new Path(testRoot.getAbsolutePath()), jobId, 0);
        Path root = new Path(testRoot.getAbsolutePath());
        FileStatus[] listed = root.getFileSystem().listStatus(root);
        Assert.assertNotNull((Object)listed);
        Assert.assertEquals((long)0L, (long)listed.length);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = savepointStreamFactory.createCheckpointStateOutputStream(1273L, 19231L);
        stream.write(1);
        FileStateHandle handle = (FileStateHandle)stream.closeAndGetHandle();
        listed = root.getFileSystem().listStatus(root);
        Assert.assertNotNull((Object)listed);
        Assert.assertEquals((long)1L, (long)listed.length);
        Assert.assertEquals((Object)handle.getFilePath().getPath(), (Object)listed[0].getPath().getPath());
    }
}

