/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapStateBackendTestBase;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class HeapKeyedStateBackendSnapshotMigrationTest
extends HeapStateBackendTestBase {
    @Test
    public void testRestore1_2ToMaster() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        URL resource = cl.getResource("heap_keyed_statebackend_1_2.snapshot");
        Preconditions.checkNotNull((Object)resource, (String)"Binary snapshot resource not found!");
        Integer namespace1 = 1;
        Integer namespace2 = 2;
        Integer namespace3 = 3;
        try (HeapKeyedStateBackend<String> keyedBackend = this.createKeyedBackend();){
            KeyGroupsStateHandle stateHandle;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resource.getFile()));){
                stateHandle = (KeyGroupsStateHandle)InstantiationUtil.deserializeObject((InputStream)bis, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            keyedBackend.restore(Collections.singleton(stateHandle));
            ListStateDescriptor stateDescr = new ListStateDescriptor("my-state", Long.class);
            stateDescr.initializeSerializerUnlessSet(new ExecutionConfig());
            InternalListState state = keyedBackend.createListState((TypeSerializer)IntSerializer.INSTANCE, stateDescr);
            Assert.assertEquals((long)7L, (long)keyedBackend.numStateEntries());
            keyedBackend.setCurrentKey((Object)"abc");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals(Arrays.asList(33L, 55L), (Object)state.get());
            state.setCurrentNamespace((Object)namespace2);
            Assert.assertEquals(Arrays.asList(22L, 11L), (Object)state.get());
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals(Collections.singletonList(44L), (Object)state.get());
            keyedBackend.setCurrentKey((Object)"def");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals(Arrays.asList(11L, 44L), (Object)state.get());
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals(Arrays.asList(22L, 55L, 33L), (Object)state.get());
            keyedBackend.setCurrentKey((Object)"jkl");
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertEquals(Arrays.asList(11L, 22L, 33L, 44L, 55L), (Object)state.get());
            keyedBackend.setCurrentKey((Object)"mno");
            state.setCurrentNamespace((Object)namespace3);
            Assert.assertEquals(Arrays.asList(11L, 22L, 33L, 44L, 55L), (Object)state.get());
        }
    }
}

