/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapListState;
import org.apache.flink.runtime.state.heap.HeapStateBackendTestBase;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.junit.Assert;
import org.junit.Test;

public class HeapListStateTest
extends HeapStateBackendTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndGet() throws Exception {
        ListStateDescriptor stateDescr = new ListStateDescriptor("my-state", Long.class);
        stateDescr.initializeSerializerUnlessSet(new ExecutionConfig());
        HeapKeyedStateBackend<String> keyedBackend = this.createKeyedBackend();
        try {
            InternalListState state = keyedBackend.createListState((TypeSerializer)VoidNamespaceSerializer.INSTANCE, stateDescr);
            state.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            keyedBackend.setCurrentKey((Object)"abc");
            Assert.assertNull((Object)state.get());
            keyedBackend.setCurrentKey((Object)"def");
            Assert.assertNull((Object)state.get());
            state.add((Object)17L);
            state.add((Object)11L);
            Assert.assertEquals(Arrays.asList(17L, 11L), (Object)state.get());
            keyedBackend.setCurrentKey((Object)"abc");
            Assert.assertNull((Object)state.get());
            keyedBackend.setCurrentKey((Object)"g");
            Assert.assertNull((Object)state.get());
            state.add((Object)1L);
            state.add((Object)2L);
            keyedBackend.setCurrentKey((Object)"def");
            Assert.assertEquals(Arrays.asList(17L, 11L), (Object)state.get());
            state.clear();
            Assert.assertNull((Object)state.get());
            keyedBackend.setCurrentKey((Object)"g");
            state.add((Object)3L);
            state.add((Object)2L);
            state.add((Object)1L);
            keyedBackend.setCurrentKey((Object)"def");
            Assert.assertNull((Object)state.get());
            keyedBackend.setCurrentKey((Object)"g");
            Assert.assertEquals(Arrays.asList(1L, 2L, 3L, 2L, 1L), (Object)state.get());
            state.clear();
            StateTable stateTable = ((HeapListState)state).stateTable;
            Assert.assertTrue((boolean)stateTable.isEmpty());
        }
        finally {
            keyedBackend.close();
            keyedBackend.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerging() throws Exception {
        ListStateDescriptor stateDescr = new ListStateDescriptor("my-state", Long.class);
        stateDescr.initializeSerializerUnlessSet(new ExecutionConfig());
        Integer namespace1 = 1;
        Integer namespace2 = 2;
        Integer namespace3 = 3;
        HashSet<Long> expectedResult = new HashSet<Long>(Arrays.asList(11L, 22L, 33L, 44L, 55L));
        HeapKeyedStateBackend<String> keyedBackend = this.createKeyedBackend();
        try {
            InternalListState state = keyedBackend.createListState((TypeSerializer)IntSerializer.INSTANCE, stateDescr);
            keyedBackend.setCurrentKey((Object)"abc");
            state.setCurrentNamespace((Object)namespace1);
            state.add((Object)33L);
            state.add((Object)55L);
            state.setCurrentNamespace((Object)namespace2);
            state.add((Object)22L);
            state.add((Object)11L);
            state.setCurrentNamespace((Object)namespace3);
            state.add((Object)44L);
            keyedBackend.setCurrentKey((Object)"def");
            state.setCurrentNamespace((Object)namespace1);
            state.add((Object)11L);
            state.add((Object)44L);
            state.setCurrentNamespace((Object)namespace3);
            state.add((Object)22L);
            state.add((Object)55L);
            state.add((Object)33L);
            keyedBackend.setCurrentKey((Object)"jkl");
            state.setCurrentNamespace((Object)namespace1);
            state.add((Object)11L);
            state.add((Object)22L);
            state.add((Object)33L);
            state.add((Object)44L);
            state.add((Object)55L);
            keyedBackend.setCurrentKey((Object)"mno");
            state.setCurrentNamespace((Object)namespace3);
            state.add((Object)11L);
            state.add((Object)22L);
            state.add((Object)33L);
            state.add((Object)44L);
            state.add((Object)55L);
            keyedBackend.setCurrentKey((Object)"abc");
            state.mergeNamespaces((Object)namespace1, Arrays.asList(namespace2, namespace3));
            state.setCurrentNamespace((Object)namespace1);
            HeapListStateTest.validateResult((Iterable)state.get(), expectedResult);
            keyedBackend.setCurrentKey((Object)"def");
            state.mergeNamespaces((Object)namespace1, Arrays.asList(namespace2, namespace3));
            state.setCurrentNamespace((Object)namespace1);
            HeapListStateTest.validateResult((Iterable)state.get(), expectedResult);
            keyedBackend.setCurrentKey((Object)"ghi");
            state.mergeNamespaces((Object)namespace1, Arrays.asList(namespace2, namespace3));
            state.setCurrentNamespace((Object)namespace1);
            Assert.assertNull((Object)state.get());
            keyedBackend.setCurrentKey((Object)"jkl");
            state.mergeNamespaces((Object)namespace1, Arrays.asList(namespace2, namespace3));
            state.setCurrentNamespace((Object)namespace1);
            HeapListStateTest.validateResult((Iterable)state.get(), expectedResult);
            keyedBackend.setCurrentKey((Object)"mno");
            state.mergeNamespaces((Object)namespace1, Arrays.asList(namespace2, namespace3));
            state.setCurrentNamespace((Object)namespace1);
            HeapListStateTest.validateResult((Iterable)state.get(), expectedResult);
            keyedBackend.setCurrentKey((Object)"abc");
            state.setCurrentNamespace((Object)namespace1);
            state.clear();
            keyedBackend.setCurrentKey((Object)"def");
            state.setCurrentNamespace((Object)namespace1);
            state.clear();
            keyedBackend.setCurrentKey((Object)"ghi");
            state.setCurrentNamespace((Object)namespace1);
            state.clear();
            keyedBackend.setCurrentKey((Object)"jkl");
            state.setCurrentNamespace((Object)namespace1);
            state.clear();
            keyedBackend.setCurrentKey((Object)"mno");
            state.setCurrentNamespace((Object)namespace1);
            state.clear();
            StateTable stateTable = ((HeapListState)state).stateTable;
            Assert.assertTrue((boolean)stateTable.isEmpty());
        }
        finally {
            keyedBackend.close();
            keyedBackend.dispose();
        }
    }

    private static <T> void validateResult(Iterable<T> values, Set<T> expected) {
        int num = 0;
        for (T v : values) {
            ++num;
            Assert.assertTrue((boolean)expected.contains(v));
        }
        Assert.assertEquals((long)expected.size(), (long)num);
    }
}

