/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.RegisteredKeyedBackendStateMetaInfo;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTable;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTableSnapshot;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateTableTest;
import org.apache.flink.runtime.state.heap.NestedMapsStateTable;
import org.apache.flink.runtime.state.heap.StateEntry;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.heap.StateTableByKeyGroupReader;
import org.apache.flink.runtime.state.heap.StateTableByKeyGroupReaders;
import org.apache.flink.runtime.state.heap.StateTableSnapshot;
import org.junit.Assert;
import org.junit.Test;

public class StateTableSnapshotCompatibilityTest {
    @Test
    public void checkCompatibleSerializationFormats() throws IOException {
        Random r = new Random(42L);
        RegisteredKeyedBackendStateMetaInfo metaInfo = new RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type.UNKNOWN, "test", (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)new ArrayListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        CopyOnWriteStateTableTest.MockInternalKeyContext keyContext = new CopyOnWriteStateTableTest.MockInternalKeyContext(IntSerializer.INSTANCE);
        CopyOnWriteStateTable cowStateTable = new CopyOnWriteStateTable(keyContext, metaInfo);
        for (int i = 0; i < 100; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>(5);
            int end = r.nextInt(5);
            for (int j = 0; j < end; ++j) {
                list.add(r.nextInt(100));
            }
            cowStateTable.put((Object)r.nextInt(10), (Object)r.nextInt(2), list);
        }
        CopyOnWriteStateTableSnapshot snapshot = cowStateTable.createSnapshot();
        NestedMapsStateTable nestedMapsStateTable = new NestedMapsStateTable(keyContext, metaInfo);
        StateTableSnapshotCompatibilityTest.restoreStateTableFromSnapshot(nestedMapsStateTable, (StateTableSnapshot)snapshot, keyContext.getKeyGroupRange());
        snapshot.release();
        Assert.assertEquals((long)cowStateTable.size(), (long)nestedMapsStateTable.size());
        for (StateEntry entry : cowStateTable) {
            Assert.assertEquals((Object)entry.getState(), (Object)nestedMapsStateTable.get(entry.getKey(), entry.getNamespace()));
        }
        snapshot = nestedMapsStateTable.createSnapshot();
        cowStateTable = new CopyOnWriteStateTable(keyContext, metaInfo);
        StateTableSnapshotCompatibilityTest.restoreStateTableFromSnapshot(cowStateTable, (StateTableSnapshot)snapshot, keyContext.getKeyGroupRange());
        snapshot.release();
        Assert.assertEquals((long)nestedMapsStateTable.size(), (long)cowStateTable.size());
        for (StateEntry entry : cowStateTable) {
            Assert.assertEquals((Object)nestedMapsStateTable.get(entry.getKey(), entry.getNamespace()), (Object)entry.getState());
        }
    }

    private static <K, N, S> void restoreStateTableFromSnapshot(StateTable<K, N, S> stateTable, StateTableSnapshot snapshot, KeyGroupRange keyGroupRange) throws IOException {
        ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos(0x100000);
        DataOutputViewStreamWrapper dov = new DataOutputViewStreamWrapper((OutputStream)out);
        for (Integer keyGroup : keyGroupRange) {
            snapshot.writeMappingsInKeyGroup((DataOutputView)dov, keyGroup.intValue());
        }
        ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(out.getBuf());
        DataInputViewStreamWrapper div = new DataInputViewStreamWrapper((InputStream)in);
        StateTableByKeyGroupReader keyGroupReader = StateTableByKeyGroupReaders.readerForVersion(stateTable, (int)3);
        for (Integer keyGroup : keyGroupRange) {
            keyGroupReader.readMappingsInKeyGroup((DataInputView)div, keyGroup.intValue());
        }
    }
}

