/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingSerialRpcService;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobManagerTable;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TaskExecutorITCase
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlotAllocation() throws Exception {
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        TestingHighAvailabilityServices testingHAServices = new TestingHighAvailabilityServices();
        Configuration configuration = new Configuration();
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
        ResourceID taskManagerResourceId = new ResourceID("foobar");
        UUID rmLeaderId = UUID.randomUUID();
        TestingLeaderElectionService rmLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService rmLeaderRetrievalService = new TestingLeaderRetrievalService(null, null);
        String rmAddress = "rm";
        String jmAddress = "jm";
        UUID jmLeaderId = UUID.randomUUID();
        ResourceID rmResourceId = new ResourceID("rm");
        ResourceID jmResourceId = new ResourceID("jm");
        JobID jobId = new JobID();
        ResourceProfile resourceProfile = new ResourceProfile(1.0, 1);
        testingHAServices.setResourceManagerLeaderElectionService(rmLeaderElectionService);
        testingHAServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        testingHAServices.setJobMasterLeaderRetriever(jobId, new TestingLeaderRetrievalService("jm", jmLeaderId));
        TestingSerialRpcService rpcService = new TestingSerialRpcService();
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.milliseconds((long)500L), Time.milliseconds((long)500L));
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)testingHAServices, rpcService.getScheduledExecutor(), Time.minutes((long)5L));
        MetricRegistry metricRegistry = (MetricRegistry)Mockito.mock(MetricRegistry.class);
        HeartbeatServices heartbeatServices = (HeartbeatServices)Mockito.mock(HeartbeatServices.class, (Answer)Mockito.RETURNS_MOCKS);
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration((Configuration)configuration);
        TaskManagerLocation taskManagerLocation = new TaskManagerLocation(taskManagerResourceId, InetAddress.getLocalHost(), 1234);
        MemoryManager memoryManager = (MemoryManager)Mockito.mock(MemoryManager.class);
        IOManager ioManager = (IOManager)Mockito.mock(IOManager.class);
        NetworkEnvironment networkEnvironment = (NetworkEnvironment)Mockito.mock(NetworkEnvironment.class);
        TaskManagerMetricGroup taskManagerMetricGroup = (TaskManagerMetricGroup)Mockito.mock(TaskManagerMetricGroup.class);
        BroadcastVariableManager broadcastVariableManager = (BroadcastVariableManager)Mockito.mock(BroadcastVariableManager.class);
        FileCache fileCache = (FileCache)Mockito.mock(FileCache.class);
        TaskSlotTable taskSlotTable = new TaskSlotTable(Arrays.asList(resourceProfile), new TimerService((ScheduledExecutorService)scheduledExecutorService, 100L));
        JobManagerTable jobManagerTable = new JobManagerTable();
        JobLeaderService jobLeaderService = new JobLeaderService(taskManagerLocation);
        SlotManager slotManager = new SlotManager(rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)rpcService, "resourcemanager", rmResourceId, resourceManagerConfiguration, (HighAvailabilityServices)testingHAServices, heartbeatServices, slotManager, metricRegistry, jobLeaderIdService, (FatalErrorHandler)testingFatalErrorHandler);
        TaskExecutor taskExecutor = new TaskExecutor((RpcService)rpcService, taskManagerConfiguration, taskManagerLocation, memoryManager, ioManager, networkEnvironment, (HighAvailabilityServices)testingHAServices, heartbeatServices, metricRegistry, taskManagerMetricGroup, broadcastVariableManager, fileCache, taskSlotTable, jobManagerTable, jobLeaderService, (FatalErrorHandler)testingFatalErrorHandler);
        JobMasterGateway jmGateway = (JobMasterGateway)Mockito.mock(JobMasterGateway.class);
        Mockito.when((Object)jmGateway.registerTaskManager((String)Matchers.any(String.class), (TaskManagerLocation)Matchers.any(TaskManagerLocation.class), (UUID)Matchers.eq((Object)jmLeaderId), (Time)Matchers.any(Time.class))).thenReturn((Object)FlinkCompletableFuture.completed((Object)new JMTMRegistrationSuccess(taskManagerResourceId, 1234)));
        Mockito.when((Object)jmGateway.getHostname()).thenReturn((Object)"jm");
        Mockito.when((Object)jmGateway.offerSlots((ResourceID)Matchers.eq((Object)taskManagerResourceId), (Iterable)Matchers.any(Iterable.class), (UUID)Matchers.eq((Object)jmLeaderId), (Time)Matchers.any(Time.class))).thenReturn(Mockito.mock(Future.class, (Answer)Mockito.RETURNS_MOCKS));
        rpcService.registerGateway("rm", resourceManager.getSelf());
        rpcService.registerGateway("jm", (RpcGateway)jmGateway);
        AllocationID allocationId = new AllocationID();
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "jm");
        SlotOffer slotOffer = new SlotOffer(allocationId, 0, resourceProfile);
        try {
            resourceManager.start();
            taskExecutor.start();
            rmLeaderElectionService.isLeader(rmLeaderId);
            rmLeaderRetrievalService.notifyListener("rm", rmLeaderId);
            Future registrationResponseFuture = resourceManager.registerJobManager(rmLeaderId, jmLeaderId, jmResourceId, "jm", jobId);
            RegistrationResponse registrationResponse = (RegistrationResponse)registrationResponseFuture.get();
            Assert.assertTrue((boolean)(registrationResponse instanceof JobMasterRegistrationSuccess));
            resourceManager.requestSlot(jmLeaderId, rmLeaderId, slotRequest);
            ((JobMasterGateway)Mockito.verify((Object)jmGateway)).offerSlots((ResourceID)Matchers.eq((Object)taskManagerResourceId), (Iterable)Matchers.argThat((Matcher)org.hamcrest.Matchers.contains((Object[])new SlotOffer[]{slotOffer})), (UUID)Matchers.eq((Object)jmLeaderId), (Time)Matchers.any(Time.class));
        }
        finally {
            if (testingFatalErrorHandler.hasExceptionOccurred()) {
                testingFatalErrorHandler.rethrowError();
            }
        }
    }
}

