/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;

public class TaskManagerConfigurationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsePreconfiguredNetworkInterface() throws Exception {
        String TEST_HOST_NAME = "testhostname";
        Configuration config = new Configuration();
        config.setString("taskmanager.hostname", "testhostname");
        config.setString("jobmanager.rpc.address", "localhost");
        config.setInteger("jobmanager.rpc.port", 7891);
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Tuple2 address = TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
            Assert.assertEquals((Object)"testhostname", (Object)address._1());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActorSystemPortConfig() throws Exception {
        Configuration config = new Configuration();
        config.setString("taskmanager.hostname", "localhost");
        config.setString("jobmanager.rpc.address", "localhost");
        config.setInteger("jobmanager.rpc.port", 7891);
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Assert.assertEquals((Object)0, (Object)TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._2());
            int testPort = 22551;
            config.setInteger("taskmanager.rpc.port", 22551);
            Assert.assertEquals((Object)22551, (Object)TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._2());
            try {
                config.setInteger("taskmanager.rpc.port", -1);
                TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
            try {
                config.setInteger("taskmanager.rpc.port", 100000);
                TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultFsParameterLoading() {
        File tmpDir = this.getTmpDir();
        File confFile = new File(tmpDir, "flink-conf.yaml");
        try {
            URI defaultFS = new URI("otherFS", null, "localhost", 1234, null, null, null);
            PrintWriter pw1 = new PrintWriter(confFile);
            pw1.println("fs.default-scheme: " + defaultFS);
            pw1.close();
            String[] args = new String[]{"--configDir:" + tmpDir};
            TaskManager.parseArgsAndLoadConfig((String[])args);
            Field f = FileSystem.class.getDeclaredField("defaultScheme");
            f.setAccessible(true);
            URI scheme = (URI)f.get(null);
            Assert.assertEquals((String)"Default Filesystem Scheme not configured.", (Object)scheme, (Object)defaultFS);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            confFile.delete();
            tmpDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNetworkInterfaceSelection() throws Exception {
        ServerSocket server;
        String hostname = "localhost";
        try {
            InetAddress localhostAddress = InetAddress.getByName(hostname);
            server = new ServerSocket(0, 50, localhostAddress);
        }
        catch (IOException e) {
            System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
            return;
        }
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", hostname);
        config.setInteger("jobmanager.rpc.port", server.getLocalPort());
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Assert.assertNotNull((Object)TaskManager.selectNetworkInterfaceAndPort((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._1());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
            try {
                server.close();
            }
            catch (IOException iOException) {}
        }
    }

    private File getTmpDir() {
        File tmpDir = new File(CommonTestUtils.getTempDir(), UUID.randomUUID().toString());
        Assert.assertTrue((String)"could not create temp directory", (boolean)tmpDir.mkdirs());
        return tmpDir;
    }
}

