/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.StartupUtils;
import org.apache.flink.util.NetUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;

public class TaskManagerStartupTest {
    private HighAvailabilityServices highAvailabilityServices;

    @Before
    public void setupTest() {
        this.highAvailabilityServices = new EmbeddedHaServices((Executor)TestingUtils.defaultExecutor());
    }

    @After
    public void tearDownTest() throws Exception {
        if (this.highAvailabilityServices != null) {
            this.highAvailabilityServices.closeAndCleanupAllData();
            this.highAvailabilityServices = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=BindException.class)
    public void testStartupWhenTaskmanagerActorPortIsUsed() throws Exception {
        ServerSocket blocker = null;
        try {
            String localHostName = "localhost";
            InetAddress localBindAddress = InetAddress.getByName(NetUtils.getWildcardIPAddress());
            blocker = new ServerSocket(0, 50, localBindAddress);
            int port = blocker.getLocalPort();
            TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)port, (Configuration)new Configuration(), (HighAvailabilityServices)this.highAvailabilityServices, TaskManager.class);
            Assert.fail((String)"This should fail with an IOException");
        }
        catch (IOException e) {
            List<Throwable> causes = StartupUtils.getExceptionCauses(e, new ArrayList<Throwable>());
            for (Throwable cause : causes) {
                if (!(cause instanceof BindException)) continue;
                throw (BindException)cause;
            }
            Assert.fail((String)"This should fail with an exception caused by BindException");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (blocker != null) {
                try {
                    blocker.close();
                }
                catch (IOException e) {}
            }
            this.highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIODirectoryNotWritable() throws Exception {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH);
        File nonWritable = new File(tempDir, UUID.randomUUID().toString());
        if (!nonWritable.mkdirs() || !nonWritable.setWritable(false, false)) {
            System.err.println("Cannot create non-writable temporary file directory. Skipping test.");
            return;
        }
        try {
            Configuration cfg = new Configuration();
            cfg.setString("taskmanager.tmp.dirs", nonWritable.getAbsolutePath());
            cfg.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 4L);
            cfg.setString("jobmanager.rpc.address", "localhost");
            cfg.setInteger("jobmanager.rpc.port", 21656);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg, (HighAvailabilityServices)this.highAvailabilityServices);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            nonWritable.setWritable(true, false);
            try {
                FileUtils.deleteDirectory((File)nonWritable);
            }
            catch (IOException iOException) {}
            this.highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    @Test
    public void testMemoryConfigWrong() {
        try {
            Configuration cfg = new Configuration();
            cfg.setString("jobmanager.rpc.address", "localhost");
            cfg.setInteger("jobmanager.rpc.port", 21656);
            cfg.setString("taskmanager.memory.preallocate", "true");
            cfg.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, -42L);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg, (HighAvailabilityServices)this.highAvailabilityServices);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
            long memSize = 0x7FFFFFFEL * (long)((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).intValue() >> 20;
            cfg.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, memSize);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg, (HighAvailabilityServices)this.highAvailabilityServices);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof OutOfMemoryError));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testStartupWhenNetworkStackFailsToInitialize() throws Exception {
        ServerSocket blocker = null;
        try {
            blocker = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
            Configuration cfg = new Configuration();
            cfg.setString("taskmanager.hostname", "localhost");
            cfg.setInteger("taskmanager.data.port", blocker.getLocalPort());
            cfg.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 1L);
            TaskManager.startTaskManagerComponentsAndActor((Configuration)cfg, (ResourceID)ResourceID.generate(), null, (HighAvailabilityServices)this.highAvailabilityServices, (String)"localhost", (Option)Option.empty(), (boolean)false, TaskManager.class);
        }
        finally {
            if (blocker != null) {
                try {
                    blocker.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

