/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.PartitionProducerStateChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.StoppableTask;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.state.TaskStateHandles;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={TaskDeploymentDescriptor.class, JobID.class, FiniteDuration.class})
public class TaskStopTest {
    private Task task;

    public void doMocking(AbstractInvokable taskMock) throws Exception {
        TaskInfo taskInfoMock = (TaskInfo)Mockito.mock(TaskInfo.class);
        Mockito.when((Object)taskInfoMock.getTaskNameWithSubtasks()).thenReturn((Object)"dummyName");
        TaskManagerRuntimeInfo tmRuntimeInfo = (TaskManagerRuntimeInfo)Mockito.mock(TaskManagerRuntimeInfo.class);
        Mockito.when((Object)tmRuntimeInfo.getConfiguration()).thenReturn((Object)new Configuration());
        TaskMetricGroup taskMetricGroup = (TaskMetricGroup)Mockito.mock(TaskMetricGroup.class);
        Mockito.when((Object)taskMetricGroup.getIOMetricGroup()).thenReturn(Mockito.mock(TaskIOMetricGroup.class));
        this.task = new Task((JobInformation)Mockito.mock(JobInformation.class), new TaskInformation(new JobVertexID(), "test task name", 1, 1, "foobar", new Configuration()), (ExecutionAttemptID)Mockito.mock(ExecutionAttemptID.class), (AllocationID)Mockito.mock(AllocationID.class), 0, 0, Collections.emptyList(), Collections.emptyList(), 0, (TaskStateHandles)Mockito.mock(TaskStateHandles.class), (MemoryManager)Mockito.mock(MemoryManager.class), (IOManager)Mockito.mock(IOManager.class), (NetworkEnvironment)Mockito.mock(NetworkEnvironment.class), (BroadcastVariableManager)Mockito.mock(BroadcastVariableManager.class), (TaskManagerActions)Mockito.mock(TaskManagerActions.class), (InputSplitProvider)Mockito.mock(InputSplitProvider.class), (CheckpointResponder)Mockito.mock(CheckpointResponder.class), (LibraryCacheManager)Mockito.mock(LibraryCacheManager.class), (FileCache)Mockito.mock(FileCache.class), tmRuntimeInfo, taskMetricGroup, (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class), (PartitionProducerStateChecker)Mockito.mock(PartitionProducerStateChecker.class), (Executor)Mockito.mock(Executor.class));
        Field f = this.task.getClass().getDeclaredField("invokable");
        f.setAccessible(true);
        f.set(this.task, taskMock);
        Field f2 = this.task.getClass().getDeclaredField("executionState");
        f2.setAccessible(true);
        f2.set(this.task, ExecutionState.RUNNING);
    }

    @Test(timeout=20000L)
    public void testStopExecution() throws Exception {
        StoppableTestTask taskMock = new StoppableTestTask();
        this.doMocking(taskMock);
        this.task.stopExecution();
        while (!taskMock.stopCalled) {
            Thread.sleep(100L);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testStopExecutionFail() throws Exception {
        AbstractInvokable taskMock = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.doMocking(taskMock);
        this.task.stopExecution();
    }

    private static final class StoppableTestTask
    extends AbstractInvokable
    implements StoppableTask {
        public volatile boolean stopCalled = false;

        private StoppableTestTask() {
        }

        public void invoke() throws Exception {
        }

        public void stop() {
            this.stopCalled = true;
        }
    }
}

