/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.pattern.package$;
import akka.testkit.CallingThreadDispatcher$;
import akka.util.Timeout$;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.testingUtils.TestingCluster$;
import org.apache.flink.runtime.testingUtils.TestingJobManager;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingMemoryArchivist;
import org.apache.flink.runtime.testingUtils.TestingMessages$Alive$;
import org.apache.flink.runtime.testingUtils.TestingTaskManager;
import org.apache.flink.runtime.testingUtils.TestingTaskManagerMessages;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B\u0001\u0003\u00015\u0011a\u0002V3ti&twm\u00117vgR,'O\u0003\u0002\u0004\t\u0005aA/Z:uS:<W\u000b^5mg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u00175Lg.[2mkN$XM]\u0005\u0003'A\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'\u000fC\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u00179\u0005\tRo]3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002\u001c1\ti1i\u001c8gS\u001e,(/\u0019;j_:L!!F\u000f\n\u0005y\u0001\"\u0001\u0005$mS:\\W*\u001b8j\u00072,8\u000f^3s\u0011%\u0001\u0003A!A!\u0002\u0013\ts%\u0001\riS\u001eD\u0017I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dKN\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0003\u0002!!Lw\r[1wC&d\u0017MY5mSRL\u0018B\u0001\u0014$\u0005aA\u0015n\u001a5Bm\u0006LG.\u00192jY&$\u0018pU3sm&\u001cWm]\u0005\u0003AuA\u0011\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0019\u0002#MLgn\u001a7f\u0003\u000e$xN]*zgR,W\u000e\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0004C_>dW-\u00198\n\u0005Ej\u0012\u0001F;tKNKgn\u001a7f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00054\u0001\t\u0005\t\u0015!\u0003+\u0003U\u0019\u0018P\\2ie>tw.^:ESN\u0004\u0018\r^2iKJDQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD#B\u001c:umb\u0004C\u0001\u001d\u0001\u001b\u0005\u0011\u0001\"B\u000b5\u0001\u00041\u0002\"\u0002\u00115\u0001\u0004\t\u0003\"B\u00155\u0001\u0004Q\u0003\"B\u001a5\u0001\u0004Q\u0003\"B\u001b\u0001\t\u0003qD\u0003B\u001c@\u0001\u0006CQ!F\u001fA\u0002YAQ!K\u001fA\u0002)BQaM\u001fA\u0002)BQ!\u000e\u0001\u0005\u0002\r#2a\u000e#F\u0011\u0015)\"\t1\u0001\u0017\u0011\u0015I#\t1\u0001+\u0011\u0015)\u0004\u0001\"\u0001H)\t9\u0004\nC\u0003\u0016\r\u0002\u0007a\u0003C\u0004K\u0001\t\u0007I\u0011I&\u0002\u001f)|'-T1oC\u001e,'o\u00117bgN,\u0012\u0001\u0014\u0019\u0003\u001bZ\u00032AT)U\u001d\tYs*\u0003\u0002QY\u00051\u0001K]3eK\u001aL!AU*\u0003\u000b\rc\u0017m]:\u000b\u0005Ac\u0003CA+W\u0019\u0001!\u0011b\u0016-\u0002\u0002\u0003\u0005)\u0011\u00010\u0003\u0007}#\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006IAW\u0001\u0011U>\u0014W*\u00198bO\u0016\u00148\t\\1tg\u0002\u0002$aW/\u0011\u00079\u000bF\f\u0005\u0002V;\u0012Iq\u000bWA\u0001\u0002\u0003\u0015\tAX\t\u0003?\n\u0004\"a\u000b1\n\u0005\u0005d#a\u0002(pi\"Lgn\u001a\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u0012\t!B[8c[\u0006t\u0017mZ3s\u0013\t9GM\u0001\u0006K_\nl\u0015M\\1hKJDq!\u001b\u0001C\u0002\u0013\u0005#.\u0001\u000bsKN|WO]2f\u001b\u0006t\u0017mZ3s\u00072\f7o]\u000b\u0002WB\u0012AN\u001c\t\u0004\u001dFk\u0007CA+o\t%y\u0007/!A\u0001\u0002\u000b\u0005aOA\u0002`IIBa!\u001d\u0001!\u0002\u0013\u0011\u0018!\u0006:fg>,(oY3NC:\fw-\u001a:DY\u0006\u001c8\u000f\t\u0019\u0003gV\u00042AT)u!\t)V\u000fB\u0005pa\u0006\u0005\t\u0011!B\u0001mF\u0011ql\u001e\u0019\u0003q~\u00042!\u001f?\u007f\u001b\u0005Q(BA>\u0005\u0003A\u0019G.^:uKJ4'/Y7fo>\u00148.\u0003\u0002~u\n!b\t\\5oWJ+7o\\;sG\u0016l\u0015M\\1hKJ\u0004\"!V@\u0005\u0019\u0005\u0005\u00111AA\u0001\u0002\u0003\u0015\t!!\u0002\u0003\u0007}#3\u0007B\u0005pa\u0006\u0005\u0019\u0011!B\u0001mF\u0019q,a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004{\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t\"a\u0003\u0003+I+7o\\;sG\u0016LEIU3ue&,g/\u00192mK\"I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0013qC\u0001\u0011i\u0006\u001c8.T1oC\u001e,'o\u00117bgN,\"!!\u00071\t\u0005m\u0011q\u0004\t\u0005\u001dF\u000bi\u0002E\u0002V\u0003?!A\"!\t\u0002$\u0005\u0005\t\u0011!B\u0001\u0003_\u00111a\u0018\u00135\u0011!\t)\u0003\u0001Q\u0001\n\u0005\u001d\u0012!\u0005;bg.l\u0015M\\1hKJ\u001cE.Y:tAA\"\u0011\u0011FA\u0017!\u0011q\u0015+a\u000b\u0011\u0007U\u000bi\u0003\u0002\u0007\u0002\"\u0005\r\u0012\u0011!A\u0001\u0006\u0003\ty#E\u0002`\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0011a\u0003;bg.l\u0017M\\1hKJLA!a\u000f\u00026\tYA+Y:l\u001b\u0006t\u0017mZ3s\u0011%\ty\u0004\u0001b\u0001\n\u0003\n\t%\u0001\u000bnK6|'/_!sG\"Lg/[:u\u00072\f7o]\u000b\u0003\u0003\u0007\u0002D!!\u0012\u0002JA!a*UA$!\r)\u0016\u0011\n\u0003\r\u0003\u0017\ni%!A\u0001\u0002\u000b\u0005\u0011\u0011\f\u0002\u0004?\u0012*\u0004\u0002CA(\u0001\u0001\u0006I!!\u0015\u0002+5,Wn\u001c:z\u0003J\u001c\u0007.\u001b<jgR\u001cE.Y:tAA\"\u00111KA,!\u0011q\u0015+!\u0016\u0011\u0007U\u000b9\u0006\u0002\u0007\u0002L\u00055\u0013\u0011!A\u0001\u0006\u0003\tI&E\u0002`\u00037\u00022aYA/\u0013\r\ty\u0006\u001a\u0002\u0010\u001b\u0016lwN]=Be\u000eD\u0017N^5ti\"9\u00111\r\u0001\u0005B\u0005\u0015\u0014AE4fi*{'-T1oC\u001e,'\u000f\u0015:paN$\u0002%a\u001a\u0002x\u0005\r\u0015QQAO\u0003O\u000b9,!2\u0002Z\u0006\r\u0018q\u001fB\u0005\u00053\u0011\u0019Ca\r\u00038A!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!B1di>\u0014(BAA9\u0003\u0011\t7n[1\n\t\u0005U\u00141\u000e\u0002\u0006!J|\u0007o\u001d\u0005\b\u0015\u0006\u0005\u0004\u0019AA=a\u0011\tY(a \u0011\t9\u000b\u0016Q\u0010\t\u0004+\u0006}DaCAA\u0003o\n\t\u0011!A\u0003\u0002y\u00131a\u0018\u00137\u0011\u0019I\u0012\u0011\ra\u0001-!A\u0011qQA1\u0001\u0004\tI)\u0001\bgkR,(/Z#yK\u000e,Ho\u001c:\u0011\t\u0005-\u0015\u0011T\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005M\u0015QS\u0001\u0005kRLGN\u0003\u0002\u0002\u0018\u0006!!.\u0019<b\u0013\u0011\tY*!$\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0005\u0002 \u0006\u0005\u0004\u0019AAQ\u0003)Iw.\u0012=fGV$xN\u001d\t\u0005\u0003\u0017\u000b\u0019+\u0003\u0003\u0002&\u00065%\u0001C#yK\u000e,Ho\u001c:\t\u0011\u0005%\u0016\u0011\ra\u0001\u0003W\u000bq\"\u001b8ti\u0006t7-Z'b]\u0006<WM\u001d\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\u0003\u0002\u0011%t7\u000f^1oG\u0016LA!!.\u00020\ny\u0011J\\:uC:\u001cW-T1oC\u001e,'\u000f\u0003\u0005\u0002:\u0006\u0005\u0004\u0019AA^\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002>\u0006\u0005WBAA`\u0015\r\tI\fZ\u0005\u0005\u0003\u0007\fyLA\u0005TG\",G-\u001e7fe\"A\u0011qYA1\u0001\u0004\tI-A\nmS\n\u0014\u0018M]=DC\u000eDW-T1oC\u001e,'\u000f\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\u00191L'M]1ss\u000e\f7\r[3\u000b\u0007\u0005MG!A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011q[Ag\u0005]\u0011En\u001c2MS\n\u0014\u0018M]=DC\u000eDW-T1oC\u001e,'\u000f\u0003\u0005\u0002\\\u0006\u0005\u0004\u0019AAo\u0003\u001d\t'o\u00195jm\u0016\u0004B!!\u001b\u0002`&!\u0011\u0011]A6\u0005!\t5\r^8s%\u00164\u0007\u0002CAs\u0003C\u0002\r!a:\u0002-I,7\u000f^1siN#(/\u0019;fOf4\u0015m\u0019;pef\u0004B!!;\u0002t6\u0011\u00111\u001e\u0006\u0005\u0003[\fy/A\u0004sKN$\u0018M\u001d;\u000b\u0007\u0005EH!\u0001\bfq\u0016\u001cW\u000f^5p]\u001e\u0014\u0018\r\u001d5\n\t\u0005U\u00181\u001e\u0002\u0017%\u0016\u001cH/\u0019:u'R\u0014\u0018\r^3hs\u001a\u000b7\r^8ss\"A\u0011\u0011`A1\u0001\u0004\tY0A\u0004uS6,w.\u001e;\u0011\t\u0005u(QA\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005AA-\u001e:bi&|gNC\u0002\u0002\u00102JAAa\u0002\u0002\u0000\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\u0002\u0003B\u0006\u0003C\u0002\rA!\u0004\u0002+1,\u0017\rZ3s\u000b2,7\r^5p]N+'O^5dKB!!q\u0002B\u000b\u001b\t\u0011\tBC\u0002\u0003\u0014\u0011\ta\u0002\\3bI\u0016\u0014X\r\\3di&|g.\u0003\u0003\u0003\u0018\tE!!\u0006'fC\u0012,'/\u00127fGRLwN\\*feZL7-\u001a\u0005\t\u00057\t\t\u00071\u0001\u0003\u001e\u000512/\u001e2nSR$X\r\u001a&pE\u001e\u0013\u0018\r\u001d5Ti>\u0014X\rE\u0002d\u0005?I1A!\te\u0005Y\u0019VOY7jiR,GMS8c\u000fJ\f\u0007\u000f[*u_J,\u0007\u0002\u0003B\u0013\u0003C\u0002\rAa\n\u00023\rDWmY6q_&tGOU3d_Z,'/\u001f$bGR|'/\u001f\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)\u0019!Q\u0006\u0003\u0002\u0015\rDWmY6q_&tG/\u0003\u0003\u00032\t-\"!G\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef4\u0015m\u0019;pefD\u0001B!\u000e\u0002b\u0001\u0007\u00111`\u0001\u0013U>\u0014'+Z2pm\u0016\u0014\u0018\u0010V5nK>,H\u000f\u0003\u0005\u0003:\u0005\u0005\u0004\u0019\u0001B\u001e\u0003=iW\r\u001e:jGN\u0014VmZ5tiJL\b#B\u0016\u0003>\t\u0005\u0013b\u0001B Y\t1q\n\u001d;j_:\u0004BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000f\"\u0011aB7fiJL7m]\u0005\u0005\u0005\u0017\u0012)E\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\t\u000f\t=\u0003\u0001\"\u0001\u0003R\u0005ar/Y5u\r>\u0014H+Y:l\u001b\u0006t\u0017mZ3sgR{')Z!mSZ,GC\u0001B*!\rY#QK\u0005\u0004\u0005/b#\u0001B+oSRDcA!\u0014\u0003\\\t]\u0004#B\u0016\u0003^\t\u0005\u0014b\u0001B0Y\t1A\u000f\u001b:poN\u00042!\u0016B2\t\u001d\u0011)\u0007\u0001b\u0001\u0005O\u0012\u0011\u0001V\t\u0004?\n%\u0004\u0003\u0002B6\u0005cr1a\u000bB7\u0013\r\u0011y\u0007L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019H!\u001e\u0003\u0013QC'o\\<bE2,'b\u0001B8Y\r\u0012!\u0011\u0010\t\u0005\u0005w\u00129I\u0004\u0003\u0003~\t5d\u0002\u0002B@\u0005\u000bk!A!!\u000b\u0007\t\rE\"\u0001\u0004=e>|GOP\u0005\u0002[%!!\u0011\u0012B;\u0005QIe\u000e^3seV\u0004H/\u001a3Fq\u000e,\u0007\u000f^5p]\"2!Q\nBG\u0005'\u0003Ra\u000bB/\u0005\u001f\u00032!\u0016BI\t\u001d\u0011)\u0007\u0001b\u0001\u0005O\u001a#A!&\u0011\t\u0005-%qS\u0005\u0005\u00053\u000biI\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\"9!Q\u0014\u0001\u0005\u0002\tE\u0013AF<bSR4uN]!di>\u00148\u000fV8CK\u0006c\u0017N^3)\r\tm%\u0011\u0015B<!\u0015Y#Q\fBR!\r)&Q\u0015\u0003\b\u0005K\u0002!\u0019\u0001B4Q\u0019\u0011YJ!+\u0003\u0014B)1F!\u0018\u0003,B\u0019QK!,\u0005\u000f\t\u0015\u0004A1\u0001\u0003h!9!\u0011\u0017\u0001\u0005\u0002\tM\u0016!L<bSR4uN\u001d+bg.l\u0015M\\1hKJ\u001cHk\u001c\"f%\u0016<\u0017n\u001d;fe\u0016$\u0017\t\u001e&pE6\u000bg.Y4feR!!1\u000bB[\u0011!\u00119La,A\u0002\u0005u\u0017A\u00036pE6\u000bg.Y4fe\"9!1\u0018\u0001\u0005\u0002\tE\u0013\u0001\u0007:fgR\f'\u000f\u001e'fC\u0012Lgn\u001a&pE6\u000bg.Y4fe\"9!q\u0018\u0001\u0005\u0002\t\u0005\u0017A\u0005:fgR\f'\u000f\u001e+bg.l\u0015M\\1hKJ$BAa\u0015\u0003D\"A!Q\u0019B_\u0001\u0004\u00119-A\u0003j]\u0012,\u0007\u0010E\u0002,\u0005\u0013L1Aa3-\u0005\rIe\u000e\u001e\u0005\b\u0005\u001f\u0004A\u0011\u0001B)\u00039\tG\r\u001a+bg.l\u0015M\\1hKJDqAa5\u0001\t\u0003\u0011).\u0001\tue&<w-\u001a:TCZ,\u0007o\\5oiR!!q\u001bBo!\rq%\u0011\\\u0005\u0004\u00057\u001c&AB*ue&tw\r\u0003\u0005\u0003`\nE\u0007\u0019\u0001Bq\u0003\u0015QwNY%e!\u0011\u0011\u0019O!<\u000e\u0005\t\u0015(\u0002\u0002Bt\u0005S\faaY8n[>t'b\u0001Bv\r\u0005\u0019\u0011\r]5\n\t\t=(Q\u001d\u0002\u0006\u0015>\u0014\u0017\n\u0012\u0015\u0007\u0005#\u0014\u0019P!?\u0011\u000b-\u0012iF!>\u0011\u0007U\u00139\u0010B\u0004\u0003f\u0001\u0011\rAa\u001a$\u0005\tm\b\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\t\r\u0005\u0011QS\u0001\u0003S>LAa!\u0002\u0003\u0000\nY\u0011jT#yG\u0016\u0004H/[8o\u0011\u001d\u0019I\u0001\u0001C\u0001\u0007\u0017\t\u0001C]3rk\u0016\u001cHoU1wKB|\u0017N\u001c;\u0015\t\r51\u0011\u0004\t\u0005\u0007\u001f\u0019)\"\u0004\u0002\u0004\u0012)!11\u0003B\u0016\u0003%\u0019\u0018M^3q_&tG/\u0003\u0003\u0004\u0018\rE!!C*bm\u0016\u0004x.\u001b8u\u0011!\u0019Yba\u0002A\u0002\t]\u0017!D:bm\u0016\u0004x.\u001b8u!\u0006$\b\u000e\u000b\u0004\u0004\b\r}!\u0011 \t\u0006W\tu3\u0011\u0005\t\u0004+\u000e\rBa\u0002B3\u0001\t\u0007!q\r\u0005\b\u0007O\u0001A\u0011AB\u0015\u0003A!\u0017n\u001d9pg\u0016\u001c\u0016M^3q_&tG\u000f\u0006\u0003\u0003T\r-\u0002\u0002CB\u000e\u0007K\u0001\rAa6)\r\r\u00152q\u0006B}!\u0015Y#QLB\u0019!\r)61\u0007\u0003\b\u0005K\u0002!\u0019\u0001B4\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0007o!\u0002Ba6\u0004:\rm21\t\u0005\t\u0005?\u001c)\u00041\u0001\u0003b\"A!qWB\u001b\u0001\u0004\u0019i\u0004\u0005\u0003\u0002.\u000e}\u0012\u0002BB!\u0003_\u0013A\"Q2u_J<\u0015\r^3xCfD\u0001\"!?\u00046\u0001\u0007\u00111 \u0015\u0007\u0007k\u00199E!?\u0011\u000b-\u0012if!\u0013\u0011\u0007U\u001bY\u0005B\u0004\u0003f\u0001\u0011\rAa\u001a\t\u000f\r%\u0001\u0001\"\u0001\u0004PQA1QBB)\u0007'\u001a)\u0006\u0003\u0005\u0004\u001c\r5\u0003\u0019\u0001Bl\u0011!\u00119l!\u0014A\u0002\ru\u0002\u0002CA}\u0007\u001b\u0002\r!a?)\r\r53\u0011\fB}!\u0015Y#QLB.!\r)6Q\f\u0003\b\u0005K\u0002!\u0019\u0001B4\u0011\u001d\u00199\u0003\u0001C\u0001\u0007C\"\u0002Ba\u0015\u0004d\r\u00154q\r\u0005\t\u00077\u0019y\u00061\u0001\u0003X\"A!qWB0\u0001\u0004\u0019i\u0004\u0003\u0005\u0002z\u000e}\u0003\u0019AA~Q\u0019\u0019yfa\u001b\u0003zB)1F!\u0018\u0004nA\u0019Qka\u001c\u0005\u000f\t\u0015\u0004A1\u0001\u0003h\u001d911\u000f\u0002\t\u0002\rU\u0014A\u0004+fgRLgnZ\"mkN$XM\u001d\t\u0004q\r]dAB\u0001\u0003\u0011\u0003\u0019Ih\u0005\u0003\u0004x\rm\u0004cA\u0016\u0004~%\u00191q\u0010\u0017\u0003\r\u0005s\u0017PU3g\u0011\u001d)4q\u000fC\u0001\u0007\u0007#\"a!\u001e\t\u0015\r\u001d5q\u000fb\u0001\n\u0003\u0019I)\u0001\u000bN\u0003b{&+R*U\u0003J#v\fR+S\u0003RKuJT\u000b\u0003\u0003wD\u0011b!$\u0004x\u0001\u0006I!a?\u0002+5\u000b\u0005l\u0018*F'R\u000b%\u000bV0E+J\u000bE+S(OA\u0001")
public class TestingCluster
extends LocalFlinkMiniCluster {
    private final boolean synchronousDispatcher;
    private final Class<? extends JobManager> jobManagerClass;
    private final Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass;
    private final Class<? extends TaskManager> taskManagerClass;
    private final Class<? extends MemoryArchivist> memoryArchivistClass;

    public static FiniteDuration MAX_RESTART_DURATION() {
        return TestingCluster$.MODULE$.MAX_RESTART_DURATION();
    }

    public Class<? extends JobManager> jobManagerClass() {
        return this.jobManagerClass;
    }

    public Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass() {
        return this.resourceManagerClass;
    }

    public Class<? extends TaskManager> taskManagerClass() {
        return this.taskManagerClass;
    }

    public Class<? extends MemoryArchivist> memoryArchivistClass() {
        return this.memoryArchivistClass;
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobLibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, Option<MetricRegistry> metricsRegistry) {
        Props props = super.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, metricsRegistry);
        return this.synchronousDispatcher ? props.withDispatcher(CallingThreadDispatcher$.MODULE$.Id()) : props;
    }

    public void waitForTaskManagersToBeAlive() throws TimeoutException, InterruptedException {
        Seq aliveFutures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestingCluster $outer;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$1) {
                return (Seq)x$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Future<Object> apply(ActorRef tm) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(tm), (Object)TestingMessages$Alive$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer().timeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ TestingCluster org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Future combinedFuture = Future$.MODULE$.sequence((TraversableOnce)aliveFutures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext());
        Await$.MODULE$.ready((Awaitable)combinedFuture, (Duration)this.timeout());
    }

    public void waitForActorsToBeAlive() throws TimeoutException, InterruptedException {
        Seq tmsAliveFutures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestingCluster $outer;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$2) {
                return (Seq)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Future<Object> apply(ActorRef tm) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(tm), (Object)TestingMessages$Alive$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer().timeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ TestingCluster org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq jmsAliveFutures = (Seq)this.jobManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestingCluster $outer;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$3) {
                return (Seq)x$3.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Future<Object> apply(ActorRef jm) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(jm), (Object)TestingMessages$Alive$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer().timeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ TestingCluster org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq resourceManagersAliveFutures = (Seq)this.resourceManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestingCluster $outer;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$4) {
                return (Seq)x$4.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Future<Object> apply(ActorRef rm) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(rm), (Object)TestingMessages$Alive$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer().timeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ TestingCluster org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Future combinedFuture = Future$.MODULE$.sequence((TraversableOnce)((TraversableLike)tmsAliveFutures.$plus$plus((GenTraversableOnce)jmsAliveFutures, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)resourceManagersAliveFutures, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext());
        Await$.MODULE$.ready((Awaitable)combinedFuture, (Duration)this.timeout());
    }

    public void waitForTaskManagersToBeRegisteredAtJobManager(ActorRef jobManager) {
        Seq futures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this, jobManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestingCluster $outer;
            public final ActorRef jobManager$1;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$5) {
                return (Seq)x$5.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final Future<Object> apply(ActorRef tm) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(tm), (Object)new TestingTaskManagerMessages.NotifyWhenRegisteredAtJobManager(this.$outer.jobManager$1), Timeout$.MODULE$.durationToTimeout(this.$outer.org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer().timeout()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ TestingCluster org$apache$flink$runtime$testingUtils$TestingCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.jobManager$1 = jobManager$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        try {
            Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)this.timeout());
            return;
        }
        catch (TimeoutException timeoutException) {
            throw new Exception(new StringBuilder().append((Object)"Timeout while waiting for TaskManagers to register at ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManager.path()}))).toString());
        }
    }

    public synchronized void restartLeadingJobManager() {
        Tuple2 tuple2 = new Tuple2((Object)this.jobManagerActorSystems(), (Object)this.jobManagerActors());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq jmActorSystems = (Seq)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Seq jmActors = (Seq)some2.x();
                    ActorGateway leader = this.getLeaderGateway(AkkaUtils$.MODULE$.getTimeout(this.originalConfiguration()));
                    int index = this.getLeaderIndex(AkkaUtils$.MODULE$.getTimeout(this.originalConfiguration()));
                    int port = this.getLeaderRPCPort();
                    int oldPort = this.originalConfiguration().getInteger("jobmanager.rpc.port", 0);
                    this.originalConfiguration().setInteger("jobmanager.rpc.port", port);
                    this.clearLeader();
                    Future stopped = Patterns$.MODULE$.gracefulStop(leader.actor(), TestingCluster$.MODULE$.MAX_RESTART_DURATION());
                    Await$.MODULE$.result((Awaitable)stopped, (Duration)TestingCluster$.MODULE$.MAX_RESTART_DURATION());
                    if (!super.useSingleActorSystem()) {
                        ((ActorSystem)jmActorSystems.apply(index)).shutdown();
                        ((ActorSystem)jmActorSystems.apply(index)).awaitTermination();
                    }
                    ActorSystem newJobManagerActorSystem = super.useSingleActorSystem() ? (ActorSystem)jmActorSystems.head() : this.startJobManagerActorSystem(index);
                    this.originalConfiguration().setInteger("jobmanager.rpc.port", oldPort);
                    ActorRef newJobManagerActor = this.startJobManager(index, newJobManagerActorSystem);
                    this.jobManagerActors_$eq((Option)new Some(jmActors.patch(index, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{newJobManagerActor})), 1, Seq$.MODULE$.canBuildFrom())));
                    this.jobManagerActorSystems_$eq((Option)new Some(jmActorSystems.patch(index, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorSystem[]{newJobManagerActorSystem})), 1, Seq$.MODULE$.canBuildFrom())));
                    this.jobManagerLeaderRetrievalService().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(LeaderRetrievalService x$6) {
                            x$6.stop();
                        }
                    });
                    this.jobManagerLeaderRetrievalService_$eq(Option$.MODULE$.apply((Object)super.highAvailabilityServices().getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID)));
                    this.jobManagerLeaderRetrievalService().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TestingCluster $outer;

                        public final void apply(LeaderRetrievalService x$7) {
                            x$7.start((LeaderRetrievalListener)this.$outer);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        throw new Exception("The JobManager of the TestingCluster have not been started properly.");
    }

    public void restartTaskManager(int index) {
        Tuple2 tuple2 = new Tuple2((Object)this.taskManagerActorSystems(), (Object)this.taskManagerActors());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq tmActorSystems = (Seq)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Seq tmActors = (Seq)some2.x();
                    Future stopped = Patterns$.MODULE$.gracefulStop((ActorRef)tmActors.apply(index), TestingCluster$.MODULE$.MAX_RESTART_DURATION());
                    Await$.MODULE$.result((Awaitable)stopped, (Duration)TestingCluster$.MODULE$.MAX_RESTART_DURATION());
                    if (!super.useSingleActorSystem()) {
                        ((ActorSystem)tmActorSystems.apply(index)).shutdown();
                        ((ActorSystem)tmActorSystems.apply(index)).awaitTermination();
                    }
                    ActorSystem taskManagerActorSystem = super.useSingleActorSystem() ? (ActorSystem)tmActorSystems.head() : this.startTaskManagerActorSystem(index);
                    ActorRef taskManagerActor = this.startTaskManager(index, taskManagerActorSystem);
                    this.taskManagerActors_$eq((Option)new Some(tmActors.patch(index, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{taskManagerActor})), 1, Seq$.MODULE$.canBuildFrom())));
                    this.taskManagerActorSystems_$eq((Option)new Some(tmActorSystems.patch(index, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorSystem[]{taskManagerActorSystem})), 1, Seq$.MODULE$.canBuildFrom())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        throw new Exception("The TaskManager of the TestingCluster have not been started properly.");
    }

    public void addTaskManager() {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!this.useSingleActorSystem()) break block2;
                        Tuple2 tuple2 = new Tuple2((Object)this.jobManagerActorSystems(), (Object)this.taskManagerActors());
                        if (tuple2 == null) break block3;
                        Option option = (Option)tuple2._1();
                        Option option2 = (Option)tuple2._2();
                        if (!(option instanceof Some)) break block3;
                        Some some = (Some)option;
                        Seq jmSystems = (Seq)some.x();
                        if (!(option2 instanceof Some)) break block3;
                        Some some2 = (Some)option2;
                        Seq tmActors = (Seq)some2.x();
                        int index = this.numTaskManagers();
                        this.taskManagerActors_$eq((Option)new Some(tmActors.$colon$plus((Object)this.startTaskManager(index, (ActorSystem)jmSystems.apply(0)), Seq$.MODULE$.canBuildFrom())));
                        this.numTaskManagers_$eq(this.numTaskManagers() + 1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    throw new IllegalStateException("Cluster has not been started properly.");
                }
                Tuple2 tuple2 = new Tuple2((Object)this.taskManagerActorSystems(), (Object)this.taskManagerActors());
                if (tuple2 == null) break block5;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Seq tmSystems = (Seq)some.x();
                if (!(option3 instanceof Some)) break block5;
                Some some3 = (Some)option3;
                Seq tmActors = (Seq)some3.x();
                int index = this.numTaskManagers();
                ActorSystem newTmSystem = this.startTaskManagerActorSystem(index);
                ActorRef newTmActor = this.startTaskManager(index, newTmSystem);
                this.taskManagerActorSystems_$eq((Option)new Some(tmSystems.$colon$plus((Object)newTmSystem, Seq$.MODULE$.canBuildFrom())));
                this.taskManagerActors_$eq((Option)new Some(tmActors.$colon$plus((Object)newTmActor, Seq$.MODULE$.canBuildFrom())));
                this.numTaskManagers_$eq(this.numTaskManagers() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalStateException("Cluster has not been started properly.");
    }

    public String triggerSavepoint(JobID jobId) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(this.configuration());
        return this.triggerSavepoint(jobId, this.getLeaderGateway(timeout), timeout);
    }

    public Savepoint requestSavepoint(String savepointPath) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(this.configuration());
        return this.requestSavepoint(savepointPath, this.getLeaderGateway(timeout), timeout);
    }

    public void disposeSavepoint(String savepointPath) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(this.configuration());
        this.disposeSavepoint(savepointPath, this.getLeaderGateway(timeout), timeout);
    }

    public String triggerSavepoint(JobID jobId, ActorGateway jobManager, FiniteDuration timeout) throws IOException {
        Object result = Await$.MODULE$.result((Awaitable)jobManager.ask((Object)new JobManagerMessages.TriggerSavepoint(jobId, JobManagerMessages.TriggerSavepoint$.MODULE$.apply$default$2()), timeout), (Duration)timeout);
        Object object = result;
        if (object instanceof JobManagerMessages.TriggerSavepointSuccess) {
            JobManagerMessages.TriggerSavepointSuccess triggerSavepointSuccess = (JobManagerMessages.TriggerSavepointSuccess)object;
            String string = triggerSavepointSuccess.savepointPath();
            return string;
        }
        if (object instanceof JobManagerMessages.TriggerSavepointFailure) {
            JobManagerMessages.TriggerSavepointFailure triggerSavepointFailure = (JobManagerMessages.TriggerSavepointFailure)object;
            throw new IOException(triggerSavepointFailure.cause());
        }
        throw new IllegalStateException("Trigger savepoint failed");
    }

    public Savepoint requestSavepoint(String savepointPath, ActorGateway jobManager, FiniteDuration timeout) throws IOException {
        Object result = Await$.MODULE$.result((Awaitable)jobManager.ask((Object)new TestingJobManagerMessages.RequestSavepoint(savepointPath), timeout), (Duration)timeout);
        Object object = result;
        if (object instanceof TestingJobManagerMessages.ResponseSavepoint) {
            TestingJobManagerMessages.ResponseSavepoint responseSavepoint = (TestingJobManagerMessages.ResponseSavepoint)object;
            Savepoint savepoint = responseSavepoint.savepoint();
            return savepoint;
        }
        throw new IOException("Request savepoint failed");
    }

    public void disposeSavepoint(String savepointPath, ActorGateway jobManager, FiniteDuration timeout) throws IOException {
        Object result;
        FiniteDuration timeout2 = AkkaUtils$.MODULE$.getTimeout(this.originalConfiguration());
        ActorGateway jobManager2 = this.getLeaderGateway(timeout2);
        Object object = result = Await$.MODULE$.result((Awaitable)jobManager2.ask((Object)new JobManagerMessages.DisposeSavepoint(savepointPath), timeout2), (Duration)timeout2);
        JobManagerMessages.DisposeSavepointSuccess$ disposeSavepointSuccess$ = JobManagerMessages.DisposeSavepointSuccess$.MODULE$;
        Object object2 = object;
        if (!(disposeSavepointSuccess$ != null ? !disposeSavepointSuccess$.equals(object2) : object2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new IOException("Dispose savepoint failed");
    }

    public TestingCluster(Configuration userConfiguration, HighAvailabilityServices highAvailabilityServices, boolean singleActorSystem, boolean synchronousDispatcher) {
        this.synchronousDispatcher = synchronousDispatcher;
        super(userConfiguration, highAvailabilityServices, singleActorSystem);
        this.jobManagerClass = TestingJobManager.class;
        this.resourceManagerClass = TestingResourceManager.class;
        this.taskManagerClass = TestingTaskManager.class;
        this.memoryArchivistClass = TestingMemoryArchivist.class;
    }

    public TestingCluster(Configuration userConfiguration, boolean singleActorSystem, boolean synchronousDispatcher) {
        this(userConfiguration, HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices((Configuration)userConfiguration, (Executor)ExecutionContext$.MODULE$.global()), singleActorSystem, synchronousDispatcher);
    }

    public TestingCluster(Configuration userConfiguration, boolean singleActorSystem) {
        this(userConfiguration, singleActorSystem, false);
    }

    public TestingCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

