/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Kill$;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.apache.flink.runtime.testingUtils.TestingJobManager;
import org.apache.flink.runtime.testingUtils.TestingTaskManager;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.shaded.com.google.common.util.concurrent.MoreExecutors;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;

public final class TestingUtils$ {
    public static final TestingUtils$ MODULE$;
    private ScheduledExecutorService sharedExecutorInstance;
    private final Config testConfig;
    private final FiniteDuration TESTING_DURATION;
    private final FiniteDuration TESTING_TIMEOUT;
    private final String DEFAULT_AKKA_ASK_TIMEOUT;

    static {
        new TestingUtils$();
    }

    private ScheduledExecutorService sharedExecutorInstance() {
        return this.sharedExecutorInstance;
    }

    private void sharedExecutorInstance_$eq(ScheduledExecutorService x$1) {
        this.sharedExecutorInstance = x$1;
    }

    public Config testConfig() {
        return this.testConfig;
    }

    public FiniteDuration TESTING_DURATION() {
        return this.TESTING_DURATION;
    }

    public FiniteDuration TESTING_TIMEOUT() {
        return this.TESTING_TIMEOUT;
    }

    public String DEFAULT_AKKA_ASK_TIMEOUT() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT;
    }

    public String getDefaultTestingActorSystemConfigString() {
        String logLevel = AkkaUtils$.MODULE$.getLogLevel();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.daemonic = on\n      |akka.test.timefactor = 10\n      |akka.loggers = [\"akka.event.slf4j.Slf4jLogger\"]\n      |akka.loglevel = ", "\n      |akka.stdout-loglevel = OFF\n      |akka.jvm-exit-on-fatal-error = off\n      |akka.log-config-on-start = off\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logLevel})))).stripMargin();
    }

    public Config getDefaultTestingActorSystemConfig() {
        return this.testConfig();
    }

    public Time infiniteTime() {
        return Time.milliseconds((long)Integer.MAX_VALUE);
    }

    public TestingCluster startTestingCluster(int numSlots, int numTMs, String timeout) {
        Configuration config = new Configuration();
        config.setInteger("taskmanager.numberOfTaskSlots", numSlots);
        config.setInteger("local.number-taskmanager", numTMs);
        config.setString("akka.ask.timeout", timeout);
        TestingCluster cluster = new TestingCluster(config);
        cluster.start();
        return cluster;
    }

    public int startTestingCluster$default$2() {
        return 1;
    }

    public String startTestingCluster$default$3() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT();
    }

    public ExecutionContextExecutor defaultExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor((Executor)this.defaultExecutor());
    }

    public synchronized ScheduledExecutorService defaultExecutor() {
        if (this.sharedExecutorInstance() == null || this.sharedExecutorInstance().isShutdown()) {
            this.sharedExecutorInstance_$eq(Executors.newSingleThreadScheduledExecutor());
        }
        return this.sharedExecutorInstance();
    }

    public ScheduledExecutor defaultScheduledExecutor() {
        ScheduledExecutorService scheduledExecutorService = this.defaultExecutor();
        return new ScheduledExecutorServiceAdapter(scheduledExecutorService);
    }

    public ExecutionContextExecutor directExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(MoreExecutors.directExecutor());
    }

    public TestingUtils.QueuedActionExecutionContext queuedActionExecutionContext() {
        return new TestingUtils.QueuedActionExecutionContext(new TestingUtils.ActionQueue());
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, HighAvailabilityServices highAvailabilityServices, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        return this.createTaskManager(actorSystem, highAvailabilityServices, configuration, useLocalCommunication, waitForRegistration, TestingTaskManager.class);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, HighAvailabilityServices highAvailabilityServices, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration, Class<? extends TaskManager> taskManagerClass) {
        UUID uUID;
        Configuration resultingConfiguration = new Configuration();
        resultingConfiguration.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 10L);
        resultingConfiguration.addAll(configuration);
        ActorRef taskManager = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(resultingConfiguration, ResourceID.generate(), actorSystem, highAvailabilityServices, "localhost", (Option)None$.MODULE$, useLocalCommunication, taskManagerClass);
        if (waitForRegistration) {
            Future notificationResult = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages.NotifyWhenRegisteredAtJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.TESTING_DURATION())).mapTo(ClassTag$.MODULE$.apply(TaskManagerMessages.RegisteredAtJobManager.class));
            uUID = ((TaskManagerMessages.RegisteredAtJobManager)Await$.MODULE$.result((Awaitable)notificationResult, (Duration)this.TESTING_DURATION())).leaderId();
        } else {
            uUID = HighAvailabilityServices.DEFAULT_LEADER_ID;
        }
        UUID leaderId = uUID;
        return new AkkaActorGateway(taskManager, leaderId);
    }

    public void stopActor(ActorRef actor) {
        if (actor != null) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            Kill$ x$1 = Kill$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public void stopActor(ActorGateway actorGateway) {
        if (actorGateway != null) {
            this.stopActor(actorGateway.actor());
        }
    }

    public void stopActorGracefully(ActorRef actor) {
        Future gracefulStopFuture = Patterns$.MODULE$.gracefulStop(actor, this.TESTING_TIMEOUT());
        Await$.MODULE$.result((Awaitable)gracefulStopFuture, (Duration)this.TESTING_TIMEOUT());
    }

    public void stopActorGracefully(ActorGateway actorGateway) {
        this.stopActorGracefully(actorGateway.actor());
    }

    public void stopActorsGracefully(Seq<ActorRef> actors) {
        Seq gracefulStopFutures = (Seq)actors.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Future<Boolean>> apply(ActorRef actor) {
                Option option;
                block4: {
                    Iterable iterable;
                    block3: {
                        block2: {
                            option = Option$.MODULE$.apply((Object)actor);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            ActorRef actorRef = (ActorRef)some.x();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Patterns$.MODULE$.gracefulStop(actorRef, TestingUtils$.MODULE$.TESTING_TIMEOUT())));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)option);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExecutionContextExecutor executionContext = this.defaultExecutionContext();
        Future globalStopFuture = Future$.MODULE$.sequence((TraversableOnce)gracefulStopFutures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext);
        Await$.MODULE$.result((Awaitable)globalStopFuture, (Duration)this.TESTING_TIMEOUT());
    }

    public void stopActorsGracefully(List<ActorRef> actors) {
        this.stopActorsGracefully((Seq<ActorRef>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(actors).asScala()));
    }

    public void stopActorGatewaysGracefully(Seq<ActorGateway> actorGateways) {
        Seq actors = (Seq)actorGateways.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<ActorRef> apply(ActorGateway actorGateway) {
                Option option;
                block4: {
                    Iterable iterable;
                    block3: {
                        block2: {
                            option = Option$.MODULE$.apply((Object)actorGateway);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            ActorGateway actorGateway2 = (ActorGateway)some.x();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)actorGateway2.actor()));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)option);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.stopActorsGracefully((Seq<ActorRef>)actors);
    }

    public void stopActorGatewaysGracefully(List<ActorGateway> actorGateways) {
        this.stopActorGatewaysGracefully((Seq<ActorGateway>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(actorGateways).asScala()));
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, Configuration configuration, HighAvailabilityServices highAvailabilityServices) {
        return this.createJobManager(actorSystem, futureExecutor, ioExecutor, configuration, highAvailabilityServices, TestingJobManager.class, "");
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, Configuration configuration, HighAvailabilityServices highAvailabilityServices, String prefix) {
        return this.createJobManager(actorSystem, futureExecutor, ioExecutor, configuration, highAvailabilityServices, TestingJobManager.class, prefix);
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, Configuration configuration, HighAvailabilityServices highAvailabilityServices, Class<? extends JobManager> jobManagerClass) {
        return this.createJobManager(actorSystem, futureExecutor, ioExecutor, configuration, highAvailabilityServices, jobManagerClass, "");
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, ScheduledExecutorService futureExecutor, Executor ioExecutor, Configuration configuration, HighAvailabilityServices highAvailabilityServices, Class<? extends JobManager> jobManagerClass, String prefix) {
        configuration.setString(HighAvailabilityOptions.HA_MODE, ConfigConstants.DEFAULT_HA_MODE);
        Tuple2 tuple2 = JobManager$.MODULE$.startJobManagerActors(configuration, actorSystem, futureExecutor, ioExecutor, highAvailabilityServices, (Option)new Some((Object)new StringBuilder().append((Object)prefix).append((Object)"jobmanager").toString()), (Option)new Some((Object)new StringBuilder().append((Object)prefix).append((Object)"archive").toString()), jobManagerClass, MemoryArchivist.class);
        if (tuple2 != null) {
            ActorRef actor;
            ActorRef actorRef;
            ActorRef actor2 = actorRef = (actor = (ActorRef)tuple2._1());
            UUID leaderId = LeaderRetrievalUtils.retrieveLeaderSessionId((LeaderRetrievalService)highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), (FiniteDuration)this.TESTING_TIMEOUT());
            return new AkkaActorGateway(actor2, leaderId);
        }
        throw new MatchError((Object)tuple2);
    }

    public ActorGateway createForwardingActor(ActorSystem actorSystem, ActorRef forwardingTarget, UUID leaderId, Option<String> actorName) {
        Option<String> option;
        block4: {
            ActorRef actorRef;
            block3: {
                block2: {
                    option = actorName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, Option$.MODULE$.apply((Object)leaderId)})), name);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, Option$.MODULE$.apply((Object)leaderId)})));
            }
            ActorRef actor = actorRef;
            return new AkkaActorGateway(actor, leaderId);
        }
        throw new MatchError(option);
    }

    public Option<String> createForwardingActor$default$4() {
        return None$.MODULE$;
    }

    public ActorGateway createResourceManager(ActorSystem actorSystem, Configuration configuration, HighAvailabilityServices highAvailabilityServices) {
        ActorRef resourceManager = FlinkResourceManager.startResourceManagerActors((Configuration)configuration, (ActorSystem)actorSystem, (LeaderRetrievalService)highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), TestingResourceManager.class);
        UUID leaderId = LeaderRetrievalUtils.retrieveLeaderSessionId((LeaderRetrievalService)highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), (FiniteDuration)this.TESTING_TIMEOUT());
        return new AkkaActorGateway(resourceManager, leaderId);
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.testConfig = ConfigFactory.parseString((String)this.getDefaultTestingActorSystemConfigString());
        this.TESTING_DURATION = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minute();
        this.TESTING_TIMEOUT = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute();
        this.DEFAULT_AKKA_ASK_TIMEOUT = "200 s";
    }
}

