/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverableCompletedCheckpointStore
implements CompletedCheckpointStore {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverableCompletedCheckpointStore.class);
    private final ArrayDeque<CompletedCheckpoint> checkpoints = new ArrayDeque(2);
    private final ArrayDeque<CompletedCheckpoint> suspended = new ArrayDeque(2);

    public void recover(SharedStateRegistry sharedStateRegistry) throws Exception {
        this.checkpoints.addAll(this.suspended);
        this.suspended.clear();
        for (CompletedCheckpoint checkpoint : this.checkpoints) {
            checkpoint.registerSharedStatesAfterRestored(sharedStateRegistry);
        }
    }

    public void addCheckpoint(CompletedCheckpoint checkpoint) throws Exception {
        this.checkpoints.addLast(checkpoint);
        if (this.checkpoints.size() > 1) {
            CompletedCheckpoint checkpointToSubsume = this.checkpoints.removeFirst();
            checkpointToSubsume.discardOnSubsume();
        }
    }

    public CompletedCheckpoint getLatestCheckpoint() throws Exception {
        return this.checkpoints.isEmpty() ? null : this.checkpoints.getLast();
    }

    public void shutdown(JobStatus jobStatus) throws Exception {
        if (jobStatus.isGloballyTerminalState()) {
            this.checkpoints.clear();
            this.suspended.clear();
        } else {
            this.suspended.clear();
            for (CompletedCheckpoint checkpoint : this.checkpoints) {
                this.suspended.add(checkpoint);
            }
            this.checkpoints.clear();
        }
    }

    public List<CompletedCheckpoint> getAllCheckpoints() throws Exception {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    public int getMaxNumberOfRetainedCheckpoints() {
        return 1;
    }

    public boolean requiresExternalizedCheckpoints() {
        return false;
    }
}

