/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class EvictingBoundedListTest {
    @Test
    public void testAddGet() {
        int i;
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        Assert.assertTrue((boolean)list.isEmpty());
        for (i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        Assert.assertEquals((long)17L, (long)list.size());
        for (i = 0; i < insertSize; ++i) {
            int exp = i < insertSize - boundSize ? defaultElement : i;
            int act = (Integer)list.get(i);
            Assert.assertEquals((long)exp, (long)act);
        }
    }

    @Test
    public void testSet() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        ArrayList<Integer> reference = new ArrayList<Integer>(insertSize);
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        for (int i = 0; i < insertSize; ++i) {
            reference.add(i);
            list.add((Object)i);
        }
        Assert.assertEquals((long)reference.size(), (long)list.size());
        list.set(0, (Object)123);
        list.set(insertSize - boundSize - 1, (Object)123);
        list.set(insertSize - boundSize, (Object)42);
        reference.set(insertSize - boundSize, 42);
        list.set(13, (Object)43);
        reference.set(13, 43);
        list.set(16, (Object)44);
        reference.set(16, 44);
        try {
            list.set(insertSize, (Object)23);
            Assert.fail((String)"Illegal index in set not detected.");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        for (int i = 0; i < insertSize; ++i) {
            int exp = i < insertSize - boundSize ? defaultElement : (Integer)reference.get(i);
            int act = (Integer)list.get(i);
            Assert.assertEquals((long)exp, (long)act);
        }
        Assert.assertEquals((long)reference.size(), (long)list.size());
    }

    @Test
    public void testClear() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        for (int i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        list.clear();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        try {
            list.get(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() {
        int insertSize = 17;
        int boundSize = 5;
        Integer defaultElement = 4711;
        EvictingBoundedList list = new EvictingBoundedList(boundSize, (Object)defaultElement);
        Assert.assertTrue((boolean)list.isEmpty());
        for (int i = 0; i < insertSize; ++i) {
            list.add((Object)i);
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < insertSize; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            int exp = i < insertSize - boundSize ? defaultElement : i;
            int act = (Integer)iterator.next();
            Assert.assertEquals((long)exp, (long)act);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Next on exhausted iterator did not trigger exception.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        list.add((Object)123);
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"Concurrent modification not detected.");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testMapWithHalfFullList() {
        Object[] originals = new Object[]{new Object(), new Object(), new Object()};
        Object defaultValue = new Object();
        EvictingBoundedList original = new EvictingBoundedList(5, defaultValue);
        for (Object o : originals) {
            original.add(o);
        }
        EvictingBoundedList transformed = original.map((EvictingBoundedList.Function)new Mapper());
        Assert.assertEquals((long)original.size(), (long)transformed.size());
        Assert.assertEquals((long)original.getSizeLimit(), (long)transformed.getSizeLimit());
        Assert.assertEquals((Object)defaultValue, (Object)((TransformedObject)transformed.getDefaultElement()).original);
        int i = 0;
        for (TransformedObject to : transformed) {
            Assert.assertEquals((Object)originals[i++], (Object)to.original);
        }
        try {
            transformed.get(originals.length);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testMapWithEvictedElements() {
        Object[] originals = new Object[]{new Object(), new Object(), new Object(), new Object(), new Object()};
        Object defaultValue = new Object();
        EvictingBoundedList original = new EvictingBoundedList(2, defaultValue);
        for (Object o : originals) {
            original.add(o);
        }
        EvictingBoundedList transformed = original.map((EvictingBoundedList.Function)new Mapper());
        Assert.assertEquals((long)originals.length, (long)transformed.size());
        Assert.assertEquals((long)original.size(), (long)transformed.size());
        Assert.assertEquals((long)original.getSizeLimit(), (long)transformed.getSizeLimit());
        Assert.assertEquals((Object)defaultValue, (Object)((TransformedObject)transformed.getDefaultElement()).original);
        for (int i = 0; i < originals.length; ++i) {
            if (i < originals.length - transformed.getSizeLimit()) {
                Assert.assertEquals((Object)transformed.getDefaultElement(), (Object)transformed.get(i));
                continue;
            }
            Assert.assertEquals((Object)originals[i], (Object)((TransformedObject)transformed.get((int)i)).original);
        }
        try {
            transformed.get(originals.length);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testMapWithNullDefault() {
        EvictingBoundedList original = new EvictingBoundedList(5, null);
        EvictingBoundedList transformed = original.map((EvictingBoundedList.Function)new Mapper());
        Assert.assertEquals((long)original.size(), (long)transformed.size());
        Assert.assertNull((Object)transformed.getDefaultElement());
    }

    private static final class Mapper
    implements EvictingBoundedList.Function<Object, TransformedObject> {
        private Mapper() {
        }

        public TransformedObject apply(Object value) {
            return new TransformedObject(value);
        }
    }

    private static final class TransformedObject {
        final Object original;

        TransformedObject(Object original) {
            this.original = Preconditions.checkNotNull((Object)original);
        }
    }
}

