/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.SerializedThrowable;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class SerializedThrowableTest {
    @Test
    public void testIdenticalMessageAndStack() {
        try {
            IllegalArgumentException original = new IllegalArgumentException("test message");
            SerializedThrowable serialized = new SerializedThrowable((Throwable)original);
            Assert.assertEquals((Object)original.getMessage(), (Object)serialized.getMessage());
            Assert.assertEquals((Object)original.toString(), (Object)serialized.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)original), (Object)ExceptionUtils.stringifyException((Throwable)serialized));
            Assert.assertArrayEquals((Object[])original.getStackTrace(), (Object[])serialized.getStackTrace());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerialization() {
        try {
            Object serialized2;
            byte[] classData = new byte[]{-54, -2, -70, -66, 0, 0, 0, 51, 0, 21, 10, 0, 3, 0, 18, 7, 0, 19, 7, 0, 20, 1, 0, 16, 115, 101, 114, 105, 97, 108, 86, 101, 114, 115, 105, 111, 110, 85, 73, 68, 1, 0, 1, 74, 1, 0, 13, 67, 111, 110, 115, 116, 97, 110, 116, 86, 97, 108, 117, 101, 5, -103, -52, 22, -41, -23, -36, -25, 47, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 18, 76, 111, 99, 97, 108, 86, 97, 114, 105, 97, 98, 108, 101, 84, 97, 98, 108, 101, 1, 0, 4, 116, 104, 105, 115, 1, 0, 61, 76, 111, 114, 103, 47, 97, 112, 97, 99, 104, 101, 47, 102, 108, 105, 110, 107, 47, 114, 117, 110, 116, 105, 109, 101, 47, 117, 116, 105, 108, 47, 84, 101, 115, 116, 69, 120, 99, 101, 112, 116, 105, 111, 110, 70, 111, 114, 83, 101, 114, 105, 97, 108, 105, 122, 97, 116, 105, 111, 110, 59, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 34, 84, 101, 115, 116, 69, 120, 99, 101, 112, 116, 105, 111, 110, 70, 111, 114, 83, 101, 114, 105, 97, 108, 105, 122, 97, 116, 105, 111, 110, 46, 106, 97, 118, 97, 12, 0, 9, 0, 10, 1, 0, 59, 111, 114, 103, 47, 97, 112, 97, 99, 104, 101, 47, 102, 108, 105, 110, 107, 47, 114, 117, 110, 116, 105, 109, 101, 47, 117, 116, 105, 108, 47, 84, 101, 115, 116, 69, 120, 99, 101, 112, 116, 105, 111, 110, 70, 111, 114, 83, 101, 114, 105, 97, 108, 105, 122, 97, 116, 105, 111, 110, 1, 0, 19, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 69, 120, 99, 101, 112, 116, 105, 111, 110, 0, 33, 0, 2, 0, 3, 0, 0, 0, 1, 0, 26, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 2, 0, 7, 0, 1, 0, 1, 0, 9, 0, 10, 0, 1, 0, 11, 0, 0, 0, 47, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 2, 0, 12, 0, 0, 0, 6, 0, 1, 0, 0, 0, 21, 0, 13, 0, 0, 0, 12, 0, 1, 0, 0, 0, 5, 0, 14, 0, 15, 0, 0, 0, 1, 0, 16, 0, 0, 0, 2, 0, 17};
            URLClassLoader loader = new URLClassLoader(new URL[0]);
            Class clazz = MemoryUtils.UNSAFE.defineClass("org.apache.flink.runtime.util.TestExceptionForSerialization", classData, 0, classData.length, loader, new ProtectionDomain(new CodeSource(null, (Certificate[])null), new Permissions()));
            Exception userException = clazz.asSubclass(Exception.class).newInstance();
            try {
                serialized2 = InstantiationUtil.serializeObject((Object)userException);
                InstantiationUtil.deserializeObject((byte[])serialized2, (ClassLoader)this.getClass().getClassLoader());
                Assert.fail((String)"should fail with a class not found exception");
            }
            catch (ClassNotFoundException serialized2) {
                // empty catch block
            }
            serialized2 = new SerializedThrowable((Throwable)userException);
            Assert.assertEquals((Object)userException.getMessage(), (Object)serialized2.getMessage());
            Assert.assertEquals((Object)userException.toString(), (Object)serialized2.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)serialized2));
            Assert.assertArrayEquals((Object[])userException.getStackTrace(), (Object[])serialized2.getStackTrace());
            SerializedThrowable copy = (SerializedThrowable)CommonTestUtils.createCopySerializable((Serializable)serialized2);
            Assert.assertEquals((Object)userException.getMessage(), (Object)copy.getMessage());
            Assert.assertEquals((Object)userException.toString(), (Object)copy.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)copy));
            Assert.assertArrayEquals((Object[])userException.getStackTrace(), (Object[])copy.getStackTrace());
            Throwable deserialized = copy.deserializeError((ClassLoader)loader);
            Assert.assertEquals((Object)clazz, deserialized.getClass());
            Throwable wronglyDeserialized = copy.deserializeError(this.getClass().getClassLoader());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)wronglyDeserialized));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCauseChaining() {
        Exception cause2 = new Exception("level2");
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assert.assertEquals((Object)"level0", (Object)st.getMessage());
        Assert.assertNotNull((Object)st.getCause());
        Assert.assertEquals((Object)"level1", (Object)st.getCause().getMessage());
        Assert.assertNotNull((Object)st.getCause().getCause());
        Assert.assertEquals((Object)"level2", (Object)st.getCause().getCause().getMessage());
    }

    @Test
    public void testCyclicCauseChaining() {
        Exception cause3 = new Exception("level3");
        Exception cause2 = new Exception("level2", cause3);
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        cause3.initCause(cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assert.assertArrayEquals((Object[])root.getStackTrace(), (Object[])st.getStackTrace());
        Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)root), (Object)ExceptionUtils.stringifyException((Throwable)st));
    }

    @Test
    public void testCopyPreservesCause() {
        Exception original = new Exception("original message");
        Exception parent = new Exception("parent message", original);
        SerializedThrowable serialized = new SerializedThrowable((Throwable)parent);
        Assert.assertNotNull((Object)serialized.getCause());
        SerializedThrowable copy = new SerializedThrowable((Throwable)serialized);
        Assert.assertEquals((Object)"parent message", (Object)copy.getMessage());
        Assert.assertNotNull((Object)copy.getCause());
        Assert.assertEquals((Object)"original message", (Object)copy.getCause().getMessage());
    }
}

