/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.arn.Arn;
import com.amazonaws.regions.RegionUtils;
import javax.annotation.Nonnull;

public final class ArnResource {
    private final String name;
    private final String ownerAccountId;
    private final String region;
    private final String fullArn;
    private final String partition;
    private final String accessPointRegionKey;

    private ArnResource(String name, String owner, String region, String partition, String fullArn) {
        this.name = name;
        this.ownerAccountId = owner;
        this.region = region;
        this.partition = partition;
        this.fullArn = fullArn;
        this.accessPointRegionKey = String.format("accesspoint-%s", region);
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerAccountId() {
        return this.ownerAccountId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getFullArn() {
        return this.fullArn;
    }

    public String getEndpoint() {
        return RegionUtils.getRegion(this.accessPointRegionKey).getServiceEndpoint("s3");
    }

    @Nonnull
    public static ArnResource accessPointFromArn(String arn) throws IllegalArgumentException {
        Arn parsed = Arn.fromString(arn);
        if (parsed.getRegion().isEmpty() || parsed.getAccountId().isEmpty() || parsed.getResourceAsString().isEmpty()) {
            throw new IllegalArgumentException(String.format("Access Point Arn %s has an invalid format or missing properties", arn));
        }
        String resourceName = parsed.getResource().getResource();
        return new ArnResource(resourceName, parsed.getAccountId(), parsed.getRegion(), parsed.getPartition(), arn);
    }
}

