/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.Request;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.protocol.HttpContext;

public class HttpResponse {
    private final Request<?> request;
    private final HttpRequestBase httpRequest;
    private String statusText;
    private int statusCode;
    private InputStream content;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpContext context;

    public HttpResponse(Request<?> request, HttpRequestBase httpRequest) {
        this(request, httpRequest, null);
    }

    public HttpResponse(Request<?> request, HttpRequestBase httpRequest, HttpContext context) {
        this.request = request;
        this.httpRequest = httpRequest;
        this.context = context;
    }

    public Request<?> getRequest() {
        return this.request;
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String headerName) {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            if (!header.getKey().equalsIgnoreCase(headerName)) continue;
            return header.getValue();
        }
        return null;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getCRC32Checksum() {
        if (this.context == null) {
            return 0L;
        }
        CRC32ChecksumCalculatingInputStream crc32ChecksumInputStream = (CRC32ChecksumCalculatingInputStream)this.context.getAttribute(CRC32ChecksumCalculatingInputStream.class.getName());
        return crc32ChecksumInputStream == null ? 0L : crc32ChecksumInputStream.getCRC32Checksum();
    }
}

