/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry;

import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.PredefinedBackoffStrategies;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.RetryPolicy;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.RetryUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.V2CompatibleBackoffStrategy;

public class PredefinedRetryPolicies {
    public static final RetryPolicy NO_RETRY_POLICY = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, RetryPolicy.BackoffStrategy.NO_DELAY, 0, false);
    public static final int DEFAULT_MAX_ERROR_RETRY = 3;
    public static final RetryPolicy DEFAULT;
    public static final int DYNAMODB_DEFAULT_MAX_ERROR_RETRY = 10;
    public static final RetryPolicy DYNAMODB_DEFAULT;
    public static final RetryPolicy.RetryCondition DEFAULT_RETRY_CONDITION;
    public static final RetryPolicy.BackoffStrategy DEFAULT_BACKOFF_STRATEGY;
    public static final V2CompatibleBackoffStrategy DEFAULT_BACKOFF_STRATEGY_V2;
    public static final RetryPolicy.BackoffStrategy DYNAMODB_DEFAULT_BACKOFF_STRATEGY;

    public static RetryPolicy getDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, 3, true);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, 10, true);
    }

    public static RetryPolicy getDefaultRetryPolicyWithCustomMaxRetries(int maxErrorRetry) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, maxErrorRetry, false);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicyWithCustomMaxRetries(int maxErrorRetry) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, maxErrorRetry, false);
    }

    static {
        DEFAULT_RETRY_CONDITION = new SDKDefaultRetryCondition();
        DEFAULT_BACKOFF_STRATEGY = new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy();
        DEFAULT_BACKOFF_STRATEGY_V2 = new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy();
        DYNAMODB_DEFAULT_BACKOFF_STRATEGY = new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy(25, 500, 20000);
        DEFAULT = PredefinedRetryPolicies.getDefaultRetryPolicy();
        DYNAMODB_DEFAULT = PredefinedRetryPolicies.getDynamoDBDefaultRetryPolicy();
    }

    public static class SDKDefaultRetryCondition
    implements RetryPolicy.RetryCondition {
        @Override
        public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (exception.getCause() instanceof IOException) {
                return true;
            }
            if (exception instanceof AmazonServiceException) {
                AmazonServiceException ase = (AmazonServiceException)exception;
                if (RetryUtils.isRetryableServiceException(ase)) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(ase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

