/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3ObjectId;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3ObjectInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.StringUtils;

class S3ObjectWrapper
implements Closeable {
    private final S3Object s3obj;
    private final S3ObjectId id;

    S3ObjectWrapper(S3Object s3obj, S3ObjectId id) {
        if (s3obj == null) {
            throw new IllegalArgumentException();
        }
        this.s3obj = s3obj;
        this.id = id;
    }

    public S3ObjectId getS3ObjectId() {
        return this.id;
    }

    ObjectMetadata getObjectMetadata() {
        return this.s3obj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata metadata) {
        this.s3obj.setObjectMetadata(metadata);
    }

    S3ObjectInputStream getObjectContent() {
        return this.s3obj.getObjectContent();
    }

    void setObjectContent(S3ObjectInputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    void setObjectContent(InputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    String getBucketName() {
        return this.s3obj.getBucketName();
    }

    void setBucketName(String bucketName) {
        this.s3obj.setBucketName(bucketName);
    }

    String getKey() {
        return this.s3obj.getKey();
    }

    void setKey(String key) {
        this.s3obj.setKey(key);
    }

    String getRedirectLocation() {
        return this.s3obj.getRedirectLocation();
    }

    void setRedirectLocation(String redirectLocation) {
        this.s3obj.setRedirectLocation(redirectLocation);
    }

    public String toString() {
        return this.s3obj.toString();
    }

    final boolean isInstructionFile() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-amz-crypto-instr-file");
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-amz-iv") && (userMeta.containsKey("x-amz-key-v2") || userMeta.containsKey("x-amz-key"));
    }

    String toJsonString() {
        try {
            return S3ObjectWrapper.from(this.s3obj.getObjectContent());
        }
        catch (Exception e) {
            throw new SdkClientException("Error parsing JSON: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StringUtils.UTF8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.s3obj.close();
    }

    S3Object getS3Object() {
        return this.s3obj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> instructionFile) {
        if (instructionFile != null) {
            String cekAlgo = instructionFile.get("x-amz-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        }
        ObjectMetadata meta = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = meta.getUserMetadata();
        String cekAlgo = userMeta.get("x-amz-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
    }
}

