/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.transfer;

import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.AmazonS3Encryption;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.ServiceUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.SkipMd5CheckStrategy;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.transfer.internal.DownloadImpl;

final class DownloadTaskImpl
implements ServiceUtils.RetryableS3DownloadTask {
    private final AmazonS3 s3;
    private final DownloadImpl download;
    private final GetObjectRequest getObjectRequest;
    private final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;

    DownloadTaskImpl(AmazonS3 s3, DownloadImpl download, GetObjectRequest getObjectRequest) {
        this.s3 = s3;
        this.download = download;
        this.getObjectRequest = getObjectRequest;
    }

    @Override
    public S3Object getS3ObjectStream() {
        S3Object s3Object = this.s3.getObject(this.getObjectRequest);
        this.download.setS3Object(s3Object);
        return s3Object;
    }

    @Override
    public boolean needIntegrityCheck() {
        return !(this.s3 instanceof AmazonS3Encryption) && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(this.getObjectRequest);
    }
}

