/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.google.common.hash;

import org.apache.flink.fs.s3hadoop.shaded.com.google.common.hash.HashCode;

final class HashCodes {
    private HashCodes() {
    }

    static HashCode fromInt(int hash) {
        return new IntHashCode(hash);
    }

    static HashCode fromLong(long hash) {
        return new LongHashCode(hash);
    }

    static HashCode fromBytes(byte[] bytes) {
        return new BytesHashCode(bytes);
    }

    private static class BytesHashCode
    extends HashCode {
        final byte[] bytes;

        BytesHashCode(byte[] bytes) {
            this.bytes = bytes;
        }

        public int bits() {
            return this.bytes.length * 8;
        }

        public byte[] asBytes() {
            return (byte[])this.bytes.clone();
        }

        public int asInt() {
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        public long asLong() {
            if (this.bytes.length < 8) {
                throw new IllegalStateException("Not enough bytes");
            }
            return (long)this.bytes[0] & 0xFFL | ((long)this.bytes[1] & 0xFFL) << 8 | ((long)this.bytes[2] & 0xFFL) << 16 | ((long)this.bytes[3] & 0xFFL) << 24 | ((long)this.bytes[4] & 0xFFL) << 32 | ((long)this.bytes[5] & 0xFFL) << 40 | ((long)this.bytes[6] & 0xFFL) << 48 | ((long)this.bytes[7] & 0xFFL) << 56;
        }
    }

    private static class LongHashCode
    extends HashCode {
        final long hash;

        LongHashCode(long hash) {
            this.hash = hash;
        }

        public int bits() {
            return 64;
        }

        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        public int asInt() {
            return (int)this.hash;
        }

        public long asLong() {
            return this.hash;
        }
    }

    private static class IntHashCode
    extends HashCode {
        final int hash;

        IntHashCode(int hash) {
            this.hash = hash;
        }

        public int bits() {
            return 32;
        }

        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24)};
        }

        public int asInt() {
            return this.hash;
        }

        public long asLong() {
            throw new IllegalStateException("this HashCode only has 32 bits; cannot create a long");
        }
    }
}

