/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose;

import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.Immutable;
import org.apache.flink.fs.s3hadoop.shaded.net.minidev.json.JSONAware;
import org.apache.flink.fs.s3hadoop.shaded.net.minidev.json.JSONObject;

@Immutable
public final class CompressionAlgorithm
implements JSONAware {
    public static final CompressionAlgorithm DEF = new CompressionAlgorithm("DEF");
    private final String name;

    public CompressionAlgorithm(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The compression algorithm name must not be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CompressionAlgorithm && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape(this.name));
        sb.append('\"');
        return sb.toString();
    }
}

