/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.AES;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.AuthenticatedCipherText;
import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.ThreadSafe;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.BlockCipher;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.CipherParameters;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.engines.AESEngine;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.params.AEADParameters;
import org.apache.flink.fs.s3hadoop.shaded.org.bouncycastle.crypto.params.KeyParameter;

@ThreadSafe
class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom randomGen) {
        byte[] bytes = new byte[12];
        randomGen.nextBytes(bytes);
        return bytes;
    }

    private static GCMBlockCipher createAESGCMCipher(SecretKey secretKey, boolean forEncryption, byte[] iv, byte[] authData) {
        AESEngine cipher = AES.createCipher(secretKey, forEncryption);
        GCMBlockCipher gcm = new GCMBlockCipher((BlockCipher)cipher);
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(secretKey.getEncoded()), 128, iv, authData);
        gcm.init(forEncryption, (CipherParameters)aeadParams);
        return gcm;
    }

    public static AuthenticatedCipherText encrypt(SecretKey secretKey, byte[] iv, byte[] plainText, byte[] authData, Provider provider) throws JOSEException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, true, iv, authData);
        int outputLength = cipher.getOutputSize(plainText.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(plainText, 0, plainText.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't generate GCM authentication tag: " + e.getMessage(), e);
        }
        int authTagLength = 16;
        byte[] cipherText = new byte[outputOffset - authTagLength];
        byte[] authTag = new byte[authTagLength];
        System.arraycopy(output, 0, cipherText, 0, cipherText.length);
        System.arraycopy(output, outputOffset - authTagLength, authTag, 0, authTag.length);
        return new AuthenticatedCipherText(cipherText, authTag);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] iv, byte[] cipherText, byte[] authData, byte[] authTag, Provider provider) throws JOSEException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, false, iv, authData);
        byte[] input = new byte[cipherText.length + authTag.length];
        System.arraycopy(cipherText, 0, input, 0, cipherText.length);
        System.arraycopy(authTag, 0, input, cipherText.length, authTag.length);
        int outputLength = cipher.getOutputSize(input.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(input, 0, input.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't validate GCM authentication tag: " + e.getMessage(), e);
        }
        return output;
    }

    private AESGCM() {
    }
}

