/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Provider;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSAlgorithmProvider;

abstract class BaseJWSProvider
implements JWSAlgorithmProvider {
    private final Set<JWSAlgorithm> algs;
    protected Provider provider = null;

    public BaseJWSProvider(Set<JWSAlgorithm> algs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWS algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
    }

    @Override
    public Set<JWSAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

