/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.BaseJWEProvider;

abstract class DirectCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final SecretKey cek;

    protected DirectCryptoProvider(SecretKey key) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
        if (!key.getAlgorithm().equals("AES")) {
            throw new JOSEException("The algorithm of the shared symmetric key must be AES");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32 && keyBytes.length != 48 && keyBytes.length != 64) {
            throw new JOSEException("The length of the shared symmetric key must be 128 bits (16 bytes), 192 bits (24 bytes), 256 bits (32 bytes), 384 bits (48 bytes) or 512 bites (64 bytes)");
        }
        this.cek = key;
    }

    protected DirectCryptoProvider(byte[] keyBytes) throws JOSEException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public SecretKey getKey() {
        return this.cek;
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.DIR);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A192CBC_HS384);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A192GCM);
        methods.add(EncryptionMethod.A256GCM);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(methods);
    }
}

