/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.ConstantTimeUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.HMAC;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.MACProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier {
    private Set<JWSAlgorithm> acceptedAlgs = new HashSet<JWSAlgorithm>(this.supportedAlgorithms());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();

    public MACVerifier(byte[] sharedSecret) {
        super(sharedSecret);
    }

    public MACVerifier(String sharedSecretString) {
        super(sharedSecretString);
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWS algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        String jcaAlg = MACVerifier.getJCAAlgorithmName(header.getAlgorithm());
        if (!this.critParamChecker.headerPasses(header)) {
            return false;
        }
        byte[] expectedHMAC = HMAC.compute(jcaAlg, this.getSharedSecret(), signedContent, this.provider);
        return ConstantTimeUtils.areEqual(expectedHMAC, signature.decode());
    }
}

