/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.RSASSAProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements JWSVerifier {
    private Set<JWSAlgorithm> acceptedAlgs = new HashSet<JWSAlgorithm>(this.supportedAlgorithms());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWS algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critParamChecker.headerPasses(header)) {
            return false;
        }
        Signature verifier = RSASSAVerifier.getRSASignerAndVerifier(header.getAlgorithm(), this.provider);
        try {
            verifier.initVerify(this.publicKey);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid public RSA key: " + e.getMessage(), e);
        }
        try {
            verifier.update(signedContent);
            return verifier.verify(signature.decode());
        }
        catch (SignatureException e) {
            return false;
        }
    }
}

