/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.CipherHelper;
import org.apache.flink.fs.s3hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class RSA_OAEP {
    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", provider);
            cipher.init(1, (Key)pub, new SecureRandom());
            return cipher.doFinal(cek.getEncoded());
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(RSAPrivateKey priv, byte[] encryptedCEK, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding", provider);
            cipher.init(2, priv);
            return new SecretKeySpec(cipher.doFinal(encryptedCEK), "AES");
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    private RSA_OAEP() {
    }
}

