/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.util.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;

public class HadoopFileSystem
extends FileSystem {
    private final org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem fs;

    public HadoopFileSystem(org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this.fs = (org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path getWorkingDirectory() {
        return new org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path(this.fs.getWorkingDirectory().toUri());
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path getHomeDirectory() {
        return new org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileStatus getFileStatus(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f) throws IOException {
        FileStatus status = this.fs.getFileStatus(new Path(f.toString()));
        return new HadoopFileStatus(status);
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f, int bufferSize) throws IOException {
        Path path = new Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f) throws IOException {
        Path path = new Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(new Path(f.toString()), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f, boolean recursive) throws IOException {
        return this.fs.delete(new Path(f.toString()), recursive);
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileStatus[] listStatus(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f) throws IOException {
        FileStatus[] hadoopFiles = this.fs.listStatus(new Path(f.toString()));
        org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileStatus[] files = new org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path f) throws IOException {
        return this.fs.mkdirs(new Path(f.toString()));
    }

    public boolean rename(org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path src, org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.core.fs.Path dst) throws IOException {
        return this.fs.rename(new Path(src.toString()), new Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }
}

