/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum XAttrSetFlag {
    CREATE(1),
    REPLACE(2);

    private final short flag;

    private XAttrSetFlag(short flag) {
        this.flag = flag;
    }

    short getFlag() {
        return this.flag;
    }

    public static void validate(String xAttrName, boolean xAttrExists, EnumSet<XAttrSetFlag> flag) throws IOException {
        if (flag == null || flag.isEmpty()) {
            throw new HadoopIllegalArgumentException("A flag must be specified.");
        }
        if (xAttrExists) {
            if (!flag.contains((Object)REPLACE)) {
                throw new IOException("XAttr: " + xAttrName + " already exists. The REPLACE flag must be specified.");
            }
        } else if (!flag.contains((Object)CREATE)) {
            throw new IOException("XAttr: " + xAttrName + " does not exist. The CREATE flag must be specified.");
        }
    }
}

