/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission;

import java.util.Collections;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.AclEntryScope;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public final class ScopedAclEntries {
    private static final int PIVOT_NOT_FOUND = -1;
    private final List<AclEntry> accessEntries;
    private final List<AclEntry> defaultEntries;

    public ScopedAclEntries(List<AclEntry> aclEntries) {
        int pivot = ScopedAclEntries.calculatePivotOnDefaultEntries(aclEntries);
        if (pivot != -1) {
            this.accessEntries = pivot != 0 ? aclEntries.subList(0, pivot) : Collections.emptyList();
            this.defaultEntries = aclEntries.subList(pivot, aclEntries.size());
        } else {
            this.accessEntries = aclEntries;
            this.defaultEntries = Collections.emptyList();
        }
    }

    public List<AclEntry> getAccessEntries() {
        return this.accessEntries;
    }

    public List<AclEntry> getDefaultEntries() {
        return this.defaultEntries;
    }

    private static int calculatePivotOnDefaultEntries(List<AclEntry> aclBuilder) {
        for (int i = 0; i < aclBuilder.size(); ++i) {
            if (aclBuilder.get(i).getScope() != AclEntryScope.DEFAULT) continue;
            return i;
        }
        return -1;
    }
}

