/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.ObjectListing;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.PathFilter;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.slf4j.Logger;

public class Listing {
    private final S3AFileSystem owner;
    private static final Logger LOG = S3AFileSystem.LOG;
    static final PathFilter ACCEPT_ALL = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    public Listing(S3AFileSystem owner) {
        this.owner = owner;
    }

    FileStatusListingIterator createFileStatusListingIterator(Path listPath, ListObjectsRequest request, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
        return new FileStatusListingIterator(new ObjectListingIterator(listPath, request), filter, acceptor);
    }

    LocatedFileStatusIterator createLocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
        return new LocatedFileStatusIterator(statusIterator);
    }

    static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelfAndS3nDirs(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals(this.qualifiedPath) && !summary.getKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals(this.qualifiedPath);
        }
    }

    class LocatedFileStatusIterator
    implements RemoteIterator<LocatedFileStatus> {
        private final RemoteIterator<FileStatus> statusIterator;

        LocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
            this.statusIterator = statusIterator;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.statusIterator.hasNext();
        }

        @Override
        public LocatedFileStatus next() throws IOException {
            return Listing.this.owner.toLocatedFileStatus(this.statusIterator.next());
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals(this.qualifiedPath) && !summary.getKey().endsWith("_$folder$") && !S3AUtils.objectRepresentsDirectory(summary.getKey(), summary.getSize());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<ObjectListing> {
        private final Path listPath;
        private ObjectListing objects;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;

        ObjectListingIterator(Path listPath, ListObjectsRequest request) {
            this.listPath = listPath;
            this.maxKeys = Listing.this.owner.getMaxKeys();
            this.objects = Listing.this.owner.listObjects(request);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.firstListing || this.objects.isTruncated();
        }

        @Override
        public ObjectListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                try {
                    if (!this.objects.isTruncated()) {
                        throw new NoSuchElementException("No more results in listing of " + this.listPath);
                    }
                    LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                    this.objects = Listing.this.owner.continueListObjects(this.objects);
                    ++this.listingCount;
                    LOG.debug("New listing status: {}", (Object)this);
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("listObjects()", this.listPath, e);
                }
            }
            return this.objects;
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated();
        }

        public Path getListPath() {
            return this.listPath;
        }

        public int getListingCount() {
            return this.listingCount;
        }
    }

    class FileStatusListingIterator
    implements RemoteIterator<FileStatus> {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<FileStatus> statusBatchIterator;

        FileStatusListingIterator(ObjectListingIterator source, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
            this.source = source;
            this.filter = filter;
            this.acceptor = acceptor;
            this.requestNextBatch();
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.statusBatchIterator.hasNext() || this.requestNextBatch();
        }

        @Override
        public FileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.statusBatchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(ObjectListing objects) {
            int added = 0;
            int ignored = 0;
            ArrayList<S3AFileStatus> stats = new ArrayList<S3AFileStatus>(objects.getObjectSummaries().size() + objects.getCommonPrefixes().size());
            for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                String key = summary.getKey();
                Path keyPath = Listing.this.owner.keyToQualifiedPath(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)S3AUtils.stringify(summary));
                }
                if (this.acceptor.accept(keyPath, summary) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = S3AUtils.createFileStatus(keyPath, summary, Listing.this.owner.getDefaultBlockSize(keyPath), Listing.this.owner.getUsername());
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (String prefix : objects.getCommonPrefixes()) {
                Path keyPath = Listing.this.owner.keyToQualifiedPath(prefix);
                if (this.acceptor.accept(keyPath, prefix) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = new S3AFileStatus(false, keyPath, Listing.this.owner.getUsername());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }
    }

    static final class SingleStatusRemoteIterator
    implements RemoteIterator<LocatedFileStatus> {
        private LocatedFileStatus status;

        public SingleStatusRemoteIterator(LocatedFileStatus status) {
            this.status = status;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.status != null;
        }

        @Override
        public LocatedFileStatus next() throws IOException {
            if (this.hasNext()) {
                LocatedFileStatus s = this.status;
                this.status = null;
                return s;
            }
            throw new NoSuchElementException();
        }
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, S3ObjectSummary var2);

        public boolean accept(Path var1, String var2);
    }
}

