/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.StringUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.slf4j.Logger;
import org.apache.flink.fs.s3hadoop.shaded.org.slf4j.LoggerFactory;

public class BlockStoragePolicySuite {
    static final Logger LOG = LoggerFactory.getLogger(BlockStoragePolicySuite.class);
    public static final String STORAGE_POLICY_XATTR_NAME = "hsm.block.storage.policy.id";
    public static final XAttr.NameSpace XAttrNS = XAttr.NameSpace.SYSTEM;
    public static final int ID_BIT_LENGTH = 4;
    private final byte defaultPolicyID;
    private final BlockStoragePolicy[] policies;

    @VisibleForTesting
    public static BlockStoragePolicySuite createDefaultSuite() {
        BlockStoragePolicy[] policies = new BlockStoragePolicy[16];
        int lazyPersistId = 15;
        policies[15] = new BlockStoragePolicy(15, "LAZY_PERSIST", new StorageType[]{StorageType.RAM_DISK, StorageType.DISK}, new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.DISK}, true);
        int allssdId = 12;
        policies[12] = new BlockStoragePolicy(12, "ALL_SSD", new StorageType[]{StorageType.SSD}, new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.DISK});
        int onessdId = 10;
        policies[10] = new BlockStoragePolicy(10, "ONE_SSD", new StorageType[]{StorageType.SSD, StorageType.DISK}, new StorageType[]{StorageType.SSD, StorageType.DISK}, new StorageType[]{StorageType.SSD, StorageType.DISK});
        int hotId = 7;
        policies[7] = new BlockStoragePolicy(7, "HOT", new StorageType[]{StorageType.DISK}, StorageType.EMPTY_ARRAY, new StorageType[]{StorageType.ARCHIVE});
        int warmId = 5;
        policies[5] = new BlockStoragePolicy(5, "WARM", new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE});
        int coldId = 2;
        policies[2] = new BlockStoragePolicy(2, "COLD", new StorageType[]{StorageType.ARCHIVE}, StorageType.EMPTY_ARRAY, StorageType.EMPTY_ARRAY);
        return new BlockStoragePolicySuite(7, policies);
    }

    public BlockStoragePolicySuite(byte defaultPolicyID, BlockStoragePolicy[] policies) {
        this.defaultPolicyID = defaultPolicyID;
        this.policies = policies;
    }

    public BlockStoragePolicy getPolicy(byte id) {
        return id == 0 ? this.getDefaultPolicy() : this.policies[id];
    }

    public BlockStoragePolicy getDefaultPolicy() {
        return this.getPolicy(this.defaultPolicyID);
    }

    public BlockStoragePolicy getPolicy(String policyName) {
        Preconditions.checkNotNull(policyName);
        if (this.policies != null) {
            for (BlockStoragePolicy policy : this.policies) {
                if (policy == null || !policy.getName().equalsIgnoreCase(policyName)) continue;
                return policy;
            }
        }
        return null;
    }

    public BlockStoragePolicy[] getAllPolicies() {
        ArrayList<BlockStoragePolicy> list = Lists.newArrayList();
        if (this.policies != null) {
            for (BlockStoragePolicy policy : this.policies) {
                if (policy == null) continue;
                list.add(policy);
            }
        }
        return list.toArray(new BlockStoragePolicy[list.size()]);
    }

    public static String buildXAttrName() {
        return StringUtils.toLowerCase(XAttrNS.toString()) + "." + STORAGE_POLICY_XATTR_NAME;
    }

    public static XAttr buildXAttr(byte policyId) {
        String name = BlockStoragePolicySuite.buildXAttrName();
        return XAttrHelper.buildXAttr(name, new byte[]{policyId});
    }

    public static String getStoragePolicyXAttrPrefixedName() {
        return XAttrHelper.getPrefixedName(XAttrNS, STORAGE_POLICY_XATTR_NAME);
    }
}

