/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.DFSClient;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.net.NetUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DatanodeJspHelper {
    private static DFSClient getDFSClient(UserGroupInformation user, final String addr, final Configuration conf) throws IOException, InterruptedException {
        return user.doAs(new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(NetUtils.createSocketAddr(addr), conf);
            }
        });
    }

    public static DFSClient getDFSClient(HttpServletRequest request, DataNode datanode, Configuration conf, UserGroupInformation ugi) throws IOException, InterruptedException {
        String nnAddr = request.getParameter("nnaddr");
        return DatanodeJspHelper.getDFSClient(ugi, nnAddr, conf);
    }
}

