/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.ContentSummary;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.ServletUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLOutputter;

@InterfaceAudience.Private
public class ContentSummaryServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
        UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    String path = ServletUtil.getDecodedPath(request, "/contentSummary");
                    PrintWriter out = response.getWriter();
                    XMLOutputter xml = new XMLOutputter((Writer)out, "UTF-8");
                    xml.declaration();
                    try {
                        ClientProtocol nnproxy = ContentSummaryServlet.this.createNameNodeProxy();
                        ContentSummary cs = nnproxy.getContentSummary(path);
                        xml.startTag(ContentSummary.class.getName());
                        if (cs != null) {
                            xml.attribute("length", "" + cs.getLength());
                            xml.attribute("fileCount", "" + cs.getFileCount());
                            xml.attribute("directoryCount", "" + cs.getDirectoryCount());
                            xml.attribute("quota", "" + cs.getQuota());
                            xml.attribute("spaceConsumed", "" + cs.getSpaceConsumed());
                            xml.attribute("spaceQuota", "" + cs.getSpaceQuota());
                        }
                        xml.endTag();
                    }
                    catch (IOException ioe) {
                        ContentSummaryServlet.this.writeXml(ioe, path, xml);
                    }
                    xml.endDocument();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

