/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.CacheFlag;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.AccessControlException;

class FSNDNCacheOp {
    FSNDNCacheOp() {
    }

    static CacheDirectiveInfo addCacheDirective(FSNamesystem fsn, CacheManager cacheManager, CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        if (directive.getId() != null) {
            throw new IOException("addDirective: you cannot specify an ID for this operation.");
        }
        CacheDirectiveInfo effectiveDirective = cacheManager.addDirective(directive, pc, flags);
        fsn.getEditLog().logAddCacheDirectiveInfo(effectiveDirective, logRetryCache);
        return effectiveDirective;
    }

    static void modifyCacheDirective(FSNamesystem fsn, CacheManager cacheManager, CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        cacheManager.modifyDirective(directive, pc, flags);
        fsn.getEditLog().logModifyCacheDirectiveInfo(directive, logRetryCache);
    }

    static void removeCacheDirective(FSNamesystem fsn, CacheManager cacheManager, long id, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        cacheManager.removeDirective(id, pc);
        fsn.getEditLog().logRemoveCacheDirectiveInfo(id, logRetryCache);
    }

    static BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(FSNamesystem fsn, CacheManager cacheManager, long startId, CacheDirectiveInfo filter) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        return cacheManager.listCacheDirectives(startId, filter, pc);
    }

    static CachePoolInfo addCachePool(FSNamesystem fsn, CacheManager cacheManager, CachePoolInfo req, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
        CachePoolInfo info = cacheManager.addCachePool(req);
        fsn.getEditLog().logAddCachePool(info, logRetryCache);
        return info;
    }

    static void modifyCachePool(FSNamesystem fsn, CacheManager cacheManager, CachePoolInfo req, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
        cacheManager.modifyCachePool(req);
        fsn.getEditLog().logModifyCachePool(req, logRetryCache);
    }

    static void removeCachePool(FSNamesystem fsn, CacheManager cacheManager, String cachePoolName, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
        cacheManager.removeCachePool(cachePoolName);
        fsn.getEditLog().logRemoveCachePool(cachePoolName, logRetryCache);
    }

    static BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(FSNamesystem fsn, CacheManager cacheManager, String prevKey) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        return cacheManager.listCachePools(pc, prevKey);
    }

    private static FSPermissionChecker getFsPermissionChecker(FSNamesystem fsn) throws AccessControlException {
        return fsn.isPermissionEnabled() ? fsn.getPermissionChecker() : null;
    }
}

