/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.impl.Log4JLogger;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.CacheFlag;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.ContentSummary;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FsServerDefaults;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.InvalidPathException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Options;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.QuotaUsage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.AclStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.ServiceFailedException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.HAUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.RollingUpgradeException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.Util;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirAclOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirAppendOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirAttrOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirConcatOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirRenameOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirSymlinkOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirTruncateOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirWriteFileOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSNDNCacheOp;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.TopConf;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.CallerContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.RetriableException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.RetryCache;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.Server;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.StandbyException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.util.MBeans;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.net.NetworkTopology;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.net.Node;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.AccessControlException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.SecretManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Daemon;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.DataChecksum;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.ReflectionUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.StringUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Time;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.VersionInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.log4j.Appender;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.log4j.AsyncAppender;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.log4j.Logger;
import org.apache.flink.fs.s3hadoop.shaded.org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
@Metrics(context="dfs")
public class FSNamesystem
implements Namesystem,
FSNamesystemMBean,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private final MetricsRegistry registry = new MetricsRegistry("FSNamesystem");
    @Metric
    final MutableRatesWithAggregation detailedLockHoldTimeMetrics = this.registry.newRatesWithAggregation("detailedLockHoldTimeMetrics");
    private final BlockIdManager blockIdManager;
    public static final Log auditLog = LogFactory.getLog(FSNamesystem.class.getName() + ".audit");
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private final boolean isPermissionEnabled;
    private final UserGroupInformation fsOwner;
    private final String supergroup;
    private final boolean standbyShouldCheckpoint;
    private final long leaseRecheckIntervalMs;
    private final long maxLockHoldToReleaseLeaseMs;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private static final Step STEP_AWAITING_REPORTED_BLOCKS = new Step(StepType.AWAITING_REPORTED_BLOCKS);
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private final BlockManager blockManager;
    private final SnapshotManager snapshotManager;
    private final CacheManager cacheManager;
    private final DatanodeStatistics datanodeStatistics;
    private String nameserviceId;
    private volatile RollingUpgradeInfo rollingUpgradeInfo = null;
    private volatile boolean needRollbackFsImage;
    private String blockPoolId;
    final LeaseManager leaseManager = new LeaseManager(this);
    volatile Daemon smmthread = null;
    Daemon nnrmthread = null;
    Daemon nnEditLogRoller = null;
    Daemon lazyPersistFileScrubber = null;
    private ExecutorService edekCacheLoader = null;
    private final int edekCacheLoaderDelay;
    private final int edekCacheLoaderInterval;
    private final long editLogRollerThreshold;
    private final int editLogRollerInterval;
    private final int lazyPersistFileScrubIntervalSec;
    private volatile boolean hasResourcesAvailable = false;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private final FsServerDefaults serverDefaults;
    private final boolean supportAppends;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private volatile SafeModeInfo safeMode;
    private final long maxFsObjects;
    private final long minBlockSize;
    final long maxBlocksPerFile;
    private final int numCommittedAllowed;
    private final FSNamesystemLock fsLock;
    private final ReentrantLock cpLock;
    private EditLogTailer editLogTailer = null;
    private StandbyCheckpointer standbyCheckpointer;
    private HAContext haContext;
    private final boolean haEnabled;
    private volatile boolean startingActiveService = false;
    private final RetryCache retryCache;
    private KeyProviderCryptoExtension provider = null;
    private volatile boolean imageLoaded = false;
    private final Condition cond;
    private final FSImage fsImage;
    private final TopConf topConf;
    private TopMetrics topMetrics;
    private INodeAttributeProvider inodeAttributeProvider;
    private ObjectName mbeanName;
    private ObjectName mxbeanName;

    boolean isAuditEnabled() {
        return (!this.isDefaultAuditLogger || auditLog.isInfoEnabled()) && !this.auditLoggers.isEmpty();
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, Server.getRemoteUser(), Server.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(stat.getSymlink()) : null;
            Path path = dst != null ? new Path(dst) : new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDir(), stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        String ugiStr = ugi.toString();
        for (AuditLogger logger : this.auditLoggers) {
            if (logger instanceof HdfsAuditLogger) {
                HdfsAuditLogger hdfsLogger = (HdfsAuditLogger)logger;
                hdfsLogger.logAuditEvent(succeeded, ugiStr, addr, cmd, src, dst, status, CallerContext.getCurrent(), ugi, this.dtSecretManager);
                continue;
            }
            logger.logAuditEvent(succeeded, ugiStr, addr, cmd, src, dst, status);
        }
    }

    void imageLoadComplete() {
        Preconditions.checkState(!this.imageLoaded, "FSDirectory already loaded");
        this.setImageLoaded();
    }

    void setImageLoaded() {
        if (this.imageLoaded) {
            return;
        }
        this.writeLock();
        try {
            this.setImageLoaded(true);
            this.dir.markNameCacheInitialized();
            this.cond.signalAll();
        }
        finally {
            this.writeUnlock("setImageLoaded");
        }
    }

    @VisibleForTesting
    boolean isImageLoaded() {
        return this.imageLoaded;
    }

    protected void setImageLoaded(boolean flag) {
        this.imageLoaded = flag;
    }

    void waitForLoadingFSImage() {
        if (!this.imageLoaded) {
            this.writeLock();
            try {
                while (!this.imageLoaded) {
                    try {
                        this.cond.await(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    void clear() {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.blockIdManager.clear();
        this.leaseManager.removeAllLeases();
        this.snapshotManager.clearSnapshottableDirs();
        this.cacheManager.clear();
        this.setImageLoaded(false);
        this.blockManager.clear();
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    boolean isHaEnabled() {
        return this.haEnabled;
    }

    private static void checkConfiguration(Configuration conf) throws IOException {
        Collection<URI> namespaceDirs = FSNamesystem.getNamespaceDirs(conf);
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf);
        Collection<URI> requiredEditsDirs = FSNamesystem.getRequiredNamespaceEditsDirs(conf);
        List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
        for (URI u : requiredEditsDirs) {
            if (u.toString().compareTo("file:///tmp/hadoop/dfs/name") == 0 || editsDirs.contains(u) || sharedEditsDirs.contains(u)) continue;
            throw new IllegalArgumentException("Required edits directory " + u + " not found: " + "dfs.namenode.edits.dir" + "=" + editsDirs + "; " + "dfs.namenode.edits.dir.required" + "=" + requiredEditsDirs + "; " + "dfs.namenode.shared.edits.dir" + "=" + sharedEditsDirs);
        }
        if (namespaceDirs.size() == 1) {
            LOG.warn("Only one image storage directory (dfs.namenode.name.dir) configured. Beware of data loss due to lack of redundant storage directories!");
        }
        if (editsDirs.size() == 1) {
            LOG.warn("Only one namespace edits storage directory (dfs.namenode.edits.dir) configured. Beware of data loss due to lack of redundant storage directories!");
        }
    }

    static FSNamesystem loadFromDisk(Configuration conf) throws IOException {
        FSNamesystem.checkConfiguration(conf);
        FSImage fsImage = new FSImage(conf, FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf));
        FSNamesystem namesystem = new FSNamesystem(conf, fsImage, false);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        long loadStart = Time.monotonicNow();
        try {
            namesystem.loadFSImage(startOpt);
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception loading fsimage", ioe);
            fsImage.close();
            throw ioe;
        }
        long timeTakenToLoadFSImage = Time.monotonicNow() - loadStart;
        LOG.info("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs");
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        namesystem.getFSDirectory().createReservedStatuses(namesystem.getCTime());
        return namesystem;
    }

    FSNamesystem(Configuration conf, FSImage fsImage) throws IOException {
        this(conf, fsImage, false);
    }

    FSNamesystem(Configuration conf, FSImage fsImage, boolean ignoreRetryCache) throws IOException {
        this.provider = DFSUtil.createKeyProviderCryptoExtension(conf);
        LOG.info("KeyProvider: " + this.provider);
        if (conf.getBoolean("dfs.namenode.audit.log.async", false)) {
            LOG.info("Enabling async auditlog");
            FSNamesystem.enableAsyncAuditLog();
        }
        this.fsLock = new FSNamesystemLock(conf, this.detailedLockHoldTimeMetrics);
        this.cond = this.fsLock.newWriteLockCondition();
        this.cpLock = new ReentrantLock();
        this.fsImage = fsImage;
        try {
            DataChecksum.Type checksumType;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.blockManager = new BlockManager(this, conf);
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            this.blockIdManager = new BlockIdManager(this.blockManager);
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            LOG.info("fsOwner             = " + this.fsOwner);
            LOG.info("supergroup          = " + this.supergroup);
            LOG.info("isPermissionEnabled = " + this.isPermissionEnabled);
            this.nameserviceId = DFSUtil.getNamenodeNameServiceId(conf);
            this.haEnabled = HAUtil.isHAEnabled(conf, this.nameserviceId);
            if (this.nameserviceId != null) {
                LOG.info("Determined nameservice ID: " + this.nameserviceId);
            }
            LOG.info("HA Enabled: " + this.haEnabled);
            if (!this.haEnabled && HAUtil.usesSharedEditsDir(conf)) {
                LOG.warn("Configured NNs:\n" + DFSUtil.nnAddressesAsString(conf));
                throw new IOException("Invalid configuration: a shared edits dir must not be specified if HA is not enabled.");
            }
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf(checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x8000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType);
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.minBlockSize = conf.getLong("dfs.namenode.fs-limits.min-block-size", 0x100000L);
            this.maxBlocksPerFile = conf.getLong("dfs.namenode.fs-limits.max-blocks-per-file", 0x100000L);
            this.numCommittedAllowed = conf.getInt("dfs.namenode.file.close.num-committed-allowed", 0);
            this.supportAppends = conf.getBoolean("dfs.support.append", true);
            LOG.info("Append Enabled: " + this.supportAppends);
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
            this.standbyShouldCheckpoint = conf.getBoolean("dfs.ha.standby.checkpoints", true);
            this.editLogRollerThreshold = (long)(conf.getFloat("dfs.namenode.edit.log.autoroll.multiplier.threshold", 2.0f) * (float)conf.getLong("dfs.namenode.checkpoint.txns", 1000000L));
            this.editLogRollerInterval = conf.getInt("dfs.namenode.edit.log.autoroll.check.interval.ms", 300000);
            this.lazyPersistFileScrubIntervalSec = conf.getInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 300);
            if (this.lazyPersistFileScrubIntervalSec < 0) {
                throw new IllegalArgumentException("dfs.namenode.lazypersist.file.scrub.interval.sec must be zero (for disable) or greater than zero.");
            }
            this.edekCacheLoaderDelay = conf.getInt("dfs.namenode.edekcacheloader.initial.delay.ms", 3000);
            this.edekCacheLoaderInterval = conf.getInt("dfs.namenode.edekcacheloader.interval.ms", 1000);
            this.leaseRecheckIntervalMs = conf.getLong("dfs.namenode.lease-recheck-interval-ms", 2000L);
            this.maxLockHoldToReleaseLeaseMs = conf.getLong("dfs.namenode.max-lock-hold-to-release-lease-ms", 25L);
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(this, conf);
            this.snapshotManager = new SnapshotManager(this.dir);
            this.cacheManager = new CacheManager(this, conf, this.blockManager);
            this.safeMode = new SafeModeInfo(conf);
            this.topConf = new TopConf(conf);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
            this.retryCache = ignoreRetryCache ? null : FSNamesystem.initRetryCache(conf);
            Class<INodeAttributeProvider> klass = conf.getClass("dfs.namenode.inode.attributes.provider.class", null, INodeAttributeProvider.class);
            if (klass != null) {
                this.inodeAttributeProvider = ReflectionUtils.newInstance(klass, conf);
                LOG.info("Using INode attribute provider: " + klass.getName());
            }
        }
        catch (IOException e) {
            LOG.error(this.getClass().getSimpleName() + " initialization failed.", e);
            this.close();
            throw e;
        }
        catch (RuntimeException re) {
            LOG.error(this.getClass().getSimpleName() + " initialization failed.", re);
            this.close();
            throw re;
        }
    }

    @VisibleForTesting
    public List<AuditLogger> getAuditLoggers() {
        return this.auditLoggers;
    }

    @VisibleForTesting
    public RetryCache getRetryCache() {
        return this.retryCache;
    }

    @VisibleForTesting
    public long getLeaseRecheckIntervalMs() {
        return this.leaseRecheckIntervalMs;
    }

    @VisibleForTesting
    public long getMaxLockHoldToReleaseLeaseMs() {
        return this.maxLockHoldToReleaseLeaseMs;
    }

    void lockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.lock();
        }
    }

    void unlockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.unlock();
        }
    }

    boolean hasRetryCache() {
        return this.retryCache != null;
    }

    void addCacheEntryWithPayload(byte[] clientId, int callId, Object payload) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntryWithPayload(clientId, callId, payload);
        }
    }

    void addCacheEntry(byte[] clientId, int callId) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntry(clientId, callId);
        }
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getProvider() {
        return this.provider;
    }

    @VisibleForTesting
    static RetryCache initRetryCache(Configuration conf) {
        boolean enable = conf.getBoolean("dfs.namenode.enable.retrycache", true);
        LOG.info("Retry cache on namenode is " + (enable ? "enabled" : "disabled"));
        if (enable) {
            float heapPercent = conf.getFloat("dfs.namenode.retrycache.heap.percent", 0.03f);
            long entryExpiryMillis = conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
            LOG.info("Retry cache will use " + heapPercent + " of total heap and retry cache entry expiry time is " + entryExpiryMillis + " millis");
            long entryExpiryNanos = entryExpiryMillis * 1000L * 1000L;
            return new RetryCache("NameNodeRetryCache", heapPercent, entryExpiryNanos);
        }
        return null;
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection<String> alClasses = conf.getTrimmedStringCollection("dfs.namenode.audit.loggers");
        ArrayList<AuditLogger> auditLoggers = Lists.newArrayList();
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger = "default".equals(className) ? new DefaultAuditLogger() : (AuditLogger)Class.forName(className).newInstance();
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            auditLoggers.add(new DefaultAuditLogger());
        }
        if (this.topConf.isEnabled) {
            this.topMetrics = new TopMetrics(conf, this.topConf.nntopReportingPeriodsMs);
            if (DefaultMetricsSystem.instance().getSource("NNTopUserOpCounts") == null) {
                DefaultMetricsSystem.instance().register("NNTopUserOpCounts", "Top N operations by user", this.topMetrics);
            }
            auditLoggers.add(new TopAuditLogger(this.topMetrics));
        }
        return Collections.unmodifiableList(auditLoggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFSImage(HdfsServerConstants.StartupOption startOpt) throws IOException {
        FSImage fsImage = this.getFSImage();
        if (startOpt == HdfsServerConstants.StartupOption.FORMAT) {
            fsImage.format(this, fsImage.getStorage().determineClusterId());
            startOpt = HdfsServerConstants.StartupOption.REGULAR;
        }
        boolean success = false;
        this.writeLock();
        try {
            MetaRecoveryContext recovery = startOpt.createRecoveryContext();
            boolean staleImage = fsImage.recoverTransitionRead(startOpt, this, recovery);
            if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startOpt) || HdfsServerConstants.RollingUpgradeStartupOption.DOWNGRADE.matches(startOpt)) {
                this.rollingUpgradeInfo = null;
            }
            boolean needToSave = staleImage && !this.haEnabled && !this.isRollingUpgrade();
            LOG.info("Need to save fs image? " + needToSave + " (staleImage=" + staleImage + ", haEnabled=" + this.haEnabled + ", isRollingUpgrade=" + this.isRollingUpgrade() + ")");
            if (needToSave) {
                fsImage.saveNamespace(this);
            } else {
                StartupProgress prog = NameNode.getStartupProgress();
                prog.beginPhase(Phase.SAVING_CHECKPOINT);
                prog.endPhase(Phase.SAVING_CHECKPOINT);
            }
            if (!this.haEnabled || this.haEnabled && startOpt == HdfsServerConstants.StartupOption.UPGRADE || this.haEnabled && startOpt == HdfsServerConstants.StartupOption.UPGRADEONLY) {
                fsImage.openEditLogForWrite(this.getEffectiveLayoutVersion());
            }
            success = true;
        }
        finally {
            if (!success) {
                fsImage.close();
            }
            this.writeUnlock("loadFSImage");
        }
        this.imageLoadComplete();
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode() && this.getEditLog().isOpenForWrite();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCommonServices(Configuration conf, HAContext haContext) throws IOException {
        this.registerMBean();
        this.writeLock();
        this.haContext = haContext;
        try {
            this.nnResourceChecker = new NameNodeResourceChecker(conf);
            this.checkAvailableResources();
            assert (this.safeMode != null && !this.blockManager.isPopulatingReplQueues());
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginPhase(Phase.SAFEMODE);
            long completeBlocksTotal = this.getCompleteBlocksTotal();
            prog.setTotal(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS, completeBlocksTotal);
            this.setBlockTotal(completeBlocksTotal);
            this.blockManager.activate(conf);
        }
        finally {
            this.writeUnlock("startCommonServices");
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register(this);
        if (this.inodeAttributeProvider != null) {
            this.inodeAttributeProvider.start();
            this.dir.setINodeAttributeProvider(this.inodeAttributeProvider);
        }
        this.snapshotManager.registerMXBean();
    }

    void stopCommonServices() {
        this.writeLock();
        if (this.inodeAttributeProvider != null) {
            this.dir.setINodeAttributeProvider(null);
            this.inodeAttributeProvider.stop();
        }
        try {
            if (this.blockManager != null) {
                this.blockManager.close();
            }
        }
        finally {
            this.writeUnlock("stopCommonServices");
        }
        RetryCache.clear(this.retryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startActiveServices() throws IOException {
        this.startingActiveService = true;
        LOG.info("Starting services required for active state");
        this.writeLock();
        try {
            FSEditLog editLog = this.getFSImage().getEditLog();
            if (!editLog.isOpenForWrite()) {
                editLog.initJournalsForWrite();
                editLog.recoverUnclosedStreams();
                LOG.info("Catching up to latest edits from old active before taking over writer role in edits logs");
                this.editLogTailer.catchupDuringFailover();
                this.blockManager.setPostponeBlocksFromFuture(false);
                this.blockManager.getDatanodeManager().markAllDatanodesStale();
                this.blockManager.clearQueues();
                this.blockManager.processAllPendingDNMessages();
                if (!this.isInSafeMode()) {
                    LOG.info("Reprocessing replication and invalidation queues");
                    this.blockManager.initializeReplQueues();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NameNode metadata after re-processing replication and invalidation queues during failover:\n" + this.metaSaveAsString());
                }
                long nextTxId = this.getFSImage().getLastAppliedTxId() + 1L;
                LOG.info("Will take over writing edit logs at txnid " + nextTxId);
                editLog.setNextTxId(nextTxId);
                this.getFSImage().editLog.openForWrite(this.getEffectiveLayoutVersion());
            }
            this.dir.updateCountForQuota();
            this.dir.enableQuotaChecks();
            if (this.haEnabled) {
                this.leaseManager.renewAllLeases();
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon(new NameNodeResourceMonitor());
            this.nnrmthread.start();
            this.nnEditLogRoller = new Daemon(new NameNodeEditLogRoller(this.editLogRollerThreshold, this.editLogRollerInterval));
            this.nnEditLogRoller.start();
            if (this.lazyPersistFileScrubIntervalSec > 0) {
                this.lazyPersistFileScrubber = new Daemon(new LazyPersistFileScrubber(this.lazyPersistFileScrubIntervalSec));
                this.lazyPersistFileScrubber.start();
            } else {
                LOG.warn("Lazy persist file scrubber is disabled, configured scrub interval is zero.");
            }
            this.cacheManager.startMonitorThread();
            this.blockManager.getDatanodeManager().setShouldSendCachingCommands(true);
            if (this.provider != null) {
                this.edekCacheLoader = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Warm Up EDEK Cache Thread #%d").build());
                FSDirEncryptionZoneOp.warmUpEdekCache(this.edekCacheLoader, this.dir, this.edekCacheLoaderDelay, this.edekCacheLoaderInterval);
            }
        }
        finally {
            this.startingActiveService = false;
            this.checkSafeMode();
            this.writeUnlock("startActiveServices");
        }
    }

    private boolean inActiveState() {
        return this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE;
    }

    public boolean inTransitionToActive() {
        return this.haEnabled && this.inActiveState() && this.startingActiveService;
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    void stopActiveServices() {
        LOG.info("Stopping services started for active state");
        this.writeLock();
        try {
            this.stopSecretManager();
            this.leaseManager.stopMonitor();
            if (this.nnrmthread != null) {
                ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
                this.nnrmthread.interrupt();
            }
            if (this.edekCacheLoader != null) {
                this.edekCacheLoader.shutdownNow();
            }
            if (this.nnEditLogRoller != null) {
                ((NameNodeEditLogRoller)this.nnEditLogRoller.getRunnable()).stop();
                this.nnEditLogRoller.interrupt();
            }
            if (this.lazyPersistFileScrubber != null) {
                ((LazyPersistFileScrubber)this.lazyPersistFileScrubber.getRunnable()).stop();
                this.lazyPersistFileScrubber.interrupt();
            }
            if (this.dir != null && this.getFSImage() != null) {
                if (this.getFSImage().editLog != null) {
                    this.getFSImage().editLog.close();
                }
                this.getFSImage().updateLastAppliedTxIdFromWritten();
            }
            if (this.cacheManager != null) {
                this.cacheManager.stopMonitorThread();
                this.cacheManager.clearDirectiveStats();
            }
            if (this.blockManager != null) {
                this.blockManager.getDatanodeManager().clearPendingCachingCommands();
                this.blockManager.getDatanodeManager().setShouldSendCachingCommands(false);
                this.blockManager.clearQueues();
                this.blockManager.setInitializedReplQueues(false);
            }
        }
        finally {
            this.writeUnlock("stopActiveServices");
        }
    }

    void startStandbyServices(Configuration conf) throws IOException {
        LOG.info("Starting services required for standby state");
        if (!this.getFSImage().editLog.isOpenForRead()) {
            this.getFSImage().editLog.initSharedJournalsForRead();
        }
        this.blockManager.setPostponeBlocksFromFuture(true);
        this.dir.disableQuotaChecks();
        this.editLogTailer = new EditLogTailer(this, conf);
        this.editLogTailer.start();
        if (this.standbyShouldCheckpoint) {
            this.standbyCheckpointer = new StandbyCheckpointer(conf, this);
            this.standbyCheckpointer.start();
        }
    }

    void triggerRollbackCheckpoint() {
        this.setNeedRollbackFsImage(true);
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.triggerRollbackCheckpoint();
        }
    }

    void prepareToStopStandbyServices() throws ServiceFailedException {
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.cancelAndPreventCheckpoints("About to leave standby state");
        }
    }

    void stopStandbyServices() throws IOException {
        LOG.info("Stopping services started for standby state");
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.stop();
        }
        if (this.editLogTailer != null) {
            this.editLogTailer.stop();
        }
        if (this.dir != null && this.getFSImage() != null && this.getFSImage().editLog != null) {
            this.getFSImage().editLog.close();
        }
    }

    @Override
    public void checkOperation(NameNode.OperationCategory op) throws StandbyException {
        if (this.haContext != null) {
            this.haContext.checkOperation(op);
        }
    }

    void checkNameNodeSafeMode(String errorMsg) throws RetriableException, SafeModeException {
        if (this.isInSafeMode()) {
            SafeModeException se = this.newSafemodeException(errorMsg);
            if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE && this.shouldRetrySafeMode(this.safeMode)) {
                throw new RetriableException(se);
            }
            throw se;
        }
    }

    private SafeModeException newSafemodeException(String errorMsg) {
        return new SafeModeException(errorMsg + ". Name node is in safe " + "mode.\n" + this.safeMode.getTurnOffTip());
    }

    boolean isPermissionEnabled() {
        return this.isPermissionEnabled;
    }

    private boolean shouldRetrySafeMode(SafeModeInfo safeMode) {
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow();
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    public static Collection<URI> getRequiredNamespaceEditsDirs(Configuration conf) {
        HashSet<URI> ret = new HashSet<URI>();
        ret.addAll(FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir.required"));
        ret.addAll(FSNamesystem.getSharedEditsDirs(conf));
        return ret;
    }

    private static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        Collection<String> dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection<String> dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;" + "\n\t\t- use Backup Node as a persistent and up-to-date storage " + "of the file system meta-data.");
            }
        } else if (dirNames.isEmpty()) {
            dirNames = Collections.singletonList("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs(dirNames);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs(conf, true);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf, boolean includeShared) throws IOException {
        LinkedHashSet<URI> editsDirs = new LinkedHashSet<URI>();
        if (includeShared) {
            List<URI> sharedDirs = FSNamesystem.getSharedEditsDirs(conf);
            if (sharedDirs.size() > 1) {
                throw new IOException("Multiple shared edits directories are not yet supported");
            }
            for (URI dir : sharedDirs) {
                if (editsDirs.add(dir)) continue;
                LOG.warn("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + ". Ignoring duplicates.");
            }
        }
        for (URI dir : FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir")) {
            if (editsDirs.add(dir)) continue;
            LOG.warn("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + " and " + "dfs.namenode.edits.dir" + ". Ignoring duplicates.");
        }
        if (editsDirs.isEmpty()) {
            return Lists.newArrayList(FSNamesystem.getNamespaceDirs(conf));
        }
        return Lists.newArrayList(editsDirs);
    }

    public static List<URI> getSharedEditsDirs(Configuration conf) {
        Collection<String> dirNames = conf.getTrimmedStringCollection("dfs.namenode.shared.edits.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    @Override
    public void readLock() {
        this.fsLock.readLock();
    }

    @Override
    public void readUnlock() {
        this.fsLock.readUnlock();
    }

    public void readUnlock(String opName) {
        this.fsLock.readUnlock(opName);
    }

    @Override
    public void writeLock() {
        this.fsLock.writeLock();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.fsLock.writeLockInterruptibly();
    }

    @Override
    public void writeUnlock() {
        this.fsLock.writeUnlock();
    }

    public void writeUnlock(String opName) {
        this.fsLock.writeUnlock(opName);
    }

    @Override
    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.fsLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.fsLock.getWriteHoldCount();
    }

    public void cpLock() {
        this.cpLock.lock();
    }

    public void cpLockInterruptibly() throws InterruptedException {
        this.cpLock.lockInterruptibly();
    }

    public void cpUnlock() {
        this.cpLock.unlock();
    }

    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.unprotectedGetNamespaceInfo();
            return namespaceInfo;
        }
        finally {
            this.readUnlock("getNamespaceInfo");
        }
    }

    @VisibleForTesting
    long getCTime() {
        return this.fsImage == null ? 0L : this.fsImage.getStorage().getCTime();
    }

    NamespaceInfo unprotectedGetNamespaceInfo() {
        return new NamespaceInfo(this.getFSImage().getStorage().getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), this.getFSImage().getStorage().getCTime(), this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void close() {
        block9: {
            this.fsRunning = false;
            try {
                this.stopCommonServices();
                if (this.smmthread == null) break block9;
                this.smmthread.interrupt();
            }
            catch (Throwable throwable) {
                block10: {
                    try {
                        this.stopActiveServices();
                        this.stopStandbyServices();
                    }
                    catch (IOException iOException) {
                        IOUtils.cleanup(LOG, this.dir);
                        IOUtils.cleanup(LOG, this.fsImage);
                        break block10;
                        catch (Throwable throwable2) {
                            IOUtils.cleanup(LOG, this.dir);
                            IOUtils.cleanup(LOG, this.fsImage);
                            throw throwable2;
                        }
                    }
                    IOUtils.cleanup(LOG, this.dir);
                    IOUtils.cleanup(LOG, this.fsImage);
                }
                throw throwable;
            }
        }
        try {
            this.stopActiveServices();
            this.stopStandbyServices();
        }
        catch (IOException iOException) {
            IOUtils.cleanup(LOG, this.dir);
            IOUtils.cleanup(LOG, this.fsImage);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, this.dir);
            IOUtils.cleanup(LOG, this.fsImage);
            throw throwable;
        }
        IOUtils.cleanup(LOG, this.dir);
        IOUtils.cleanup(LOG, this.fsImage);
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    @Override
    public boolean isInStandbyState() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return this.haEnabled;
        }
        return HAServiceProtocol.HAServiceState.STANDBY == this.haContext.getState().getServiceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8)));
            this.metaSave(out);
            out.flush();
            out.close();
        }
        finally {
            this.writeUnlock("metaSave");
        }
    }

    private void metaSave(PrintWriter out) {
        assert (this.hasWriteLock());
        long totalInodes = this.dir.totalInodes();
        long totalBlocks = this.getBlocksTotal();
        out.println(totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total");
        this.blockManager.metaSave(out);
    }

    private String metaSaveAsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.metaSave(pw);
        pw.flush();
        return sw.toString();
    }

    FsServerDefaults getServerDefaults() throws StandbyException {
        this.checkOperation(NameNode.OperationCategory.READ);
        return this.serverDefaults;
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        HdfsFileStatus auditStat;
        String operationName = "setPermission";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set permission for " + src);
            auditStat = FSDirAttrOp.setPermission(this.dir, src, permission);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setPermission", src);
            throw e;
        }
        finally {
            this.writeUnlock("setPermission");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setPermission", src, null, auditStat);
    }

    void setOwner(String src, String username, String group) throws IOException {
        HdfsFileStatus auditStat;
        String operationName = "setOwner";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set owner for " + src);
            auditStat = FSDirAttrOp.setOwner(this.dir, src, username, group);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setOwner", src);
            throw e;
        }
        finally {
            this.writeUnlock("setOwner");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setOwner", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlocks getBlockLocations(String clientMachine, String srcArg, long offset, long length) throws IOException {
        LocatedBlocks blocks;
        String operationName = "open";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSDirStatAndListingOp.GetBlockLocationsResult res = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            res = FSDirStatAndListingOp.getBlockLocations(this.dir, pc, srcArg, offset, length, true);
            if (this.isInSafeMode()) {
                for (LocatedBlock b : res.blocks.getLocatedBlocks()) {
                    if (b.getLocations() != null && b.getLocations().length != 0) continue;
                    SafeModeException se = this.newSafemodeException("Zero blocklocations for " + srcArg);
                    if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
                        throw new RetriableException(se);
                    }
                    throw se;
                }
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", srcArg);
            throw e;
        }
        finally {
            this.readUnlock("open");
        }
        this.logAuditEvent(true, "open", srcArg);
        if (!this.isInSafeMode() && res.updateAccessTime()) {
            String src = srcArg;
            this.writeLock();
            long now = Time.now();
            try {
                boolean changed;
                boolean updateAccessTime;
                this.checkOperation(NameNode.OperationCategory.WRITE);
                INodesInPath iip = this.dir.resolvePath(pc, srcArg, FSDirectory.DirOp.READ);
                src = iip.getPath();
                INode inode = iip.getLastINode();
                boolean bl = updateAccessTime = inode != null && now > inode.getAccessTime() + this.dir.getAccessTimePrecision();
                if (!this.isInSafeMode() && updateAccessTime && (changed = FSDirAttrOp.setTimes(this.dir, iip, -1L, now, false))) {
                    this.getEditLog().logTimes(src, -1L, now);
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to update the access time of " + src, e);
            }
            finally {
                this.writeUnlock("open");
            }
        }
        if ((blocks = res.blocks) != null) {
            this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
            LocatedBlock lastBlock = blocks.getLastLocatedBlock();
            if (lastBlock != null) {
                ArrayList<LocatedBlock> lastBlockList = Lists.newArrayList(lastBlock);
                this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
            }
        }
        return blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs, boolean logRetryCache) throws IOException {
        this.waitForLoadingFSImage();
        String operationName = "concat";
        HdfsFileStatus stat = null;
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot concat " + target);
            stat = FSDirConcatOp.concat(this.dir, target, srcs, logRetryCache);
            success = true;
            this.writeUnlock("concat");
            if (success) {
                this.getEditLog().logSync();
            }
        }
        catch (Throwable throwable) {
            this.writeUnlock("concat");
            if (success) {
                this.getEditLog().logSync();
            }
            this.logAuditEvent(success, "concat", Arrays.toString(srcs), target, stat);
            throw throwable;
        }
        this.logAuditEvent(success, "concat", Arrays.toString(srcs), target, stat);
    }

    void setTimes(String src, long mtime, long atime) throws IOException {
        HdfsFileStatus auditStat;
        String operationName = "setTimes";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set times " + src);
            auditStat = FSDirAttrOp.setTimes(this.dir, src, mtime, atime);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setTimes", src);
            throw e;
        }
        finally {
            this.writeUnlock("setTimes");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setTimes", src, null, auditStat);
    }

    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent, boolean logRetryCache) throws IOException {
        String operationName = "createSymlink";
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create symlink " + link);
            auditStat = FSDirSymlinkOp.createSymlinkInt(this, target, link, dirPerms, createParent, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createSymlink", link, target, null);
            throw e;
        }
        finally {
            this.writeUnlock("createSymlink");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createSymlink", link, target, auditStat);
    }

    boolean setReplication(String src, short replication) throws IOException {
        String operationName = "setReplication";
        boolean success = false;
        this.waitForLoadingFSImage();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set replication for " + src);
            success = FSDirAttrOp.setReplication(this.dir, this.blockManager, src, replication);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setReplication", src);
            throw e;
        }
        finally {
            this.writeUnlock("setReplication");
        }
        if (success) {
            this.getEditLog().logSync();
            this.logAuditEvent(true, "setReplication", src);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncate(String src, long newLength, String clientName, String clientMachine, long mtime) throws IOException, UnresolvedLinkException {
        FSDirTruncateOp.TruncateResult r;
        String operationName = "truncate";
        this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.TRUNCATE);
        try {
            NameNode.stateChangeLog.debug("DIR* NameSystem.truncate: src={} newLength={}", (Object)src, (Object)newLength);
            if (newLength < 0L) {
                throw new HadoopIllegalArgumentException("Cannot truncate to a negative file size: " + newLength + ".");
            }
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.writeLock();
            INode.BlocksMapUpdateInfo toRemoveBlocks = new INode.BlocksMapUpdateInfo();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot truncate for " + src);
                r = FSDirTruncateOp.truncate(this, src, newLength, clientName, clientMachine, mtime, toRemoveBlocks, pc);
            }
            finally {
                this.writeUnlock(operationName);
            }
            this.getEditLog().logSync();
            if (!toRemoveBlocks.getToDeleteList().isEmpty()) {
                this.removeBlocks(toRemoveBlocks);
                toRemoveBlocks.clear();
            }
            this.logAuditEvent(true, operationName, src, null, r.getFileStatus());
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, operationName, src);
            throw e;
        }
        return r.getResult();
    }

    void setStoragePolicy(String src, String policyName) throws IOException {
        HdfsFileStatus auditStat;
        String operationName = "setStoragePolicy";
        this.waitForLoadingFSImage();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set storage policy for " + src);
            auditStat = FSDirAttrOp.setStoragePolicy(this.dir, this.blockManager, src, policyName);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setStoragePolicy", src);
            throw e;
        }
        finally {
            this.writeUnlock("setStoragePolicy");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setStoragePolicy", src, null, auditStat);
    }

    void unsetStoragePolicy(String src) throws IOException {
        HdfsFileStatus auditStat;
        String operationName = "unsetStoragePolicy";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot unset storage policy for " + src);
            auditStat = FSDirAttrOp.unsetStoragePolicy(this.dir, this.blockManager, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "unsetStoragePolicy", src);
            throw e;
        }
        finally {
            this.writeUnlock("unsetStoragePolicy");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "unsetStoragePolicy", src, null, auditStat);
    }

    BlockStoragePolicy getStoragePolicy(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        this.waitForLoadingFSImage();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BlockStoragePolicy blockStoragePolicy = FSDirAttrOp.getStoragePolicy(this.dir, this.blockManager, src);
            return blockStoragePolicy;
        }
        finally {
            this.readUnlock("getStoragePolicy");
        }
    }

    BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        this.waitForLoadingFSImage();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            BlockStoragePolicy[] blockStoragePolicyArray = FSDirAttrOp.getStoragePolicies(this.blockManager);
            return blockStoragePolicyArray;
        }
        finally {
            this.readUnlock("getStoragePolicies");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            long l = FSDirAttrOp.getPreferredBlockSize(this.dir, src);
            return l;
        }
        finally {
            this.readUnlock("getPreferredBlockSize");
        }
    }

    CryptoProtocolVersion chooseProtocolVersion(EncryptionZone zone, CryptoProtocolVersion[] supportedVersions) throws UnknownCryptoProtocolVersionException, UnresolvedLinkException, SnapshotAccessControlException {
        Preconditions.checkNotNull(zone);
        Preconditions.checkNotNull(supportedVersions);
        CryptoProtocolVersion required = zone.getVersion();
        for (CryptoProtocolVersion c : supportedVersions) {
            if (c.equals((Object)CryptoProtocolVersion.UNKNOWN)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring unknown CryptoProtocolVersion provided by client: " + c.getUnknownValue());
                continue;
            }
            if (!c.equals((Object)required)) continue;
            return c;
        }
        throw new UnknownCryptoProtocolVersionException("No crypto protocol versions provided by the client are supported. Client provided: " + Arrays.toString((Object[])supportedVersions) + " NameNode supports: " + Arrays.toString((Object[])CryptoProtocolVersion.values()));
    }

    HdfsFileStatus startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, boolean logRetryCache) throws IOException {
        HdfsFileStatus status;
        try {
            status = this.startFileInt(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize, supportedVersions, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "create", src);
            throw e;
        }
        this.logAuditEvent(true, "create", src, null, status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HdfsFileStatus startFileInt(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, boolean logRetryCache) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("DIR* NameSystem.startFile: src=").append(src).append(", holder=").append(holder).append(", clientMachine=").append(clientMachine).append(", createParent=").append(createParent).append(", replication=").append(replication).append(", createFlag=").append(flag).append(", blockSize=").append(blockSize).append(", supportedVersions=").append(Arrays.toString((Object[])supportedVersions));
            NameNode.stateChangeLog.debug(builder.toString());
        }
        if (!DFSUtil.isValidName(src) || FSDirectory.isExactReservedName(src) || FSDirectory.isReservedName(src) && !FSDirectory.isReservedRawName(src) && !FSDirectory.isReservedInodesName(src)) {
            throw new InvalidPathException(src);
        }
        this.blockManager.verifyReplication(src, replication, clientMachine);
        if (blockSize < this.minBlockSize) {
            throw new IOException("Specified block size is less than configured minimum value (dfs.namenode.fs-limits.min-block-size): " + blockSize + " < " + this.minBlockSize);
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.waitForLoadingFSImage();
        INodesInPath iip = null;
        boolean skipSync = true;
        HdfsFileStatus stat = null;
        INode.BlocksMapUpdateInfo toRemoveBlocks = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            FSDirEncryptionZoneOp.EncryptionKeyInfo ezInfo;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create file" + src);
            iip = FSDirWriteFileOp.resolvePathForStartFile(this.dir, pc, src, flag, createParent);
            FileEncryptionInfo feInfo = null;
            if (this.provider != null && (ezInfo = FSDirEncryptionZoneOp.getEncryptionKeyInfo(this, iip, supportedVersions)) != null) {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                iip = FSDirWriteFileOp.resolvePathForStartFile(this.dir, pc, iip.getPath(), flag, createParent);
                feInfo = FSDirEncryptionZoneOp.getFileEncryptionInfo(this.dir, iip, ezInfo);
            }
            skipSync = false;
            toRemoveBlocks = new INode.BlocksMapUpdateInfo();
            this.dir.writeLock();
            try {
                stat = FSDirWriteFileOp.startFile(this, iip, permissions, holder, clientMachine, flag, createParent, replication, blockSize, feInfo, toRemoveBlocks, logRetryCache);
            }
            catch (IOException e) {
                skipSync = e instanceof StandbyException;
                throw e;
            }
            finally {
                this.dir.writeUnlock();
            }
            this.writeUnlock("create");
            if (!skipSync) {
                this.getEditLog().logSync();
                if (toRemoveBlocks != null) {
                    this.removeBlocks(toRemoveBlocks);
                    toRemoveBlocks.clear();
                }
            }
        }
        catch (Throwable throwable) {
            this.writeUnlock("create");
            if (!skipSync) {
                this.getEditLog().logSync();
                if (toRemoveBlocks != null) {
                    this.removeBlocks(toRemoveBlocks);
                    toRemoveBlocks.clear();
                }
            }
            throw throwable;
        }
        return stat;
    }

    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        boolean skipSync = false;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot recover the lease of " + src);
            INodesInPath iip = this.dir.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
            if (!inode.isUnderConstruction()) {
                boolean bl = true;
                return bl;
            }
            if (this.isPermissionEnabled) {
                this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            boolean bl = this.recoverLeaseInternal(RecoverLeaseOp.RECOVER_LEASE, iip, src, holder, clientMachine, true);
            return bl;
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock("recoverLease");
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
    }

    boolean recoverLeaseInternal(RecoverLeaseOp op, INodesInPath iip, String src, String holder, String clientMachine, boolean force) throws IOException {
        assert (this.hasWriteLock());
        INodeFile file = iip.getLastINode().asFile();
        if (file.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && (leaseFile = this.leaseManager.getLease(file)) != null && leaseFile.equals(lease)) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, holder + " is already the current lease holder."));
            }
            FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
            String clientName = uc.getClientName();
            lease = this.leaseManager.getLease(clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "the file is under construction but no leases found."));
            }
            if (force) {
                LOG.info("recoverLease: " + lease + ", src=" + src + " from client " + clientName);
                return this.internalReleaseLease(lease, src, iip, holder);
            }
            assert (lease.getHolder().equals(clientName)) : "Current lease holder " + lease.getHolder() + " does not match file creator " + clientName;
            if (lease.expiredSoftLimit()) {
                LOG.info("startFile: recover " + lease + ", src=" + src + " client " + clientName);
                if (this.internalReleaseLease(lease, src, iip, null)) {
                    return true;
                }
                throw new RecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "lease recovery is in progress. Try again later."));
            }
            BlockInfo lastBlock = file.getLastBlock();
            if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                throw new RecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "another recovery is in progress by " + clientName + " on " + uc.getClientMachine()));
            }
            throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "this file lease is currently owned by " + clientName + " on " + uc.getClientMachine()));
        }
        return true;
    }

    LastBlockWithStatus appendFile(String srcArg, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean logRetryCache) throws IOException {
        String operationName = "append";
        boolean newBlock = flag.contains((Object)CreateFlag.NEW_BLOCK);
        if (newBlock) {
            this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.APPEND_NEW_BLOCK);
        }
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append is not enabled on this NameNode. Use the dfs.support.append configuration option to enable it.");
        }
        NameNode.stateChangeLog.debug("DIR* NameSystem.appendFile: src={}, holder={}, clientMachine={}", new Object[]{srcArg, holder, clientMachine});
        try {
            boolean skipSync = false;
            LastBlockWithStatus lbs = null;
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.writeLock();
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot append to file" + srcArg);
                lbs = FSDirAppendOp.appendFile(this, srcArg, pc, holder, clientMachine, newBlock, logRetryCache);
            }
            catch (StandbyException se) {
                skipSync = true;
                throw se;
            }
            finally {
                this.writeUnlock("append");
                if (!skipSync) {
                    this.getEditLog().logSync();
                }
            }
            this.logAuditEvent(true, "append", srcArg);
            return lbs;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "append", srcArg);
            throw e;
        }
    }

    ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    void setBlockPoolId(String bpid) {
        this.blockPoolId = bpid;
        this.blockManager.setBlockPoolId(this.blockPoolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalBlock(String src, long fileId, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, String[] favoredNodes, EnumSet<AddBlockFlag> flags) throws IOException {
        LocatedBlock lb;
        FSDirWriteFileOp.ValidateAddBlockResult r;
        String operationName = "getAdditionalBlock";
        NameNode.stateChangeLog.debug("BLOCK* getAdditionalBlock: {} inodeId {} for {}", new Object[]{src, fileId, clientName});
        this.waitForLoadingFSImage();
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            r = FSDirWriteFileOp.validateAddBlock(this, pc, src, fileId, clientName, previous, onRetryBlock);
        }
        finally {
            this.readUnlock("getAdditionalBlock");
        }
        if (r == null) {
            assert (onRetryBlock[0] != null) : "Retry block is null";
            return onRetryBlock[0];
        }
        DatanodeStorageInfo[] targets = FSDirWriteFileOp.chooseTargetForNewBlock(this.blockManager, src, excludedNodes, favoredNodes, flags, r);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            lb = FSDirWriteFileOp.storeAllocatedBlock(this, src, fileId, clientName, previous, targets);
        }
        finally {
            this.writeUnlock("getAdditionalBlock");
        }
        this.getEditLog().logSync();
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] storageIDs, Set<Node> excludes, int numAdditionalNodes, String clientName) throws IOException {
        List<DatanodeStorageInfo> chosen;
        byte storagePolicyID;
        long preferredblocksize;
        String clientMachine;
        this.dtpReplaceDatanodeOnFailure.checkEnabled();
        Node clientnode = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            this.checkNameNodeSafeMode("Cannot add datanode; src=" + src + ", blk=" + blk);
            INodesInPath iip = this.dir.resolvePath(pc, src, fileId);
            src = iip.getPath();
            INodeFile file = this.checkLease(iip, clientName, fileId);
            clientMachine = file.getFileUnderConstructionFeature().getClientMachine();
            clientnode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            preferredblocksize = file.getPreferredBlockSize();
            storagePolicyID = file.getStoragePolicyID();
            DatanodeManager dm = this.blockManager.getDatanodeManager();
            chosen = Arrays.asList(dm.getDatanodeStorageInfos(existings, storageIDs, "src=%s, fileId=%d, blk=%s, clientName=%s, clientMachine=%s", src, fileId, blk, clientName, clientMachine));
        }
        finally {
            this.readUnlock("getAdditionalDatanode");
        }
        if (clientnode == null) {
            clientnode = FSDirWriteFileOp.getClientNode(this.blockManager, clientMachine);
        }
        DatanodeStorageInfo[] targets = this.blockManager.chooseTarget4AdditionalDatanode(src, numAdditionalNodes, clientnode, chosen, excludes, preferredblocksize, storagePolicyID);
        LocatedBlock lb = BlockManager.newLocatedBlock(blk, targets, -1L, false);
        this.blockManager.setBlockToken(lb, BlockTokenIdentifier.AccessMode.COPY);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: {} of file {}", (Object)b, (Object)src);
        this.waitForLoadingFSImage();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot abandon block " + b + " for file" + src);
            FSDirWriteFileOp.abandonBlock(this.dir, pc, b, fileId, src, holder);
            NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: {} is removed from pendingCreates", (Object)b);
        }
        finally {
            this.writeUnlock("abandonBlock");
        }
        this.getEditLog().logSync();
    }

    private String leaseExceptionString(String src, long fileId, String holder) {
        LeaseManager.Lease lease = this.leaseManager.getLease(holder);
        return src + " (inode " + fileId + ") " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files.");
    }

    INodeFile checkLease(INodesInPath iip, String holder, long fileId) throws LeaseExpiredException, FileNotFoundException {
        String src = iip.getPath();
        INode inode = iip.getLastINode();
        assert (this.hasReadLock());
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + this.leaseExceptionString(src, fileId, holder));
        }
        if (!inode.isFile()) {
            throw new LeaseExpiredException("INode is not a regular file: " + this.leaseExceptionString(src, fileId, holder));
        }
        INodeFile file = inode.asFile();
        if (!file.isUnderConstruction()) {
            throw new LeaseExpiredException("File is not open for writing: " + this.leaseExceptionString(src, fileId, holder));
        }
        if (this.isFileDeleted(file)) {
            throw new FileNotFoundException("File is deleted: " + this.leaseExceptionString(src, fileId, holder));
        }
        String owner = file.getFileUnderConstructionFeature().getClientName();
        if (holder != null && !owner.equals(holder)) {
            throw new LeaseExpiredException("Client (=" + holder + ") is not the lease owner (=" + owner + ": " + this.leaseExceptionString(src, fileId, holder));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeFile(String src, String holder, ExtendedBlock last, long fileId) throws IOException {
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.waitForLoadingFSImage();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot complete file " + src);
            success = FSDirWriteFileOp.completeFile(this, pc, src, holder, last, fileId);
        }
        finally {
            this.writeUnlock("org.apache.flink.fs.s3hadoop.shaded.completeFile");
        }
        this.getEditLog().logSync();
        return success;
    }

    Block createNewBlock() throws IOException {
        assert (this.hasWriteLock());
        Block b = new Block(this.nextBlockId(), 0L, 0L);
        b.setGenerationStamp(this.nextGenerationStamp(false));
        return b;
    }

    boolean checkFileProgress(String src, INodeFile v, boolean checkall) {
        assert (this.hasReadLock());
        if (checkall) {
            return this.checkBlocksComplete(src, true, v.getBlocks());
        }
        BlockInfo[] blocks = v.getBlocks();
        int i = blocks.length - this.numCommittedAllowed - 2;
        return i < 0 || blocks[i] == null || this.checkBlocksComplete(src, false, blocks[i]);
    }

    private boolean checkBlocksComplete(String src, boolean allowCommittedBlock, BlockInfo ... blocks) {
        int n = allowCommittedBlock ? this.numCommittedAllowed : 0;
        for (int i = 0; i < blocks.length; ++i) {
            short min = this.blockManager.getMinReplication();
            String err = INodeFile.checkBlockComplete(blocks, i, n, min);
            if (err == null) continue;
            int numNodes = blocks[i].numNodes();
            LOG.info("BLOCK* " + err + "(numNodes= " + numNodes + (numNodes < min ? " < " : " >= ") + " minimum = " + min + ") in file " + src);
            return false;
        }
        return true;
    }

    @Deprecated
    boolean renameTo(String src, String dst, boolean logRetryCache) throws IOException {
        this.waitForLoadingFSImage();
        String operationName = "rename";
        FSDirRenameOp.RenameResult ret = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename " + src);
            ret = FSDirRenameOp.renameToInt(this.dir, src, dst, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename", src, dst, null);
            throw e;
        }
        finally {
            this.writeUnlock("rename");
        }
        boolean success = ret.success;
        if (success) {
            this.getEditLog().logSync();
        }
        this.logAuditEvent(success, "rename", src, dst, ret.auditStat);
        return success;
    }

    void renameTo(String src, String dst, boolean logRetryCache, Options.Rename ... options) throws IOException {
        this.waitForLoadingFSImage();
        String operationName = "rename";
        FSDirRenameOp.RenameResult res = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename " + src);
            res = FSDirRenameOp.renameToInt(this.dir, src, dst, logRetryCache, options);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename (options=" + Arrays.toString((Object[])options) + ")", src, dst, null);
            throw e;
        }
        finally {
            this.writeUnlock("rename");
        }
        this.getEditLog().logSync();
        INode.BlocksMapUpdateInfo collectedBlocks = res.collectedBlocks;
        if (!collectedBlocks.getToDeleteList().isEmpty()) {
            this.removeBlocks(collectedBlocks);
            collectedBlocks.clear();
        }
        this.logAuditEvent(true, "rename (options=" + Arrays.toString((Object[])options) + ")", src, dst, res.auditStat);
    }

    boolean delete(String src, boolean recursive, boolean logRetryCache) throws IOException {
        this.waitForLoadingFSImage();
        String operationName = "delete";
        INode.BlocksMapUpdateInfo toRemovedBlocks = null;
        this.writeLock();
        boolean ret = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot delete " + src);
            toRemovedBlocks = FSDirDeleteOp.delete(this, src, recursive, logRetryCache);
            ret = toRemovedBlocks != null;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
        finally {
            this.writeUnlock("delete");
        }
        this.getEditLog().logSync();
        if (toRemovedBlocks != null) {
            this.removeBlocks(toRemovedBlocks);
        }
        this.logAuditEvent(true, "delete", src);
        return ret;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        return this.dir.getPermissionChecker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBlocks(INode.BlocksMapUpdateInfo blocks) {
        List<BlockInfo> toDeleteList = blocks.getToDeleteList();
        Iterator<BlockInfo> iter = toDeleteList.iterator();
        while (iter.hasNext()) {
            this.writeLock();
            try {
                for (int i = 0; i < BLOCK_DELETION_INCREMENT && iter.hasNext(); ++i) {
                    this.blockManager.removeBlock(iter.next());
                }
            }
            finally {
                this.writeUnlock("removeBlocks");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLeasesAndINodes(List<Long> removedUCFiles, List<INode> removedINodes, boolean acquireINodeMapLock) {
        assert (this.hasWriteLock());
        for (long i : removedUCFiles) {
            this.leaseManager.removeLease(i);
        }
        if (removedINodes != null) {
            if (acquireINodeMapLock) {
                this.dir.writeLock();
            }
            try {
                this.dir.removeFromInodeMap(removedINodes);
            }
            finally {
                if (acquireINodeMapLock) {
                    this.dir.writeUnlock();
                }
            }
            removedINodes.clear();
        }
    }

    void removeBlocksAndUpdateSafemodeTotal(INode.BlocksMapUpdateInfo blocks) {
        assert (this.hasWriteLock());
        boolean trackBlockCounts = this.isSafeModeTrackingBlocks();
        int numRemovedComplete = 0;
        int numRemovedSafe = 0;
        for (BlockInfo b : blocks.getToDeleteList()) {
            if (trackBlockCounts && b.isComplete()) {
                ++numRemovedComplete;
                if (this.blockManager.checkMinReplication(b)) {
                    ++numRemovedSafe;
                }
            }
            this.blockManager.removeBlock(b);
        }
        if (trackBlockCounts) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adjusting safe-mode totals for deletion.decreasing safeBlocks by " + numRemovedSafe + ", totalBlocks by " + numRemovedComplete);
            }
            this.adjustSafeModeBlockTotals(-numRemovedSafe, -numRemovedComplete);
        }
    }

    private boolean isSafeModeTrackingBlocks() {
        if (!this.haEnabled) {
            return false;
        }
        SafeModeInfo sm = this.safeMode;
        return sm != null && sm.shouldIncrementallyTrackBlocks();
    }

    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws IOException {
        String operationName = "getfileinfo";
        this.checkOperation(NameNode.OperationCategory.READ);
        HdfsFileStatus stat = null;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            stat = FSDirStatAndListingOp.getFileInfo(this.dir, src, resolveLink);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getfileinfo", src);
            throw e;
        }
        finally {
            this.readUnlock("getfileinfo");
        }
        this.logAuditEvent(true, "getfileinfo", src);
        return stat;
    }

    boolean isFileClosed(String src) throws IOException {
        String operationName = "isFileClosed";
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            boolean bl = FSDirStatAndListingOp.isFileClosed(this.dir, src);
            return bl;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "isFileClosed", src);
            throw e;
        }
        finally {
            this.readUnlock("isFileClosed");
        }
    }

    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException {
        String operationName = "mkdirs";
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create directory " + src);
            auditStat = FSDirMkdirOp.mkdirs(this, src, permissions, createParent);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "mkdirs", src);
            throw e;
        }
        finally {
            this.writeUnlock("mkdirs");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "mkdirs", src, null, auditStat);
        return true;
    }

    ContentSummary getContentSummary(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "contentSummary";
        this.readLock();
        boolean success = true;
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            ContentSummary contentSummary = FSDirStatAndListingOp.getContentSummary(this.dir, src);
            return contentSummary;
        }
        catch (AccessControlException ace) {
            success = false;
            throw ace;
        }
        finally {
            this.readUnlock("contentSummary");
            this.logAuditEvent(success, "contentSummary", src);
        }
    }

    QuotaUsage getQuotaUsage(String src) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "quotaUsage";
        this.readLock();
        boolean success = true;
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            QuotaUsage quotaUsage = FSDirStatAndListingOp.getQuotaUsage(this.dir, src);
            return quotaUsage;
        }
        catch (AccessControlException ace) {
            success = false;
            throw ace;
        }
        finally {
            this.readUnlock("quotaUsage");
            this.logAuditEvent(success, "quotaUsage", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long ssQuota, StorageType type) throws IOException {
        if (type != null) {
            this.requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature.QUOTA_BY_STORAGE_TYPE);
        }
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "setQuota";
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set quota on " + src);
            FSDirAttrOp.setQuota(this.dir, src, nsQuota, ssQuota, type);
            success = true;
        }
        finally {
            this.writeUnlock("setQuota");
            if (success) {
                this.getEditLog().logSync();
            }
            this.logAuditEvent(success, "setQuota", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        NameNode.stateChangeLog.info("BLOCK* fsync: " + src + " for " + clientName);
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.waitForLoadingFSImage();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot fsync file " + src);
            INodesInPath iip = this.dir.resolvePath(pc, src, fileId);
            src = iip.getPath();
            INodeFile pendingFile = this.checkLease(iip, clientName, fileId);
            if (lastBlockLength > 0L) {
                pendingFile.getFileUnderConstructionFeature().updateLengthOfLastBlock(pendingFile, lastBlockLength);
            }
            FSDirWriteFileOp.persistBlocks(this.dir, src, pendingFile, false);
        }
        finally {
            this.writeUnlock("fsync");
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, INodesInPath iip, String recoveryLeaseHolder) throws IOException {
        int nrCompleteBlocks;
        LOG.info("Recovering " + lease + ", src=" + src);
        assert (!this.isInSafeMode());
        assert (this.hasWriteLock());
        INodeFile pendingFile = iip.getLastINode().asFile();
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
            NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file " + src + " closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn(message);
            throw new IOException(message);
        }
        BlockInfo lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        boolean penultimateBlockMinReplication = penultimateBlock == null || this.blockManager.checkMinReplication(penultimateBlock);
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file" + src + " closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated." + " Try again later.";
                NameNode.stateChangeLog.warn(message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                boolean copyOnTruncate;
                BlockUnderConstructionFeature uc = lastBlock.getUnderConstructionFeature();
                Block recoveryBlock = uc.getTruncateBlock();
                boolean truncateRecovery = recoveryBlock != null;
                boolean bl = copyOnTruncate = truncateRecovery && recoveryBlock.getBlockId() != lastBlock.getBlockId();
                assert (!copyOnTruncate || recoveryBlock.getBlockId() < lastBlock.getBlockId() && recoveryBlock.getGenerationStamp() < lastBlock.getGenerationStamp() && recoveryBlock.getNumBytes() > lastBlock.getNumBytes()) : "wrong recoveryBlock";
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(lastBlock, this.blockManager.getStorages(lastBlock));
                }
                if (uc.getNumExpectedLocations() == 0 && lastBlock.getNumBytes() == 0L) {
                    pendingFile.removeLastBlock(lastBlock);
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId(), false);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Removed empty last block and closed file " + src);
                    return true;
                }
                long blockRecoveryId = this.nextGenerationStamp(this.blockIdManager.isLegacyBlock(lastBlock));
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                if (copyOnTruncate) {
                    lastBlock.setGenerationStamp(blockRecoveryId);
                } else if (truncateRecovery) {
                    recoveryBlock.setGenerationStamp(blockRecoveryId);
                }
                uc.initializeBlockRecovery(lastBlock, blockRecoveryId);
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed." + " Lease recovery is in progress. " + "RecoveryId = " + blockRecoveryId + " for block " + lastBlock);
            }
        }
        return false;
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        if (newHolder == null) {
            return lease;
        }
        this.logReassignLease(lease.getHolder(), src, newHolder);
        return this.reassignLeaseInternal(lease, newHolder, pendingFile);
    }

    LeaseManager.Lease reassignLeaseInternal(LeaseManager.Lease lease, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        pendingFile.getFileUnderConstructionFeature().setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, pendingFile, newHolder);
    }

    void commitOrCompleteLastBlock(INodeFile fileINode, INodesInPath iip, Block commitBlock) throws IOException {
        assert (this.hasWriteLock());
        Preconditions.checkArgument(fileINode.isUnderConstruction());
        this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock, iip);
    }

    void addCommittedBlocksToPending(INodeFile pendingFile) {
        BlockInfo[] blocks = pendingFile.getBlocks();
        int i = blocks.length - this.numCommittedAllowed;
        if (i < 0) {
            i = 0;
        }
        while (i < blocks.length) {
            BlockInfo b = blocks[i];
            if (b != null && b.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
                this.blockManager.addExpectedReplicasToPending(b, pendingFile);
            }
            ++i;
        }
    }

    void finalizeINodeFileUnderConstruction(String src, INodeFile pendingFile, int latestSnapshot, boolean allowCommittedBlock) throws IOException {
        assert (this.hasWriteLock());
        FileUnderConstructionFeature uc = pendingFile.getFileUnderConstructionFeature();
        if (uc == null) {
            throw new IOException("Cannot finalize file " + src + " because it is not under construction");
        }
        pendingFile.recordModification(latestSnapshot);
        pendingFile.toCompleteFile(Time.now(), allowCommittedBlock ? this.numCommittedAllowed : 0, this.blockManager.getMinReplication());
        this.leaseManager.removeLease(uc.getClientName(), pendingFile);
        this.waitForLoadingFSImage();
        this.closeFile(src, pendingFile);
        this.blockManager.checkReplication(pendingFile);
    }

    @VisibleForTesting
    BlockInfo getStoredBlock(Block block) {
        return this.blockManager.getStoredBlock(block);
    }

    @Override
    public boolean isInSnapshot(long blockCollectionID) {
        assert (this.hasReadLock());
        INodeFile bc = this.getBlockCollection(blockCollectionID);
        if (bc == null || !bc.isUnderConstruction()) {
            return false;
        }
        String fullName = bc.getName();
        try {
            if (fullName != null && fullName.startsWith("/") && this.dir.getINode(fullName, FSDirectory.DirOp.READ) == bc) {
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Error while resolving the path : " + fullName, e);
            return false;
        }
        return true;
    }

    INodeFile getBlockCollection(BlockInfo b) {
        return this.getBlockCollection(b.getBlockCollectionId());
    }

    @Override
    public INodeFile getBlockCollection(long id) {
        INode inode = this.getFSDirectory().getInode(id);
        return inode == null ? null : inode.asFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(ExtendedBlock oldBlock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        String src;
        LOG.info("org.apache.flink.fs.s3hadoop.shaded.commitBlockSynchronization(oldBlock=" + oldBlock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")");
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.waitForLoadingFSImage();
        this.writeLock();
        boolean copyTruncate = false;
        BlockInfo truncatedBlock = null;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot commitBlockSynchronization while in safe mode");
            BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock(oldBlock));
            if (storedBlock == null) {
                if (deleteblock) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Block (=" + oldBlock + ") not found");
                    }
                    return;
                }
                throw new IOException("Block (=" + oldBlock + ") not found");
            }
            long oldGenerationStamp = storedBlock.getGenerationStamp();
            long oldNumBytes = storedBlock.getNumBytes();
            if (storedBlock.isDeleted()) {
                throw new IOException("The blockCollection of " + storedBlock + " is null, likely because the file owning this block was" + " deleted and the block removal is delayed");
            }
            INodeFile iFile = this.getBlockCollection(storedBlock);
            src = iFile.getFullPathName();
            if (this.isFileDeleted(iFile)) {
                throw new FileNotFoundException("File not found: " + src + ", likely due to delayed block removal");
            }
            if ((!iFile.isUnderConstruction() || storedBlock.isComplete()) && iFile.getLastBlock().isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unexpected block (=" + oldBlock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
                }
                return;
            }
            truncatedBlock = iFile.getLastBlock();
            long recoveryId = truncatedBlock.getUnderConstructionFeature().getBlockRecoveryId();
            boolean bl = copyTruncate = truncatedBlock.getBlockId() != storedBlock.getBlockId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + oldBlock);
            }
            if (deleteblock) {
                boolean remove;
                Block blockToDel = ExtendedBlock.getLocalBlock(oldBlock);
                boolean bl2 = remove = iFile.removeLastBlock(blockToDel) != null;
                if (remove) {
                    this.blockManager.removeBlock(storedBlock);
                }
            } else {
                int i;
                if (!copyTruncate) {
                    storedBlock.setGenerationStamp(newgenerationstamp);
                    storedBlock.setNumBytes(newlength);
                }
                ArrayList<DatanodeDescriptor> trimmedTargets = new ArrayList<DatanodeDescriptor>(newtargets.length);
                ArrayList<String> trimmedStorages = new ArrayList<String>(newtargets.length);
                if (newtargets.length > 0) {
                    for (i = 0; i < newtargets.length; ++i) {
                        DatanodeDescriptor targetNode = this.blockManager.getDatanodeManager().getDatanode(newtargets[i]);
                        if (targetNode != null) {
                            trimmedTargets.add(targetNode);
                            trimmedStorages.add(newtargetstorages[i]);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("DatanodeDescriptor (=" + newtargets[i] + ") not found");
                    }
                }
                if (closeFile && !trimmedTargets.isEmpty()) {
                    for (i = 0; i < trimmedTargets.size(); ++i) {
                        DatanodeStorageInfo storageInfo = ((DatanodeDescriptor)trimmedTargets.get(i)).getStorageInfo((String)trimmedStorages.get(i));
                        if (storageInfo == null) continue;
                        if (copyTruncate) {
                            storageInfo.addBlock(truncatedBlock);
                            continue;
                        }
                        storageInfo.addBlock(storedBlock);
                    }
                }
                DatanodeStorageInfo[] trimmedStorageInfos = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(trimmedTargets.toArray(new DatanodeID[trimmedTargets.size()]), trimmedStorages.toArray(new String[trimmedStorages.size()]), "src=%s, oldBlock=%s, newgenerationstamp=%d, newlength=%d", src, oldBlock, newgenerationstamp, newlength);
                if (copyTruncate) {
                    iFile.convertLastBlockToUC(truncatedBlock, trimmedStorageInfos);
                } else {
                    iFile.convertLastBlockToUC(storedBlock, trimmedStorageInfos);
                    if (closeFile) {
                        this.blockManager.markBlockReplicasAsCorrupt(storedBlock, oldGenerationStamp, oldNumBytes, trimmedStorageInfos);
                    }
                }
            }
            if (closeFile) {
                if (copyTruncate) {
                    this.closeFileCommitBlocks(src, iFile, truncatedBlock);
                    if (!iFile.isBlockInLatestSnapshot(storedBlock)) {
                        this.blockManager.removeBlock(storedBlock);
                    }
                } else {
                    this.closeFileCommitBlocks(src, iFile, storedBlock);
                }
            } else {
                FSDirWriteFileOp.persistBlocks(this.dir, src, iFile, false);
            }
        }
        finally {
            this.writeUnlock("org.apache.flink.fs.s3hadoop.shaded.commitBlockSynchronization");
        }
        this.getEditLog().logSync();
        if (closeFile) {
            LOG.info("org.apache.flink.fs.s3hadoop.shaded.commitBlockSynchronization(oldBlock=" + oldBlock + ", file=" + src + (copyTruncate ? ", newBlock=" + truncatedBlock : ", newgenerationstamp=" + newgenerationstamp) + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful");
        } else {
            LOG.info("org.apache.flink.fs.s3hadoop.shaded.commitBlockSynchronization(" + oldBlock + ") successful");
        }
    }

    @VisibleForTesting
    void closeFileCommitBlocks(String src, INodeFile pendingFile, BlockInfo storedBlock) throws IOException {
        INodesInPath iip = INodesInPath.fromINode(pendingFile);
        this.commitOrCompleteLastBlock(pendingFile, iip, storedBlock);
        int s = Snapshot.findLatestSnapshot(pendingFile, 0x7FFFFFFE);
        this.finalizeINodeFileUnderConstruction(src, pendingFile, s, false);
    }

    void renewLease(String holder) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot renew lease for " + holder);
            this.leaseManager.renewLease(holder);
        }
        finally {
            this.readUnlock("renewLease");
        }
    }

    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOperation(NameNode.OperationCategory.READ);
        String operationName = "listStatus";
        DirectoryListing dl = null;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            dl = FSDirStatAndListingOp.getListingInt(this.dir, src, startAfter, needLocation);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listStatus", src);
            throw e;
        }
        finally {
            this.readUnlock("listStatus");
        }
        this.logAuditEvent(true, "listStatus", src);
        return dl;
    }

    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
            this.checkSafeMode();
        }
        finally {
            this.writeUnlock("registerDatanode");
        }
    }

    String getRegistrationID() {
        return Storage.getRegistrationID(this.getFSImage().getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes, VolumeFailureSummary volumeFailureSummary, boolean requestFullBlockReportLease) throws IOException {
        this.readLock();
        try {
            int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
            DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, reports, this.blockPoolId, cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes, volumeFailureSummary);
            long blockReportLeaseId = 0L;
            if (requestFullBlockReportLease) {
                blockReportLeaseId = this.blockManager.requestBlockReportLeaseId(nodeReg);
            }
            NNHAStatusHeartbeat haState = new NNHAStatusHeartbeat(this.haContext.getState().getServiceState(), this.getFSImage().getCorrectLastAppliedOrWrittenTxId());
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(cmds, haState, this.rollingUpgradeInfo, blockReportLeaseId);
            return heartbeatResponse;
        }
        finally {
            this.readUnlock("handleHeartbeat");
        }
    }

    void handleLifeline(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
        this.blockManager.getDatanodeManager().handleLifeline(nodeReg, reports, this.getBlockPoolId(), cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes, volumeFailureSummary);
    }

    boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    void checkAvailableResources() {
        Preconditions.checkState(this.nnResourceChecker != null, "nnResourceChecker not initialized");
        this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableDiskSpace();
    }

    private void closeFile(String path, INodeFile file) {
        assert (this.hasWriteLock());
        this.waitForLoadingFSImage();
        this.getEditLog().logCloseFile(path, file);
        NameNode.stateChangeLog.debug("closeFile: {} with {} bloks is persisted to the file system", (Object)path, (Object)file.getBlocks().length);
    }

    public FSImage getFSImage() {
        return this.fsImage;
    }

    public FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"MissingReplOneBlocks", "Number of missing blocks with replication factor 1"})
    public long getMissingReplOneBlocksCount() {
        return this.blockManager.getMissingReplOneBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    @Metric(value={"TransactionsSinceLastCheckpoint", "Number of transactions since last checkpoint"})
    public long getTransactionsSinceLastCheckpoint() {
        return this.getFSImage().getLastAppliedOrWrittenTxId() - this.getFSImage().getStorage().getMostRecentCheckpointTxId();
    }

    @Metric(value={"TransactionsSinceLastLogRoll", "Number of transactions since last edit log roll"})
    public long getTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpenWithoutLock()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxIdWithoutLock() - this.getEditLog().getCurSegmentTxIdWithoutLock() + 1L;
    }

    private long getCorrectTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpen()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxId() - this.getEditLog().getCurSegmentTxId() + 1L;
    }

    @Metric(value={"LastWrittenTransactionId", "Transaction ID written to the edit log"})
    public long getLastWrittenTransactionId() {
        return this.getEditLog().getLastWrittenTxIdWithoutLock();
    }

    @Metric(value={"LastCheckpointTime", "Time in milliseconds since the epoch of the last checkpoint"})
    public long getLastCheckpointTime() {
        return this.getFSImage().getStorage().getMostRecentCheckpointTime();
    }

    long[] getStats() {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        stats[6] = this.getMissingReplOneBlocksCount();
        stats[7] = this.blockManager.getBytesInFuture();
        stats[8] = this.blockManager.getPendingDeletionBlocksCount();
        return stats;
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    @Metric(value={"SnapshottableDirectories", "Number of snapshottable directories"})
    public int getNumSnapshottableDirs() {
        return this.snapshotManager.getNumSnapshottableDirs();
    }

    @Metric(value={"Snapshots", "The number of snapshots"})
    public int getNumSnapshots() {
        return this.snapshotManager.getNumSnapshots();
    }

    @Override
    public String getSnapshotStats() {
        HashMap<String, Integer> info = new HashMap<String, Integer>();
        info.put("SnapshottableDirectories", this.getNumSnapshottableDirs());
        info.put("Snapshots", this.getNumSnapshots());
        return JSON.toString(info);
    }

    @Override
    @Metric(value={"NumEncryptionZones", "The number of encryption zones"})
    public int getNumEncryptionZones() {
        return this.dir.ezManager.getNumEncryptionZones();
    }

    @Override
    @Metric(value={"LockQueueLength", "Number of threads waiting to acquire FSNameSystemLock"})
    public int getFsLockQueueLength() {
        return this.fsLock.getQueueLength();
    }

    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        this.readLock();
        try {
            int n = this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
            return n;
        }
        finally {
            this.readUnlock("getNumberOfDatanodes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            DatanodeInfo[] datanodeInfoArray = arr;
            return datanodeInfoArray;
        }
        finally {
            this.readUnlock("datanodeReport");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> datanodes = dm.getDatanodeListForReport(type);
            DatanodeStorageReport[] reports = new DatanodeStorageReport[datanodes.size()];
            for (int i = 0; i < reports.length; ++i) {
                DatanodeDescriptor d = datanodes.get(i);
                reports[i] = new DatanodeStorageReport(new DatanodeInfo(d), d.getStorageReports());
            }
            DatanodeStorageReport[] datanodeStorageReportArray = reports;
            return datanodeStorageReportArray;
        }
        finally {
            this.readUnlock("getDatanodeStorageReport");
        }
    }

    void saveNamespace() throws AccessControlException, IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.cpLock();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            this.getFSImage().saveNamespace(this);
        }
        finally {
            this.readUnlock("saveNamespace");
            this.cpUnlock();
        }
        LOG.info("New namespace image has been created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.cpLock();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (arg.equals("check")) {
                boolean bl = this.getFSImage().getStorage().getRestoreFailedStorage();
                return bl;
            }
            boolean val = arg.equals("true");
            this.getFSImage().getStorage().setRestoreFailedStorage(val);
            boolean bl = val;
            return bl;
        }
        finally {
            this.writeUnlock("restoreFailedStorage");
            this.cpUnlock();
        }
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.cpLock();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            this.getFSImage().finalizeUpgrade(this.isHaEnabled() && this.inActiveState());
        }
        finally {
            this.writeUnlock("finalizeUpgrade");
            this.cpUnlock();
        }
    }

    void refreshNodes() throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    if (this.blockManager.getBytesInFuture() > 0L) {
                        LOG.error("Refusing to leave safe mode without a force flag. Exiting safe mode will cause a deletion of " + this.blockManager.getBytesInFuture() + " byte(s). Please use " + "-forceExit flag to exit safe mode forcefully and data loss is " + "acceptable.");
                        return this.isInSafeMode();
                    }
                    this.leaveSafeMode();
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                case SAFEMODE_FORCE_EXIT: {
                    if (this.blockManager.getBytesInFuture() > 0L) {
                        LOG.warn("Leaving safe mode due to forceExit. This will cause a data loss of " + this.blockManager.getBytesInFuture() + " byte(s).");
                        this.safeMode.leave(true);
                        this.blockManager.clearBytesInFuture();
                    } else {
                        LOG.warn("forceExit used when normal exist would suffice. Treating force exit as normal safe mode exit.");
                    }
                    this.leaveSafeMode();
                    break;
                }
                default: {
                    LOG.error("Unexpected safe mode action");
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return safeMode.isOn();
    }

    @Override
    public boolean isInStartupSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow() && safeMode.isOn();
    }

    @Override
    public void incrementSafeBlockCount(int replication) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication);
    }

    @Override
    public void decrementSafeBlockCount(BlockInfo b) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        BlockInfo storedBlock = this.getStoredBlock(b);
        if (storedBlock.isComplete()) {
            safeMode.decrementSafeBlockCount((short)this.blockManager.countNodes(b).liveReplicas());
        }
    }

    @Override
    public void adjustSafeModeBlockTotals(int deltaSafe, int deltaTotal) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.adjustBlockTotals(deltaSafe, deltaTotal);
    }

    public void setBlockTotal(long completeBlocksTotal) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal((int)completeBlocksTotal);
    }

    @Override
    @Metric
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    @Metric(value={"NumFilesUnderConstruction", "Number of files under construction"})
    public long getNumFilesUnderConstruction() {
        return this.leaseManager.countPath();
    }

    @Metric(value={"NumActiveClients", "Number of active clients holding lease"})
    public long getNumActiveClients() {
        return this.leaseManager.countLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        this.readLock();
        try {
            numUCBlocks = this.leaseManager.getNumUnderConstructionBlocks();
            long l = this.getBlocksTotal() - numUCBlocks;
            return l;
        }
        finally {
            this.readUnlock("getCompleteBlocksTotal");
        }
    }

    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.writeLock();
        try {
            this.stopSecretManager();
            boolean isEditlogOpenForWrite = this.getEditLog().isOpenForWrite();
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            if (!this.isInSafeMode()) {
                this.safeMode = new SafeModeInfo(resourcesLow);
                return;
            }
            if (resourcesLow) {
                this.safeMode.setResourcesLow();
            } else {
                this.safeMode.setManual();
            }
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            NameNode.stateChangeLog.info("STATE* Safe mode is ON" + this.safeMode.getTurnOffTip());
        }
        finally {
            this.writeUnlock("enterSafeMode");
        }
    }

    void leaveSafeMode() {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info("STATE* Safe mode is already OFF");
                return;
            }
            this.safeMode.leave(false);
        }
        finally {
            this.writeUnlock("leaveSafeMode");
        }
    }

    String getSafeModeTip() {
        SafeModeInfo safeMode = this.safeMode;
        boolean inSafeMode = safeMode == null ? false : safeMode.isOn();
        if (!inSafeMode) {
            return "";
        }
        return safeMode.getTurnOffTip();
    }

    CheckpointSignature rollEditLog() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.JOURNAL);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.JOURNAL);
            this.checkNameNodeSafeMode("Log not rolled");
            if (Server.isRpcInvocation()) {
                LOG.info("Roll Edit Log from " + Server.getRemoteAddress());
            }
            CheckpointSignature checkpointSignature = this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
            return checkpointSignature;
        }
        finally {
            this.writeUnlock("rollEditLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration backupNode, NamenodeRegistration activeNamenode) throws IOException {
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not started");
            LOG.info("Start checkpoint for " + backupNode.getAddress());
            NamenodeCommand cmd = this.getFSImage().startCheckpoint(backupNode, activeNamenode, this.getEffectiveLayoutVersion());
            this.getEditLog().logSync();
            NamenodeCommand namenodeCommand = cmd;
            return namenodeCommand;
        }
        finally {
            this.writeUnlock("startCheckpoint");
        }
    }

    public void processIncrementalBlockReport(DatanodeID nodeID, StorageReceivedDeletedBlocks srdb) throws IOException {
        this.writeLock();
        try {
            this.blockManager.processIncrementalBlockReport(nodeID, srdb);
        }
        finally {
            this.writeUnlock("processIncrementalBlockReport");
        }
    }

    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not ended");
            LOG.info("End checkpoint for " + registration.getAddress());
            this.getFSImage().endCheckpoint(sig);
        }
        finally {
            this.readUnlock("endCheckpoint");
        }
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    @Override
    public long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    @Metric
    public long getFilesTotal() {
        return this.dir.totalInodes();
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getPendingDeletionBlocks() {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Override
    public long getBlockDeletionStartTime() {
        return this.startTime + this.blockManager.getStartupDelayBlockDeletionInMs();
    }

    @Metric
    public long getExcessBlocks() {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getNumTimedOutPendingReplications() {
        return this.blockManager.getNumTimedOutPendingReplications();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getPendingDataNodeMessageCount() {
        return this.blockManager.getPendingDataNodeMessageCount();
    }

    @Metric
    public String getHAState() {
        return this.haContext.getState().toString();
    }

    @Metric
    public long getMillisSinceLastLoadedEdits() {
        if (this.isInStandbyState() && this.editLogTailer != null) {
            return Time.monotonicNow() - this.editLogTailer.getLastLoadTimeMs();
        }
        return 0L;
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    public HAServiceProtocol.HAServiceState getState() {
        return this.haContext == null ? null : this.haContext.getState().getServiceState();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register("NameNode", "FSNamesystemState", bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info("Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.snapshotManager != null) {
            this.snapshotManager.shutdown();
        }
        if (this.mbeanName != null) {
            MBeans.unregister(this.mbeanName);
            this.mbeanName = null;
        }
        if (this.mxbeanName != null) {
            MBeans.unregister(this.mxbeanName);
            this.mxbeanName = null;
        }
        if (this.dir != null) {
            this.dir.shutdown();
        }
        if (this.blockManager != null) {
            this.blockManager.shutdown();
        }
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close provider.", e);
            }
        }
    }

    @Override
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    public int getNumDecomLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        int liveDecommissioned = 0;
        for (DatanodeDescriptor node : live) {
            liveDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return liveDecommissioned;
    }

    @Override
    public int getNumDecomDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, false);
        int deadDecommissioned = 0;
        for (DatanodeDescriptor node : dead) {
            deadDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return deadDecommissioned;
    }

    @Override
    public int getVolumeFailuresTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        int volumeFailuresTotal = 0;
        for (DatanodeDescriptor node : live) {
            volumeFailuresTotal += node.getVolumeFailures();
        }
        return volumeFailuresTotal;
    }

    @Override
    public long getEstimatedCapacityLostTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
        long estimatedCapacityLostTotal = 0L;
        for (DatanodeDescriptor node : live) {
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary == null) continue;
            estimatedCapacityLostTotal += volumeFailureSummary.getEstimatedCapacityLostTotal();
        }
        return estimatedCapacityLostTotal;
    }

    @Override
    public int getNumDecommissioningDataNodes() {
        return this.getBlockManager().getDatanodeManager().getDecommissioningNodes().size();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    @Override
    public int getNumStaleStorages() {
        return this.getBlockManager().getDatanodeManager().getNumStaleStorages();
    }

    @Override
    public String getTopUserOpCounts() {
        if (!this.topConf.isEnabled) {
            return null;
        }
        Date now = new Date();
        List<RollingWindowManager.TopWindow> topWindows = this.topMetrics.getTopWindows();
        TreeMap<String, Object> topMap = new TreeMap<String, Object>();
        topMap.put("windows", topWindows);
        topMap.put("timestamp", DFSUtil.dateToIso8601String(now));
        try {
            return JsonUtil.toJsonString(topMap);
        }
        catch (IOException e) {
            LOG.warn("Failed to fetch TopUser metrics", e);
            return null;
        }
    }

    long nextGenerationStamp(boolean legacyBlock) throws IOException, SafeModeException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next generation stamp");
        long gs = this.blockIdManager.nextGenerationStamp(legacyBlock);
        if (legacyBlock) {
            this.getEditLog().logGenerationStampV1(gs);
        } else {
            this.getEditLog().logGenerationStampV2(gs);
        }
        return gs;
    }

    private long nextBlockId() throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next block ID");
        long blockId = this.blockIdManager.nextBlockId();
        this.getEditLog().logAllocateBlockId(blockId);
        return blockId;
    }

    private boolean isFileDeleted(INodeFile file) {
        if (this.dir.getInode(file.getId()) == null) {
            return true;
        }
        INodeWithAdditionalFields tmpChild = file;
        INodeDirectory tmpParent = file.getParent();
        while (true) {
            if (tmpParent == null) {
                return true;
            }
            INode childINode = tmpParent.getChild(tmpChild.getLocalNameBytes(), 0x7FFFFFFE);
            if (childINode == null || !childINode.equals(tmpChild)) {
                return true;
            }
            if (tmpParent.isRoot()) break;
            tmpChild = tmpParent;
            tmpParent = tmpParent.getParent();
        }
        return file.isWithSnapshot() && file.getFileWithSnapshotFeature().isCurrentFileDeleted();
    }

    private INodeFile checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get a new generation stamp and an access token for block " + block);
        BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock(block));
        if (storedBlock == null) {
            throw new IOException(block + " does not exist.");
        }
        if (storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException("Unexpected BlockUCState: " + block + " is " + (Object)((Object)storedBlock.getBlockUCState()) + " but not " + (Object)((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION));
        }
        INodeFile file = this.getBlockCollection(storedBlock);
        if (file == null || !file.isUnderConstruction() || this.isFileDeleted(file)) {
            throw new IOException("The file " + storedBlock + " belonged to does not exist or it is not under construction.");
        }
        if (clientName == null || !clientName.equals(file.getFileUnderConstructionFeature().getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            for (int i = 0; i < blocks.length; ++i) {
                ExtendedBlock blk = blocks[i].getBlock();
                DatanodeInfo[] nodes = blocks[i].getLocations();
                String[] storageIDs = blocks[i].getStorageIDs();
                for (int j = 0; j < nodes.length; ++j) {
                    NameNode.stateChangeLog.info("*DIR* reportBadBlocks for block: {} on datanode: {}", (Object)blk, (Object)nodes[j].getXferAddr());
                    this.blockManager.findAndMarkBlockAsCorrupt(blk, nodes[j], storageIDs == null ? null : storageIDs[j], "client machine reported it");
                }
            }
        }
        finally {
            this.writeUnlock("reportBadBlocks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp(this.blockIdManager.isLegacyBlock(block.getLocalBlock())));
            locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
            this.blockManager.setBlockToken(locatedBlock, BlockTokenIdentifier.AccessMode.WRITE);
        }
        finally {
            this.writeUnlock("bumpBlockGenerationStamp");
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs, boolean logRetryCache) throws IOException {
        LOG.info("updatePipeline(" + oldBlock.getLocalBlock() + ", newGS=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", client=" + clientName + ")");
        this.waitForLoadingFSImage();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Pipeline not updated");
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes, newStorageIDs, logRetryCache);
        }
        finally {
            this.writeUnlock("updatePipeline");
        }
        this.getEditLog().logSync();
        LOG.info("updatePipeline(" + oldBlock.getLocalBlock() + " => " + newBlock.getLocalBlock() + ") success");
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs, boolean logRetryCache) throws IOException {
        assert (this.hasWriteLock());
        INodeFile pendingFile = this.checkUCBlock(oldBlock, clientName);
        String src = pendingFile.getFullPathName();
        BlockInfo blockinfo = pendingFile.getLastBlock();
        assert (!blockinfo.isComplete());
        if (newBlock.getGenerationStamp() <= blockinfo.getGenerationStamp() || newBlock.getNumBytes() < blockinfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockinfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn(msg);
            throw new IOException(msg);
        }
        blockinfo.setNumBytes(newBlock.getNumBytes());
        blockinfo.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp());
        DatanodeStorageInfo[] storages = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newNodes, newStorageIDs, "src=%s, oldBlock=%s, newBlock=%s, clientName=%s", src, oldBlock, newBlock, clientName);
        blockinfo.getUnderConstructionFeature().setExpectedLocations(blockinfo, storages);
        FSDirWriteFileOp.persistBlocks(this.dir, src, pendingFile, logRetryCache);
    }

    void registerBackupNode(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != bnReg.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)bnReg.getRole()) + " node namespaceID = " + bnReg.getNamespaceID());
            }
            if (bnReg.getRole() == HdfsServerConstants.NamenodeRole.BACKUP) {
                this.getFSImage().getEditLog().registerBackupNode(bnReg, nnReg);
            }
        }
        finally {
            this.writeUnlock("registerBackupNode");
        }
    }

    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.getFSImage().getStorage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock("releaseBackupNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        int count = 0;
        ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
        if (cookieTab == null) {
            cookieTab = new String[]{null};
        }
        if (this.blockManager.getMissingBlocksCount() == 0L) {
            if (cookieTab[0] == null) {
                cookieTab[0] = String.valueOf(FSNamesystem.getIntCookie(cookieTab[0]));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("there are no corrupt file blocks.");
            }
            return corruptFiles;
        }
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!this.blockManager.isPopulatingReplQueues()) {
                throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
            }
            Iterator<BlockInfo> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            int skip = FSNamesystem.getIntCookie(cookieTab[0]);
            for (int i = 0; i < skip && blkIterator.hasNext(); ++i) {
                blkIterator.next();
            }
            while (blkIterator.hasNext()) {
                String src;
                BlockInfo blk = blkIterator.next();
                INodeFile inode = this.getBlockCollection(blk);
                ++skip;
                if (inode == null || this.blockManager.countNodes(blk).liveReplicas() != 0 || !(src = inode.getFullPathName()).startsWith(path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < 100) continue;
                break;
            }
            cookieTab[0] = String.valueOf(skip);
            if (LOG.isDebugEnabled()) {
                LOG.debug("list corrupt file blocks returned: " + count);
            }
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock("listCorruptFileBlocks");
        }
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false), this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token<DelegationTokenIdentifier> token;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot issue delegation token");
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn("trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = FSNamesystem.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token<DelegationTokenIdentifier>(dtId, this.dtSecretManager);
            long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
            this.getEditLog().logGetDelegationToken(dtId, expiryTime);
        }
        finally {
            this.writeUnlock("getDelegationToken");
        }
        this.getEditLog().logSync();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        long expiryTime;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot renew delegation token");
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
            }
            String renewer = FSNamesystem.getRemoteUser().getShortUserName();
            expiryTime = this.dtSecretManager.renewToken(token, renewer);
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock("renewDelegationToken");
        }
        this.getEditLog().logSync();
        return expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot cancel delegation token");
            String canceller = FSNamesystem.getRemoteUser().getUserName();
            DelegationTokenIdentifier id = this.dtSecretManager.cancelToken(token, canceller);
            this.getEditLog().logCancelDelegationToken(id);
        }
        finally {
            this.writeUnlock("cancelDelegationToken");
        }
        this.getEditLog().logSync();
    }

    void saveSecretManagerStateCompat(DataOutputStream out, String sdPath) throws IOException {
        this.dtSecretManager.saveSecretManagerStateCompat(out, sdPath);
    }

    DelegationTokenSecretManager.SecretManagerState saveSecretManagerState() {
        return this.dtSecretManager.saveSecretManagerState();
    }

    void loadSecretManagerStateCompat(DataInput in) throws IOException {
        this.dtSecretManager.loadSecretManagerStateCompat(in);
    }

    void loadSecretManagerState(FsImageProto.SecretManagerSection s, List<FsImageProto.SecretManagerSection.DelegationKey> keys, List<FsImageProto.SecretManagerSection.PersistToken> tokens) throws IOException {
        this.dtSecretManager.loadSecretManagerState(new DelegationTokenSecretManager.SecretManagerState(s, keys, tokens));
    }

    public void logUpdateMasterKey(DelegationKey key) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logUpdateMasterKey(key);
        this.getEditLog().logSync();
    }

    public void logExpireDelegationToken(DelegationTokenIdentifier id) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logCancelDelegationToken(id);
    }

    private void logReassignLease(String leaseHolder, String src, String newHolder) {
        assert (this.hasWriteLock());
        this.getEditLog().logReassignLease(leaseHolder, src, newHolder);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    boolean isExternalInvocation() {
        return Server.isRpcInvocation();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(true, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        this.mxbeanName = MBeans.register("NameNode", "NameNodeInfo", this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. " + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getCacheCapacity() {
        return this.datanodeStatistics.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.datanodeStatistics.getCacheUsed();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    @Deprecated
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getMissingBlocksCount();
    }

    @Override
    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        return this.getMissingReplOneBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, false);
        for (DatanodeDescriptor node : live) {
            ImmutableMap.Builder<String, Object> innerinfo = ImmutableMap.builder();
            innerinfo.put("infoAddr", node.getInfoAddr()).put("infoSecureAddr", node.getInfoSecureAddr()).put("xferaddr", node.getXferAddr()).put("lastContact", (String)((Object)Long.valueOf(this.getLastContact(node)))).put("usedSpace", (String)((Object)Long.valueOf(this.getDfsUsed(node)))).put("adminState", node.getAdminState().toString()).put("nonDfsUsedSpace", (String)((Object)Long.valueOf(node.getNonDfsUsed()))).put("capacity", (String)((Object)Long.valueOf(node.getCapacity()))).put("numBlocks", (String)((Object)Integer.valueOf(node.numBlocks()))).put("version", node.getSoftwareVersion()).put("used", (String)((Object)Long.valueOf(node.getDfsUsed()))).put("remaining", (String)((Object)Long.valueOf(node.getRemaining()))).put("blockScheduled", (String)((Object)Integer.valueOf(node.getBlocksScheduled()))).put("blockPoolUsed", (String)((Object)Long.valueOf(node.getBlockPoolUsed()))).put("blockPoolUsedPercent", (String)((Object)Float.valueOf(node.getBlockPoolUsedPercent()))).put("volfails", (String)((Object)Integer.valueOf(node.getVolumeFailures())));
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary != null) {
                innerinfo.put("failedStorageLocations", volumeFailureSummary.getFailedStorageLocations()).put("lastVolumeFailureDate", (String[])volumeFailureSummary.getLastVolumeFailureDate()).put("estimatedCapacityLostTotal", (String[])volumeFailureSummary.getEstimatedCapacityLostTotal());
            }
            if (node.getUpgradeDomain() != null) {
                innerinfo.put("upgradeDomain", node.getUpgradeDomain());
            }
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo.build());
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap<String, ImmutableMap<String, Long>> info = new HashMap<String, ImmutableMap<String, Long>>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, false);
        for (DatanodeDescriptor node : dead) {
            ImmutableMap<String, Long> innerinfo = ImmutableMap.builder().put("lastContact", this.getLastContact(node)).put("decommissioned", (Long)((Object)Boolean.valueOf(node.isDecommissioned()))).put("xferaddr", (Long)((Object)node.getXferAddr())).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap<String, ImmutableMap<String, String>> info = new HashMap<String, ImmutableMap<String, String>>();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            ImmutableMap<String, String> innerinfo = ImmutableMap.builder().put("xferaddr", node.getXferAddr()).put("underReplicatedBlocks", (String)((Object)Integer.valueOf(node.decommissioningStatus.getUnderReplicatedBlocks()))).put("decommissionOnlyReplicas", (String)((Object)Integer.valueOf(node.decommissioningStatus.getDecommissionOnlyReplicas()))).put("underReplicateInOpenFiles", (String)((Object)Integer.valueOf(node.decommissioningStatus.getUnderReplicatedInOpenFiles()))).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (Time.monotonicNow() - alivenode.getLastUpdateMonotonic()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        return this.getFSImage().getStorage().getClusterID();
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getStorage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        Iterator it = live.iterator();
        while (it.hasNext()) {
            DatanodeDescriptor node = (DatanodeDescriptor)it.next();
            if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
            it.remove();
        }
        if (live.size() > 0) {
            float totalDfsUsed = 0.0f;
            float[] usages = new float[live.size()];
            int i = 0;
            for (DatanodeDescriptor dn : live) {
                usages[i++] = dn.getDfsUsedPercent();
                totalDfsUsed += dn.getDfsUsedPercent();
            }
            totalDfsUsed /= (float)live.size();
            Arrays.sort(usages);
            median = usages[usages.length / 2];
            max = usages[usages.length - 1];
            min = usages[0];
            for (i = 0; i < usages.length; ++i) {
                dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
            }
            dev = (float)Math.sqrt(dev / (float)usages.length);
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format("%.2f%%", Float.valueOf(min)));
        innerInfo.put("median", StringUtils.format("%.2f%%", Float.valueOf(median)));
        innerInfo.put("max", StringUtils.format("%.2f%%", Float.valueOf(max)));
        innerInfo.put("stdDev", StringUtils.format("%.2f%%", Float.valueOf(dev)));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public String getNameJournalStatus() {
        ArrayList jasList = new ArrayList();
        FSEditLog log = this.getFSImage().getEditLog();
        if (log != null) {
            boolean openForWrite = log.isOpenForWriteWithoutLock();
            for (JournalSet.JournalAndStream jas : log.getJournals()) {
                HashMap<String, String> jasMap = new HashMap<String, String>();
                String manager = jas.getManager().toString();
                jasMap.put("required", String.valueOf(jas.isRequired()));
                jasMap.put("disabled", String.valueOf(jas.isDisabled()));
                jasMap.put("manager", manager);
                if (jas.isDisabled()) {
                    jasMap.put("stream", "Failed");
                } else if (openForWrite) {
                    EditLogOutputStream elos = jas.getCurrentStream();
                    if (elos != null) {
                        jasMap.put("stream", elos.generateReport());
                    } else {
                        jasMap.put("stream", "not currently writing");
                    }
                } else {
                    jasMap.put("stream", "open for read");
                }
                jasList.add(jasMap);
            }
        }
        return JSON.toString(jasList);
    }

    @Override
    public String getJournalTransactionInfo() {
        HashMap<String, String> txnIdMap = new HashMap<String, String>();
        txnIdMap.put("LastAppliedOrWrittenTxId", Long.toString(this.getFSImage().getLastAppliedOrWrittenTxId()));
        txnIdMap.put("MostRecentCheckpointTxId", Long.toString(this.getFSImage().getMostRecentCheckpointTxId()));
        return JSON.toString(txnIdMap);
    }

    @Override
    @Deprecated
    public String getNNStarted() {
        return this.getStartTime().toString();
    }

    @Override
    public long getNNStartedTimeInMillis() {
        return this.startTime;
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public BlockIdManager getBlockIdManager() {
        return this.blockIdManager;
    }

    @Override
    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    @VisibleForTesting
    public void setFSDirectory(FSDirectory dir) {
        this.dir = dir;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public HAContext getHAContext() {
        return this.haContext;
    }

    @Override
    public String getCorruptFiles() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks("/", null);
            int corruptFileCount = corruptFileBlocks.size();
            if (corruptFileCount != 0) {
                for (CorruptFileBlockInfo c : corruptFileBlocks) {
                    list.add(c.toString());
                }
            }
        }
        catch (StandbyException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Get corrupt file blocks returned error: " + e.getMessage());
            }
        }
        catch (IOException e) {
            LOG.warn("Get corrupt file blocks returned error: " + e.getMessage());
        }
        return JSON.toString(list);
    }

    @Override
    public long getNumberOfSnapshottableDirs() {
        return this.snapshotManager.getNumSnapshottableDirs();
    }

    List<String> listCorruptFileBlocksWithSnapshot(String path, List<String> snapshottableDirs, String[] cookieTab) throws IOException {
        Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks(path, cookieTab);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<DirectorySnapshottableFeature> lsf = new ArrayList<DirectorySnapshottableFeature>();
        if (snapshottableDirs != null) {
            for (String snap : snapshottableDirs) {
                INode isnap = this.getFSDirectory().getINode(snap, FSDirectory.DirOp.READ_LINK);
                DirectorySnapshottableFeature sf = isnap.asDirectory().getDirectorySnapshottableFeature();
                if (sf == null) {
                    throw new SnapshotException("Directory is not a snapshottable directory: " + snap);
                }
                lsf.add(sf);
            }
        }
        for (CorruptFileBlockInfo c : corruptFileBlocks) {
            Collection<String> snaps;
            if (this.getFileInfo(c.path, true) != null) {
                list.add(c.toString());
            }
            if ((snaps = FSDirSnapshotOp.getSnapshotFiles(this.getFSDirectory(), lsf, c.path)) == null) continue;
            for (String snap : snaps) {
                list.add(c.block.getBlockName() + "\t" + snap);
            }
        }
        return list;
    }

    @Override
    public int getDistinctVersionCount() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions().size();
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public String getNameDirSize() {
        return this.getFSImage().getStorage().getNNDirectorySize();
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken, RetriableException {
        try {
            this.getDelegationTokenSecretManager().verifyToken(identifier, password);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.inTransitionToActive()) {
                throw new RetriableException(it);
            }
            throw it;
        }
    }

    @Override
    public boolean isGenStampInFuture(Block block) {
        return this.blockIdManager.isGenStampInFuture(block);
    }

    @VisibleForTesting
    public EditLogTailer getEditLogTailer() {
        return this.editLogTailer;
    }

    @VisibleForTesting
    public void setEditLogTailerForTests(EditLogTailer tailer) {
        this.editLogTailer = tailer;
    }

    @VisibleForTesting
    void setFsLockForTests(ReentrantReadWriteLock lock) {
        this.fsLock.coarseLock = lock;
    }

    @VisibleForTesting
    public ReentrantReadWriteLock getFsLockForTests() {
        return this.fsLock.coarseLock;
    }

    @VisibleForTesting
    public ReentrantLock getCpLockForTests() {
        return this.cpLock;
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() {
        return this.safeMode;
    }

    @VisibleForTesting
    public void setNNResourceChecker(NameNodeResourceChecker nnResourceChecker) {
        this.nnResourceChecker = nnResourceChecker;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allowSnapshot(String path) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "allowSnapshot";
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot allow snapshot for " + path);
            this.checkSuperuserPrivilege();
            FSDirSnapshotOp.allowSnapshot(this.dir, this.snapshotManager, path);
            success = true;
        }
        finally {
            this.writeUnlock("allowSnapshot");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(success, "allowSnapshot", path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disallowSnapshot(String path) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String operationName = "disallowSnapshot";
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot disallow snapshot for " + path);
            this.checkSuperuserPrivilege();
            FSDirSnapshotOp.disallowSnapshot(this.dir, this.snapshotManager, path);
            success = true;
        }
        finally {
            this.writeUnlock("disallowSnapshot");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(success, "disallowSnapshot", path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createSnapshot(String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        String operationName = "createSnapshot";
        String snapshotPath = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create snapshot for " + snapshotRoot);
            snapshotPath = FSDirSnapshotOp.createSnapshot(this.dir, this.snapshotManager, snapshotRoot, snapshotName, logRetryCache);
        }
        finally {
            this.writeUnlock("createSnapshot");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(snapshotPath != null, "createSnapshot", snapshotRoot, snapshotPath, null);
        return snapshotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameSnapshot(String path, String snapshotOldName, String snapshotNewName, boolean logRetryCache) throws IOException {
        String operationName = "renameSnapshot";
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename snapshot for " + path);
            FSDirSnapshotOp.renameSnapshot(this.dir, this.snapshotManager, path, snapshotOldName, snapshotNewName, logRetryCache);
            success = true;
        }
        finally {
            this.writeUnlock("renameSnapshot");
        }
        this.getEditLog().logSync();
        String oldSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotOldName);
        String newSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotNewName);
        this.logAuditEvent(success, "renameSnapshot", oldSnapshotRoot, newSnapshotRoot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        String operationName = "listSnapshottableDirectory";
        SnapshottableDirectoryStatus[] status = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        boolean success = false;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            status = FSDirSnapshotOp.getSnapshottableDirListing(this.dir, this.snapshotManager);
            success = true;
        }
        finally {
            this.readUnlock("listSnapshottableDirectory");
        }
        this.logAuditEvent(success, "listSnapshottableDirectory", null, null, null);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotDiffReport getSnapshotDiffReport(String path, String fromSnapshot, String toSnapshot) throws IOException {
        String operationName = "org.apache.flink.fs.s3hadoop.shaded.computeSnapshotDiff";
        SnapshotDiffReport diffs = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            diffs = FSDirSnapshotOp.getSnapshotDiffReport(this.dir, this.snapshotManager, path, fromSnapshot, toSnapshot);
        }
        finally {
            this.readUnlock("org.apache.flink.fs.s3hadoop.shaded.computeSnapshotDiff");
        }
        String fromSnapshotRoot = fromSnapshot == null || fromSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, fromSnapshot);
        String toSnapshotRoot = toSnapshot == null || toSnapshot.isEmpty() ? path : Snapshot.getSnapshotPath(path, toSnapshot);
        this.logAuditEvent(diffs != null, "org.apache.flink.fs.s3hadoop.shaded.computeSnapshotDiff", fromSnapshotRoot, toSnapshotRoot, null);
        return diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSnapshot(String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        String operationName = "deleteSnapshot";
        boolean success = false;
        this.writeLock();
        INode.BlocksMapUpdateInfo blocksToBeDeleted = null;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot delete snapshot for " + snapshotRoot);
            blocksToBeDeleted = FSDirSnapshotOp.deleteSnapshot(this.dir, this.snapshotManager, snapshotRoot, snapshotName, logRetryCache);
            success = true;
        }
        finally {
            this.writeUnlock("deleteSnapshot");
        }
        this.getEditLog().logSync();
        if (blocksToBeDeleted != null) {
            this.removeBlocks(blocksToBeDeleted);
        }
        String rootPath = Snapshot.getSnapshotPath(snapshotRoot, snapshotName);
        this.logAuditEvent(success, "deleteSnapshot", rootPath, null, null);
    }

    void removeSnapshottableDirs(List<INodeDirectory> toRemove) {
        if (this.snapshotManager != null) {
            this.snapshotManager.removeSnapshottable(toRemove);
        }
    }

    RollingUpgradeInfo queryRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            if (!this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = null;
                return rollingUpgradeInfo;
            }
            Preconditions.checkNotNull(this.rollingUpgradeInfo);
            boolean hasRollbackImage = this.getFSImage().hasRollbackFSImage();
            this.rollingUpgradeInfo.setCreatedRollbackImages(hasRollbackImage);
            RollingUpgradeInfo rollingUpgradeInfo = this.rollingUpgradeInfo;
            return rollingUpgradeInfo;
        }
        finally {
            this.readUnlock("queryRollingUpgrade");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RollingUpgradeInfo startRollingUpgrade() throws IOException {
        String operationName = "startRollingUpgrade";
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = this.rollingUpgradeInfo;
                return rollingUpgradeInfo;
            }
            long startTime = Time.now();
            if (!this.haEnabled) {
                this.startRollingUpgradeInternalForNonHA(startTime);
            } else {
                this.checkNameNodeSafeMode("Failed to start rolling upgrade");
                this.startRollingUpgradeInternal(startTime);
            }
            this.getEditLog().logStartRollingUpgrade(this.rollingUpgradeInfo.getStartTime());
            if (this.haEnabled) {
                this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
            }
        }
        finally {
            this.writeUnlock("startRollingUpgrade");
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "startRollingUpgrade", null, null, null);
        }
        return this.rollingUpgradeInfo;
    }

    void startRollingUpgradeInternal(long startTime) throws IOException {
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade();
        this.setRollingUpgradeInfo(false, startTime);
    }

    private void startRollingUpgradeInternalForNonHA(long startTime) throws IOException {
        Preconditions.checkState(!this.haEnabled);
        if (!this.isInSafeMode()) {
            throw new IOException("Safe mode should be turned ON in order to create namespace image.");
        }
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade();
        this.getFSImage().saveNamespace(this, NNStorage.NameNodeFile.IMAGE_ROLLBACK, null);
        LOG.info("Successfully saved namespace for preparing rolling upgrade.");
        this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.setRollingUpgradeInfo(true, startTime);
    }

    void setRollingUpgradeInfo(boolean createdRollbackImages, long startTime) {
        this.rollingUpgradeInfo = new RollingUpgradeInfo(this.blockPoolId, createdRollbackImages, startTime, 0L);
    }

    public void setCreatedRollbackImages(boolean created) {
        if (this.rollingUpgradeInfo != null) {
            this.rollingUpgradeInfo.setCreatedRollbackImages(created);
        }
    }

    public RollingUpgradeInfo getRollingUpgradeInfo() {
        return this.rollingUpgradeInfo;
    }

    public boolean isNeedRollbackFsImage() {
        return this.needRollbackFsImage;
    }

    public void setNeedRollbackFsImage(boolean needRollbackFsImage) {
        this.needRollbackFsImage = needRollbackFsImage;
    }

    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        if (!this.isRollingUpgrade()) {
            return null;
        }
        RollingUpgradeInfo upgradeInfo = this.getRollingUpgradeInfo();
        if (upgradeInfo.createdRollbackImages()) {
            return new RollingUpgradeInfo.Bean(upgradeInfo);
        }
        this.readLock();
        try {
            upgradeInfo = this.getRollingUpgradeInfo();
            if (upgradeInfo == null) {
                RollingUpgradeInfo.Bean bean = null;
                return bean;
            }
            if (!upgradeInfo.createdRollbackImages()) {
                boolean hasRollbackImage = this.getFSImage().hasRollbackFSImage();
                upgradeInfo.setCreatedRollbackImages(hasRollbackImage);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception setting Rollback Image", ioe);
        }
        finally {
            this.readUnlock("getRollingUpgradeStatus");
        }
        return new RollingUpgradeInfo.Bean(upgradeInfo);
    }

    public boolean isRollingUpgrade() {
        return this.rollingUpgradeInfo != null && !this.rollingUpgradeInfo.isFinalized();
    }

    public int getEffectiveLayoutVersion() {
        return FSNamesystem.getEffectiveLayoutVersion(this.isRollingUpgrade(), this.fsImage.getStorage().getLayoutVersion(), NameNodeLayoutVersion.MINIMUM_COMPATIBLE_LAYOUT_VERSION, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
    }

    @VisibleForTesting
    static int getEffectiveLayoutVersion(boolean isRollingUpgrade, int storageLV, int minCompatLV, int currentLV) {
        if (isRollingUpgrade && storageLV <= minCompatLV) {
            return storageLV;
        }
        return currentLV;
    }

    private void requireEffectiveLayoutVersionForFeature(NameNodeLayoutVersion.Feature f) throws HadoopIllegalArgumentException {
        int lv = this.getEffectiveLayoutVersion();
        if (!NameNodeLayoutVersion.supports(f, lv)) {
            throw new HadoopIllegalArgumentException(String.format("Feature %s unsupported at NameNode layout version %d.  If a rolling upgrade is in progress, then it must be finalized before using this feature.", f, lv));
        }
    }

    void checkRollingUpgrade(String action) throws RollingUpgradeException {
        if (this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to " + action + " since a rolling upgrade is already in progress." + " Existing rolling upgrade info:\n" + this.rollingUpgradeInfo);
        }
    }

    RollingUpgradeInfo finalizeRollingUpgrade() throws IOException {
        String operationName = "finalizeRollingUpgrade";
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (!this.isRollingUpgrade()) {
                RollingUpgradeInfo rollingUpgradeInfo = null;
                return rollingUpgradeInfo;
            }
            this.checkNameNodeSafeMode("Failed to finalize rolling upgrade");
            this.finalizeRollingUpgradeInternal(Time.now());
            this.getEditLog().logFinalizeRollingUpgrade(this.rollingUpgradeInfo.getFinalizeTime());
            if (this.haEnabled) {
                this.getFSImage().rollEditLog(this.getEffectiveLayoutVersion());
            }
            this.getFSImage().updateStorageVersion();
            this.getFSImage().renameCheckpoint(NNStorage.NameNodeFile.IMAGE_ROLLBACK, NNStorage.NameNodeFile.IMAGE);
        }
        finally {
            this.writeUnlock("finalizeRollingUpgrade");
        }
        if (!this.haEnabled) {
            this.getEditLog().logSync();
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "finalizeRollingUpgrade", null, null, null);
        }
        return this.rollingUpgradeInfo;
    }

    void finalizeRollingUpgradeInternal(long finalizeTime) {
        this.rollingUpgradeInfo.finalize(finalizeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        boolean success;
        String operationName = "addCacheDirective";
        CacheDirectiveInfo effectiveDirective = null;
        if (!flags.contains((Object)CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot add cache directive");
            effectiveDirective = FSNDNCacheOp.addCacheDirective(this, this.cacheManager, directive, flags, logRetryCache);
            this.writeUnlock("addCacheDirective");
            boolean bl = success = effectiveDirective != null;
        }
        catch (Throwable throwable) {
            boolean success2;
            this.writeUnlock("addCacheDirective");
            boolean bl = success2 = effectiveDirective != null;
            if (success2) {
                this.getEditLog().logSync();
            }
            String effectiveDirectiveStr = effectiveDirective != null ? effectiveDirective.toString() : null;
            this.logAuditEvent(success2, "addCacheDirective", effectiveDirectiveStr, null, null);
            throw throwable;
        }
        if (success) {
            this.getEditLog().logSync();
        }
        String effectiveDirectiveStr = effectiveDirective != null ? effectiveDirective.toString() : null;
        this.logAuditEvent(success, "addCacheDirective", effectiveDirectiveStr, null, null);
        return effectiveDirective != null ? effectiveDirective.getId() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags, boolean logRetryCache) throws IOException {
        String operationName = "modifyCacheDirective";
        boolean success = false;
        if (!flags.contains((Object)CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot add cache directive");
            FSNDNCacheOp.modifyCacheDirective(this, this.cacheManager, directive, flags, logRetryCache);
            success = true;
        }
        finally {
            this.writeUnlock("modifyCacheDirective");
            if (success) {
                this.getEditLog().logSync();
            }
            String idStr = "{id: " + directive.getId() + "}";
            this.logAuditEvent(success, "modifyCacheDirective", idStr, directive.toString(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheDirective(long id, boolean logRetryCache) throws IOException {
        String operationName = "removeCacheDirective";
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove cache directives");
            FSNDNCacheOp.removeCacheDirective(this, this.cacheManager, id, logRetryCache);
            success = true;
        }
        finally {
            this.writeUnlock("removeCacheDirective");
            String idStr = "{id: " + Long.toString(id) + "}";
            this.logAuditEvent(success, "removeCacheDirective", idStr, null, null);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(long startId, CacheDirectiveInfo filter) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> results;
        String operationName = "listCacheDirectives";
        this.checkOperation(NameNode.OperationCategory.READ);
        this.cacheManager.waitForRescanIfNeeded();
        this.readLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            results = FSNDNCacheOp.listCacheDirectives(this, this.cacheManager, startId, filter);
            success = true;
        }
        finally {
            this.readUnlock("listCacheDirectives");
            this.logAuditEvent(success, "listCacheDirectives", filter.toString(), null, null);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachePool(CachePoolInfo req, boolean logRetryCache) throws IOException {
        String operationName = "addCachePool";
        this.writeLock();
        boolean success = false;
        String poolInfoStr = null;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot add cache pool" + (req == null ? null : req.getPoolName()));
            CachePoolInfo info = FSNDNCacheOp.addCachePool(this, this.cacheManager, req, logRetryCache);
            poolInfoStr = info.toString();
            success = true;
            this.writeUnlock("addCachePool");
        }
        catch (Throwable throwable) {
            this.writeUnlock("addCachePool");
            this.logAuditEvent(success, "addCachePool", poolInfoStr, null, null);
            throw throwable;
        }
        this.logAuditEvent(success, "addCachePool", poolInfoStr, null, null);
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCachePool(CachePoolInfo req, boolean logRetryCache) throws IOException {
        String operationName = "modifyCachePool";
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot modify cache pool" + (req == null ? null : req.getPoolName()));
            FSNDNCacheOp.modifyCachePool(this, this.cacheManager, req, logRetryCache);
            success = true;
            this.writeUnlock("modifyCachePool");
            String poolNameStr = "{poolName: " + (req == null ? null : req.getPoolName()) + "}";
            this.logAuditEvent(success, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
        }
        catch (Throwable throwable) {
            this.writeUnlock("modifyCachePool");
            String poolNameStr = "{poolName: " + (req == null ? null : req.getPoolName()) + "}";
            this.logAuditEvent(success, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
            throw throwable;
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachePool(String cachePoolName, boolean logRetryCache) throws IOException {
        String operationName = "removeCachePool";
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot modify cache pool" + cachePoolName);
            FSNDNCacheOp.removeCachePool(this, this.cacheManager, cachePoolName, logRetryCache);
            success = true;
        }
        finally {
            this.writeUnlock("removeCachePool");
            String poolNameStr = "{poolName: " + cachePoolName + "}";
            this.logAuditEvent(success, "removeCachePool", poolNameStr, null, null);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> results;
        String operationName = "listCachePools";
        this.checkOperation(NameNode.OperationCategory.READ);
        boolean success = false;
        this.cacheManager.waitForRescanIfNeeded();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            results = FSNDNCacheOp.listCachePools(this, this.cacheManager, prevKey);
            success = true;
        }
        finally {
            this.readUnlock("listCachePools");
            this.logAuditEvent(success, "listCachePools", null, null, null);
        }
        return results;
    }

    void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "modifyAclEntries";
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot modify ACL entries on " + src);
            auditStat = FSDirAclOp.modifyAclEntries(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "modifyAclEntries", src);
            throw e;
        }
        finally {
            this.writeUnlock("modifyAclEntries");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "modifyAclEntries", src, null, auditStat);
    }

    void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "removeAclEntries";
        this.checkOperation(NameNode.OperationCategory.WRITE);
        HdfsFileStatus auditStat = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove ACL entries on " + src);
            auditStat = FSDirAclOp.removeAclEntries(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAclEntries", src);
            throw e;
        }
        finally {
            this.writeUnlock("removeAclEntries");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAclEntries", src, null, auditStat);
    }

    void removeDefaultAcl(String src) throws IOException {
        String operationName = "removeDefaultAcl";
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove default ACL entries on " + src);
            auditStat = FSDirAclOp.removeDefaultAcl(this.dir, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeDefaultAcl", src);
            throw e;
        }
        finally {
            this.writeUnlock("removeDefaultAcl");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeDefaultAcl", src, null, auditStat);
    }

    void removeAcl(String src) throws IOException {
        String operationName = "removeAcl";
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove ACL on " + src);
            auditStat = FSDirAclOp.removeAcl(this.dir, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAcl", src);
            throw e;
        }
        finally {
            this.writeUnlock("removeAcl");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAcl", src, null, auditStat);
    }

    void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        String operationName = "setAcl";
        HdfsFileStatus auditStat = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set ACL on " + src);
            auditStat = FSDirAclOp.setAcl(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setAcl", src);
            throw e;
        }
        finally {
            this.writeUnlock("setAcl");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setAcl", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        String operationName = "getAclStatus";
        this.checkOperation(NameNode.OperationCategory.READ);
        boolean success = false;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            AclStatus ret = FSDirAclOp.getAclStatus(this.dir, src);
            success = true;
            AclStatus aclStatus = ret;
            return aclStatus;
        }
        finally {
            this.readUnlock("getAclStatus");
            this.logAuditEvent(success, "getAclStatus", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEncryptionZone(String src, String keyName, boolean logRetryCache) throws IOException, UnresolvedLinkException, SafeModeException, AccessControlException {
        String operationName = "createEncryptionZone";
        try {
            HdfsFileStatus resultingStat;
            KeyProvider.Metadata metadata = FSDirEncryptionZoneOp.ensureKeyIsInitialized(this.dir, keyName, src);
            this.checkSuperuserPrivilege();
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.writeLock();
            try {
                this.checkSuperuserPrivilege();
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot create encryption zone on " + src);
                resultingStat = FSDirEncryptionZoneOp.createEncryptionZone(this.dir, src, pc, metadata.getCipher(), keyName, logRetryCache);
            }
            finally {
                this.writeUnlock("createEncryptionZone");
            }
            this.getEditLog().logSync();
            this.logAuditEvent(true, "createEncryptionZone", src, null, resultingStat);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createEncryptionZone", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EncryptionZone getEZForPath(String srcArg) throws AccessControlException, UnresolvedLinkException, IOException {
        EncryptionZone encryptionZone;
        String operationName = "getEZForPath";
        HdfsFileStatus resultingStat = null;
        boolean success = false;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            Map.Entry<EncryptionZone, HdfsFileStatus> ezForPath = FSDirEncryptionZoneOp.getEZForPath(this.dir, srcArg, pc);
            success = true;
            resultingStat = ezForPath.getValue();
            encryptionZone = ezForPath.getKey();
            this.readUnlock("getEZForPath");
        }
        catch (Throwable throwable) {
            this.readUnlock("getEZForPath");
            this.logAuditEvent(success, "getEZForPath", srcArg, null, resultingStat);
            throw throwable;
        }
        this.logAuditEvent(success, "getEZForPath", srcArg, null, resultingStat);
        return encryptionZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        String operationName = "listEncryptionZones";
        boolean success = false;
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkSuperuserPrivilege();
            this.checkOperation(NameNode.OperationCategory.READ);
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> ret = FSDirEncryptionZoneOp.listEncryptionZones(this.dir, prevId);
            success = true;
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = ret;
            return batchedListEntries;
        }
        finally {
            this.readUnlock("listEncryptionZones");
            this.logAuditEvent(success, "listEncryptionZones", null);
        }
    }

    void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag, boolean logRetryCache) throws IOException {
        String operationName = "setXAttr";
        HdfsFileStatus auditStat = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set XAttr on " + src);
            auditStat = FSDirXAttrOp.setXAttr(this.dir, src, xAttr, flag, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setXAttr", src);
            throw e;
        }
        finally {
            this.writeUnlock("setXAttr");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setXAttr", src, null, auditStat);
    }

    List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        String operationName = "getXAttrs";
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            List<XAttr> list = FSDirXAttrOp.getXAttrs(this.dir, src, xAttrs);
            return list;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getXAttrs", src);
            throw e;
        }
        finally {
            this.readUnlock("getXAttrs");
        }
    }

    List<XAttr> listXAttrs(String src) throws IOException {
        String operationName = "listXAttrs";
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            List<XAttr> list = FSDirXAttrOp.listXAttrs(this.dir, src);
            return list;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listXAttrs", src);
            throw e;
        }
        finally {
            this.readUnlock("listXAttrs");
        }
    }

    void removeXAttr(String src, XAttr xAttr, boolean logRetryCache) throws IOException {
        String operationName = "removeXAttr";
        HdfsFileStatus auditStat = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove XAttr entry on " + src);
            auditStat = FSDirXAttrOp.removeXAttr(this.dir, src, xAttr, logRetryCache);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeXAttr", src);
            throw e;
        }
        finally {
            this.writeUnlock("removeXAttr");
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeXAttr", src, null, auditStat);
    }

    void checkAccess(String src, FsAction mode) throws IOException {
        String operationName = "checkAccess";
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            INodesInPath iip = this.dir.resolvePath(pc, src, FSDirectory.DirOp.READ);
            src = iip.getPath();
            INode inode = iip.getLastINode();
            if (inode == null) {
                throw new FileNotFoundException("Path not found");
            }
            if (this.isPermissionEnabled) {
                this.dir.checkPathAccess(pc, iip, mode);
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "checkAccess", src);
            throw e;
        }
        finally {
            this.readUnlock("checkAccess");
        }
    }

    private static void enableAsyncAuditLog() {
        if (!(auditLog instanceof Log4JLogger)) {
            LOG.warn("Log4j is required to enable async auditlog");
            return;
        }
        Logger logger = ((Log4JLogger)auditLog).getLogger();
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof AsyncAppender)) {
            AsyncAppender asyncAppender = new AsyncAppender();
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    @Override
    @Metric(value={"TotalSyncCount", "Total number of sync operations performed on edit logs"})
    public long getTotalSyncCount() {
        return this.fsImage.editLog.getTotalSyncCount();
    }

    @Override
    @Metric(value={"TotalSyncTimes", "Total time spend in sync operation on various edit logs"})
    public String getTotalSyncTimes() {
        JournalSet journalSet = this.fsImage.editLog.getJournalSet();
        if (journalSet != null) {
            return journalSet.getSyncTimes();
        }
        return "";
    }

    public long getBytesInFuture() {
        return this.blockManager.getBytesInFuture();
    }

    @VisibleForTesting
    synchronized void enableSafeModeForTesting(Configuration conf) {
        SafeModeInfo newSafemode = new SafeModeInfo(conf);
        newSafemode.enter();
        this.safeMode = newSafemode;
    }

    @VisibleForTesting
    static class DefaultAuditLogger
    extends HdfsAuditLogger {
        private static final ThreadLocal<StringBuilder> STRING_BUILDER = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder();
            }
        };
        private boolean isCallerContextEnabled;
        private int callerContextMaxLen;
        private int callerSignatureMaxLen;
        private boolean logTokenTrackingId;
        private Set<String> debugCmdSet = new HashSet<String>();

        DefaultAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
            this.isCallerContextEnabled = conf.getBoolean("hadoop.caller.context.enabled", false);
            this.callerContextMaxLen = conf.getInt("hadoop.caller.context.max.size", 128);
            this.callerSignatureMaxLen = conf.getInt("hadoop.caller.context.signature.max.size", 40);
            this.logTokenTrackingId = conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false);
            this.debugCmdSet.addAll(Arrays.asList(conf.getTrimmedStrings("dfs.namenode.audit.log.debug.cmdlist")));
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, CallerContext callerContext, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            if (auditLog.isDebugEnabled() || auditLog.isInfoEnabled() && !this.debugCmdSet.contains(cmd)) {
                StringBuilder sb = STRING_BUILDER.get();
                src = StringEscapeUtils.escapeJava(src);
                dst = StringEscapeUtils.escapeJava(dst);
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t");
                sb.append("ugi=").append(userName).append("\t");
                sb.append("ip=").append(addr).append("\t");
                sb.append("cmd=").append(cmd).append("\t");
                sb.append("src=").append(src).append("\t");
                sb.append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=");
                    sb.append(status.getOwner()).append(":");
                    sb.append(status.getGroup()).append(":");
                    sb.append(status.getPermission());
                }
                if (this.logTokenTrackingId) {
                    sb.append("\t").append("trackingId=");
                    String trackingId = null;
                    if (ugi != null && dtSecretManager != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.TOKEN) {
                        for (TokenIdentifier tid : ugi.getTokenIdentifiers()) {
                            if (!(tid instanceof DelegationTokenIdentifier)) continue;
                            DelegationTokenIdentifier dtid = (DelegationTokenIdentifier)tid;
                            trackingId = dtSecretManager.getTokenTrackingId(dtid);
                            break;
                        }
                    }
                    sb.append(trackingId);
                }
                sb.append("\t").append("proto=");
                sb.append(Server.getProtocol());
                if (this.isCallerContextEnabled && callerContext != null && callerContext.isContextValid()) {
                    sb.append("\t").append("callerContext=");
                    if (callerContext.getContext().length() > this.callerContextMaxLen) {
                        sb.append(callerContext.getContext().substring(0, this.callerContextMaxLen));
                    } else {
                        sb.append(callerContext.getContext());
                    }
                    if (callerContext.getSignature() != null && callerContext.getSignature().length > 0 && callerContext.getSignature().length <= this.callerSignatureMaxLen) {
                        sb.append(":");
                        sb.append(new String(callerContext.getSignature(), CallerContext.SIGNATURE_ENCODING));
                    }
                }
                this.logAuditMessage(sb.toString());
            }
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            this.logAuditEvent(succeeded, userName, addr, cmd, src, dst, status, null, ugi, dtSecretManager);
        }

        public void logAuditMessage(String message) {
            auditLog.info(message);
        }
    }

    static class CorruptFileBlockInfo {
        final String path;
        final Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                FSNamesystem.this.writeLock();
                try {
                    if (FSNamesystem.this.safeMode == null) break;
                    if (FSNamesystem.this.safeMode.canLeave()) {
                        FSNamesystem.this.safeMode.leave(false);
                        FSNamesystem.this.smmthread = null;
                        break;
                    }
                }
                finally {
                    FSNamesystem.this.writeUnlock();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!FSNamesystem.this.fsRunning) {
                LOG.info("NameNode is being shutdown, exit SafeModeMonitor thread");
            }
        }
    }

    public class SafeModeInfo {
        private final double threshold;
        private final int datanodeThreshold;
        private volatile int extension;
        private final int safeReplication;
        private final double replQueueThreshold;
        private long reached = -1L;
        private long reachedTimestamp = -1L;
        int blockTotal;
        int blockSafe;
        private int blockThreshold;
        private int blockReplQueueThreshold;
        private long lastStatusReport = 0L;
        private volatile boolean resourcesLow = false;
        private boolean shouldIncrementallyTrackBlocks = false;
        private StartupProgress.Counter awaitingReportedBlocksCounter;

        private SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn("The threshold value should't be greater than 1, threshold: " + this.threshold);
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            int minReplication = conf.getInt("dfs.namenode.replication.min", 1);
            this.safeReplication = conf.getInt("dfs.namenode.safemode.replication.min", minReplication);
            LOG.info("dfs.namenode.safemode.threshold-pct = " + this.threshold);
            LOG.info("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold);
            LOG.info("dfs.namenode.safemode.extension     = " + this.extension);
            this.replQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private boolean shouldIncrementallyTrackBlocks() {
            return this.shouldIncrementallyTrackBlocks;
        }

        private SafeModeInfo(boolean resourcesLow) {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replQueueThreshold = 1.5;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.resourcesLow = resourcesLow;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private synchronized boolean isOn() {
            this.doConsistencyCheck();
            return this.reached >= 0L;
        }

        private void enter() {
            this.reached = 0L;
            this.reachedTimestamp = 0L;
        }

        private synchronized void leave(boolean force) {
            if (!FSNamesystem.this.blockManager.isPopulatingReplQueues() && FSNamesystem.this.blockManager.shouldPopulateReplQueues()) {
                FSNamesystem.this.blockManager.initializeReplQueues();
            }
            if (!force && FSNamesystem.this.blockManager.getBytesInFuture() > 0L) {
                LOG.error("Refusing to leave safe mode without a force flag. Exiting safe mode will cause a deletion of " + FSNamesystem.this.blockManager.getBytesInFuture() + " byte(s). Please use " + "-forceExit flag to exit safe mode forcefully if data loss is " + "acceptable.");
                return;
            }
            long timeInSafemode = Time.now() - FSNamesystem.this.startTime;
            NameNode.stateChangeLog.info("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs");
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info("STATE* Safe mode is OFF");
            }
            this.reached = -1L;
            this.reachedTimestamp = -1L;
            FSNamesystem.this.safeMode = null;
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes");
            NameNode.stateChangeLog.info("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks");
            FSNamesystem.this.startSecretManagerIfNecessary();
            StartupProgress prog = NameNode.getStartupProgress();
            if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                prog.endStep(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                prog.endPhase(Phase.SAFEMODE);
            }
        }

        private synchronized boolean canInitializeReplQueues() {
            return FSNamesystem.this.blockManager.shouldPopulateReplQueues() && this.blockSafe >= this.blockReplQueueThreshold;
        }

        private synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (Time.monotonicNow() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON, in safe mode extension.", false);
                return false;
            }
            if (this.needEnter()) {
                this.reportStatus("STATE* Safe mode ON, thresholds not met.", false);
                return false;
            }
            return true;
        }

        private boolean needEnter() {
            return this.threshold != 0.0 && this.blockSafe < this.blockThreshold || this.datanodeThreshold != 0 && FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() {
            assert (FSNamesystem.this.hasWriteLock());
            if (FSNamesystem.this.inTransitionToActive()) {
                return;
            }
            if (FSNamesystem.this.smmthread == null && this.needEnter()) {
                this.enter();
                if (this.canInitializeReplQueues() && !FSNamesystem.this.blockManager.isPopulatingReplQueues() && !FSNamesystem.this.haEnabled) {
                    FSNamesystem.this.blockManager.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(false);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = Time.monotonicNow();
            this.reachedTimestamp = Time.now();
            if (FSNamesystem.this.smmthread == null) {
                FSNamesystem.this.smmthread = new Daemon(new SafeModeMonitor());
                FSNamesystem.this.smmthread.start();
                this.reportStatus("STATE* Safe mode extension entered.", true);
            }
            if (this.canInitializeReplQueues() && !FSNamesystem.this.blockManager.isPopulatingReplQueues() && !FSNamesystem.this.haEnabled) {
                FSNamesystem.this.blockManager.initializeReplQueues();
            }
        }

        private synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.blockThreshold = (int)((double)this.blockTotal * this.threshold);
            this.blockReplQueueThreshold = (int)((double)this.blockTotal * this.replQueueThreshold);
            if (FSNamesystem.this.haEnabled) {
                this.shouldIncrementallyTrackBlocks = true;
            }
            if (this.blockSafe < 0) {
                this.blockSafe = 0;
            }
            this.checkMode();
        }

        private synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
                StartupProgress prog = NameNode.getStartupProgress();
                if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                    if (this.awaitingReportedBlocksCounter == null) {
                        this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                    }
                    this.awaitingReportedBlocksCounter.increment();
                }
                this.checkMode();
            }
        }

        private synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
                assert (this.blockSafe >= 0 || this.isManual() || this.areResourcesLow());
                this.checkMode();
            }
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() {
            if (!this.isOn()) {
                return "Safe mode is OFF.";
            }
            String adminMsg = "It was turned on manually. ";
            if (this.areResourcesLow()) {
                adminMsg = "Resources are low on NN. Please add or free up more resources then turn off safe mode manually. NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode. ";
            }
            if (this.isManual() || this.areResourcesLow()) {
                return adminMsg + "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off.";
            }
            boolean thresholdsMet = true;
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            if (this.blockSafe < this.blockThreshold) {
                msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.%n", this.blockSafe, this.blockThreshold - this.blockSafe, this.threshold, this.blockTotal);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", this.blockSafe, this.threshold, this.blockTotal);
            }
            if (numLive < this.datanodeThreshold) {
                msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.%n", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The number of live datanodes %d has reached the minimum number %d. ", numLive, this.datanodeThreshold);
            }
            if (FSNamesystem.this.blockManager.getBytesInFuture() > 0L) {
                msg = msg + "Name node detected blocks with generation stamps in future. This means that Name node metadata is inconsistent.This can happen if Name node metadata files have been manually replaced. Exiting safe mode will cause loss of " + FSNamesystem.this.blockManager.getBytesInFuture() + " byte(s). Please restart name node with " + "right metadata or use \"hdfs dfsadmin -safemode forceExit" + "if you are certain that the NameNode was started with the" + "correct FsImage and edit logs. If you encountered this during" + "a rollback, it is safe to exit with -safemode forceExit.";
                return msg;
            }
            msg = msg + (this.reached > 0L ? "In safe mode extension. " : "");
            msg = msg + "Safe mode will be turned off automatically ";
            msg = !thresholdsMet ? msg + "once the thresholds have been reached." : (this.reached + (long)this.extension - Time.monotonicNow() > 0L ? msg + "in " + (this.reached + (long)this.extension - Time.monotonicNow()) / 1000L + " seconds." : msg + "soon.");
            return msg;
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = Time.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info(msg + " \n" + this.getTurnOffTip());
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe blocks = " + this.blockSafe + ". Target blocks = " + this.blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reachedTimestamp) + ".";
            }
            return resText;
        }

        private void doConsistencyCheck() {
            boolean assertsOn = false;
            if (!$assertionsDisabled) {
                assertsOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertsOn) {
                return;
            }
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return;
            }
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            if (this.blockTotal != activeBlocks && (this.blockSafe < 0 || this.blockSafe > this.blockTotal)) {
                throw new AssertionError((Object)(" SafeMode: Inconsistent filesystem state: SafeMode data: blockTotal=" + this.blockTotal + " blockSafe=" + this.blockSafe + "; " + "BlockManager data: active=" + activeBlocks));
            }
        }

        private synchronized void adjustBlockTotals(int deltaSafe, int deltaTotal) {
            if (!this.shouldIncrementallyTrackBlocks) {
                return;
            }
            assert (FSNamesystem.this.haEnabled);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adjusting block totals from " + this.blockSafe + "/" + this.blockTotal + " to " + (this.blockSafe + deltaSafe) + "/" + (this.blockTotal + deltaTotal));
            }
            assert (this.blockSafe + deltaSafe >= 0) : "Can't reduce blockSafe " + this.blockSafe + " by " + deltaSafe + ": would be negative";
            assert (this.blockTotal + deltaTotal >= 0) : "Can't reduce blockTotal " + this.blockTotal + " by " + deltaTotal + ": would be negative";
            this.blockSafe += deltaSafe;
            this.setBlockTotal(this.blockTotal + deltaTotal);
        }
    }

    class LazyPersistFileScrubber
    implements Runnable {
        private volatile boolean shouldRun = true;
        final int scrubIntervalSec;

        public LazyPersistFileScrubber(int scrubIntervalSec) {
            this.scrubIntervalSec = scrubIntervalSec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCorruptLazyPersistFiles() throws IOException {
            BlockStoragePolicy lpPolicy = FSNamesystem.this.blockManager.getStoragePolicy("LAZY_PERSIST");
            ArrayList<INodeFile> filesToDelete = new ArrayList<INodeFile>();
            boolean changed = false;
            FSNamesystem.this.writeLock();
            try {
                Iterator<BlockInfo> it = FSNamesystem.this.blockManager.getCorruptReplicaBlockIterator();
                while (it.hasNext()) {
                    Block b = it.next();
                    BlockInfo blockInfo = FSNamesystem.this.blockManager.getStoredBlock(b);
                    INodeFile bc = FSNamesystem.this.getBlockCollection(blockInfo);
                    if (bc.getStoragePolicyID() != lpPolicy.getId()) continue;
                    filesToDelete.add(bc);
                }
                for (BlockCollection blockCollection : filesToDelete) {
                    LOG.warn("Removing lazyPersist file " + blockCollection.getName() + " with no replicas.");
                    INode.BlocksMapUpdateInfo toRemoveBlocks = FSDirDeleteOp.deleteInternal(FSNamesystem.this, INodesInPath.fromINode((INodeFile)blockCollection), false);
                    changed |= toRemoveBlocks != null;
                    if (toRemoveBlocks == null) continue;
                    FSNamesystem.this.removeBlocks(toRemoveBlocks);
                }
            }
            finally {
                FSNamesystem.this.writeUnlock("clearCorruptLazyPersistFiles");
            }
            if (changed) {
                FSNamesystem.this.getEditLog().logSync();
            }
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldRun) {
                try {
                    if (!FSNamesystem.this.isInSafeMode()) {
                        this.clearCorruptLazyPersistFiles();
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Namenode is in safemode, skipping scrubbing of corrupted lazy-persist files.");
                    }
                }
                catch (Exception e) {
                    LOG.error("Ignoring exception in LazyPersistFileScrubber:", e);
                }
                try {
                    Thread.sleep(this.scrubIntervalSec * 1000);
                }
                catch (InterruptedException e) {
                    LOG.info("LazyPersistFileScrubber was interrupted, exiting");
                    break;
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    class NameNodeEditLogRoller
    implements Runnable {
        private boolean shouldRun = true;
        private final long rollThreshold;
        private final long sleepIntervalMs;

        public NameNodeEditLogRoller(long rollThreshold, int sleepIntervalMs) {
            this.rollThreshold = rollThreshold;
            this.sleepIntervalMs = sleepIntervalMs;
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldRun) {
                try {
                    long numEdits = FSNamesystem.this.getCorrectTransactionsSinceLastLogRoll();
                    if (numEdits > this.rollThreshold) {
                        LOG.info("NameNode rolling its own edit log because number of edits in open segment exceeds threshold of " + this.rollThreshold);
                        FSNamesystem.this.rollEditLog();
                    }
                }
                catch (Exception e) {
                    LOG.error("Swallowing exception in " + NameNodeEditLogRoller.class.getSimpleName() + ":", e);
                }
                try {
                    Thread.sleep(this.sleepIntervalMs);
                }
                catch (InterruptedException e) {
                    LOG.info(NameNodeEditLogRoller.class.getSimpleName() + " was interrupted, exiting");
                    break;
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn(lowResourcesMsg + "Entering safe mode.");
                        } else {
                            LOG.warn(lowResourcesMsg + "Already in safe mode.");
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException lowResourcesMsg) {}
                }
            }
            catch (Exception e) {
                LOG.error("Exception in NameNodeResourceMonitor: ", e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }

    static enum RecoverLeaseOp {
        CREATE_FILE,
        APPEND_FILE,
        TRUNCATE_FILE,
        RECOVER_LEASE;


        private String getExceptionMessage(String src, String holder, String clientMachine, String reason) {
            return "Failed to " + (Object)((Object)this) + " " + src + " for " + holder + " on " + clientMachine + " because " + reason;
        }
    }
}

