/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.primitives.Ints;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.XAttrStorage;

class XAttrFormat {
    private static final int XATTR_NAMESPACE_MASK = 7;
    private static final int XATTR_NAMESPACE_OFFSET = 29;
    private static final int XATTR_NAME_MASK = 0x1FFFFFFF;
    private static final int XATTR_NAME_ID_MAX = 0x20000000;
    private static final int XATTR_VALUE_LEN_MAX = 65536;
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();

    XAttrFormat() {
    }

    static List<XAttr> toXAttrs(byte[] attrs) {
        ArrayList<XAttr> xAttrs = new ArrayList<XAttr>();
        if (attrs == null || attrs.length == 0) {
            return xAttrs;
        }
        int i = 0;
        while (i < attrs.length) {
            XAttr.Builder builder = new XAttr.Builder();
            int v = Ints.fromBytes(attrs[i], attrs[i + 1], attrs[i + 2], attrs[i + 3]);
            i += 4;
            int ns = v >> 29 & 7;
            int nid = v & 0x1FFFFFFF;
            builder.setNameSpace(XATTR_NAMESPACE_VALUES[ns]);
            builder.setName(XAttrStorage.getName(nid));
            int vlen = (0xFF & attrs[i]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                builder.setValue(value);
                i += vlen;
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    static XAttr getXAttr(byte[] attrs, String prefixedName) {
        int vlen;
        if (prefixedName == null || attrs == null) {
            return null;
        }
        XAttr xAttr = XAttrHelper.buildXAttr(prefixedName);
        for (int i = 0; i < attrs.length; i += vlen) {
            int v = Ints.fromBytes(attrs[i], attrs[i + 1], attrs[i + 2], attrs[i + 3]);
            int ns = v >> 29 & 7;
            int nid = v & 0x1FFFFFFF;
            XAttr.NameSpace namespace = XATTR_NAMESPACE_VALUES[ns];
            String name = XAttrStorage.getName(nid);
            vlen = (0xFF & attrs[i += 4]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (xAttr.getNameSpace() != namespace || !xAttr.getName().equals(name)) continue;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                return new XAttr.Builder().setNameSpace(namespace).setName(name).setValue(value).build();
            }
            return xAttr;
        }
        return null;
    }

    static byte[] toBytes(List<XAttr> xAttrs) {
        if (xAttrs == null || xAttrs.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (XAttr a : xAttrs) {
                int nsOrd = a.getNameSpace().ordinal();
                Preconditions.checkArgument(nsOrd < 8, "Too many namespaces.");
                int nid = XAttrStorage.getNameSerialNumber(a.getName());
                Preconditions.checkArgument(nid < 0x20000000, "Too large serial number of the xattr name");
                int v = (nsOrd & 7) << 29 | nid & 0x1FFFFFFF;
                out.write(Ints.toByteArray(v));
                int vlen = a.getValue() == null ? 0 : a.getValue().length;
                Preconditions.checkArgument(vlen < 65536, "The length of xAttr values is too long.");
                out.write((byte)(vlen >> 8));
                out.write((byte)vlen);
                if (vlen <= 0) continue;
                out.write(a.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }
}

