/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Private
public class XAttrPermissionFilter {
    static void checkPermissionForApi(FSPermissionChecker pc, XAttr xAttr, boolean isRawPath) throws AccessControlException {
        boolean isSuperUser = pc.isSuperUser();
        if (xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED && isSuperUser) {
            return;
        }
        if (xAttr.getNameSpace() == XAttr.NameSpace.RAW && isRawPath && isSuperUser) {
            return;
        }
        if (XAttrHelper.getPrefixedName(xAttr).equals("security.hdfs.unreadable.by.superuser")) {
            if (xAttr.getValue() != null) {
                throw new AccessControlException("Attempt to set a value for 'security.hdfs.unreadable.by.superuser'. Values are not allowed for this xattr.");
            }
            return;
        }
        throw new AccessControlException("User doesn't have permission for xattr: " + XAttrHelper.getPrefixedName(xAttr));
    }

    static void checkPermissionForApi(FSPermissionChecker pc, List<XAttr> xAttrs, boolean isRawPath) throws AccessControlException {
        Preconditions.checkArgument(xAttrs != null);
        if (xAttrs.isEmpty()) {
            return;
        }
        for (XAttr xAttr : xAttrs) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, isRawPath);
        }
    }

    static List<XAttr> filterXAttrsForApi(FSPermissionChecker pc, List<XAttr> xAttrs, boolean isRawPath) {
        assert (xAttrs != null) : "xAttrs can not be null";
        if (xAttrs.isEmpty()) {
            return xAttrs;
        }
        ArrayList<XAttr> filteredXAttrs = Lists.newArrayListWithCapacity(xAttrs.size());
        boolean isSuperUser = pc.isSuperUser();
        for (XAttr xAttr : xAttrs) {
            if (xAttr.getNameSpace() == XAttr.NameSpace.USER) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED && isSuperUser) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (xAttr.getNameSpace() == XAttr.NameSpace.RAW && isSuperUser && isRawPath) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (!XAttrHelper.getPrefixedName(xAttr).equals("security.hdfs.unreadable.by.superuser")) continue;
            filteredXAttrs.add(xAttr);
        }
        return filteredXAttrs;
    }
}

