/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ha.ServiceFailedException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.ipc.StandbyException;

@InterfaceAudience.Private
public class StandbyState
extends HAState {
    public StandbyState() {
        super(HAServiceProtocol.HAServiceState.STANDBY);
    }

    @Override
    public void setState(HAContext context, HAState s) throws ServiceFailedException {
        if (s == NameNode.ACTIVE_STATE) {
            this.setStateInternal(context, s);
            return;
        }
        super.setState(context, s);
    }

    @Override
    public void enterState(HAContext context) throws ServiceFailedException {
        try {
            context.startStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to start standby services", e);
        }
    }

    @Override
    public void prepareToExitState(HAContext context) throws ServiceFailedException {
        context.prepareToStopStandbyServices();
    }

    @Override
    public void exitState(HAContext context) throws ServiceFailedException {
        try {
            context.stopStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to stop standby services", e);
        }
    }

    @Override
    public void checkOperation(HAContext context, NameNode.OperationCategory op) throws StandbyException {
        if (op == NameNode.OperationCategory.UNCHECKED || op == NameNode.OperationCategory.READ && context.allowStaleReads()) {
            return;
        }
        String faq = ". Visit https://s.apache.org/sbnn-error";
        String msg = "Operation category " + (Object)((Object)op) + " is not supported in state " + context.getState() + faq;
        throw new StandbyException(msg);
    }

    @Override
    public boolean shouldPopulateReplQueues() {
        return false;
    }
}

