/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.File;
import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsBinaryLoader;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsXmlLoader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
interface OfflineEditsLoader {
    public void loadEdits() throws IOException;

    public static class OfflineEditsLoaderFactory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static OfflineEditsLoader createLoader(OfflineEditsVisitor visitor, String inputFileName, boolean xmlInput, OfflineEditsViewer.Flags flags) throws IOException {
            if (xmlInput) {
                return new OfflineEditsXmlLoader(visitor, new File(inputFileName), flags);
            }
            File file = null;
            EditLogInputStream elis = null;
            OfflineEditsBinaryLoader loader = null;
            try {
                file = new File(inputFileName);
                elis = new EditLogFileInputStream(file, -12345L, -12345L, false);
                loader = new OfflineEditsBinaryLoader(visitor, elis, flags);
            }
            finally {
                if (loader == null && elis != null) {
                    elis.close();
                }
            }
            return loader;
        }
    }
}

