/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.lib.MutableGauge;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableGaugeLong
extends MutableGauge {
    private AtomicLong value = new AtomicLong();

    MutableGaugeLong(MetricsInfo info, long initValue) {
        super(info);
        this.value.set(initValue);
    }

    public long value() {
        return this.value.get();
    }

    @Override
    public void incr() {
        this.incr(1L);
    }

    public void incr(long delta) {
        this.value.addAndGet(delta);
        this.setChanged();
    }

    @Override
    public void decr() {
        this.decr(1L);
    }

    public void decr(long delta) {
        this.value.addAndGet(-delta);
        this.setChanged();
    }

    public void set(long value) {
        this.value.set(value);
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value());
            this.clearChanged();
        }
    }
}

