/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.flink.fs.s3hadoop.shaded.com.sun.jndi.ldap.LdapCtxFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.GroupMappingServiceProvider;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class LdapGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String LDAP_CONFIG_PREFIX = "hadoop.security.group.mapping.ldap";
    public static final String LDAP_URL_KEY = "hadoop.security.group.mapping.ldap.url";
    public static final String LDAP_URL_DEFAULT = "";
    public static final String LDAP_USE_SSL_KEY = "hadoop.security.group.mapping.ldap.ssl";
    public static final Boolean LDAP_USE_SSL_DEFAULT = false;
    public static final String LDAP_KEYSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore";
    public static final String LDAP_KEYSTORE_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password";
    public static final String LDAP_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password.file";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_DEFAULT = "";
    public static final String BIND_USER_KEY = "hadoop.security.group.mapping.ldap.bind.user";
    public static final String BIND_USER_DEFAULT = "";
    public static final String BIND_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.bind.password";
    public static final String BIND_PASSWORD_DEFAULT = "";
    public static final String BIND_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.bind.password.file";
    public static final String BIND_PASSWORD_FILE_DEFAULT = "";
    public static final String BASE_DN_KEY = "hadoop.security.group.mapping.ldap.base";
    public static final String BASE_DN_DEFAULT = "";
    public static final String USER_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.user";
    public static final String USER_SEARCH_FILTER_DEFAULT = "(&(objectClass=user)(sAMAccountName={0}))";
    public static final String GROUP_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.group";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "(objectClass=group)";
    public static final String GROUP_MEMBERSHIP_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.member";
    public static final String GROUP_MEMBERSHIP_ATTR_DEFAULT = "member";
    public static final String GROUP_NAME_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.group.name";
    public static final String GROUP_NAME_ATTR_DEFAULT = "cn";
    public static final String POSIX_UID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.uid.name";
    public static final String POSIX_UID_ATTR_DEFAULT = "uidNumber";
    public static final String POSIX_GID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.gid.name";
    public static final String POSIX_GID_ATTR_DEFAULT = "gidNumber";
    public static final String POSIX_GROUP = "posixGroup";
    public static final String POSIX_ACCOUNT = "posixAccount";
    public static final String DIRECTORY_SEARCH_TIMEOUT = "hadoop.security.group.mapping.ldap.directory.search.timeout";
    public static final int DIRECTORY_SEARCH_TIMEOUT_DEFAULT = 10000;
    public static final String CONNECTION_TIMEOUT = "hadoop.security.group.mapping.ldap.connection.timeout.ms";
    public static final int CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String READ_TIMEOUT = "hadoop.security.group.mapping.ldap.read.timeout.ms";
    public static final int READ_TIMEOUT_DEFAULT = 60000;
    private static final Log LOG = LogFactory.getLog(LdapGroupsMapping.class);
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();
    private DirContext ctx;
    private Configuration conf;
    private String ldapUrl;
    private boolean useSsl;
    private String keystore;
    private String keystorePass;
    private String bindUser;
    private String bindPassword;
    private String baseDN;
    private String groupSearchFilter;
    private String userSearchFilter;
    private String groupMemberAttr;
    private String groupNameAttr;
    private String posixUidAttr;
    private String posixGidAttr;
    private boolean isPosix;
    public static final int RECONNECT_RETRY_COUNT = 3;

    @Override
    public synchronized List<String> getGroups(String user) {
        for (int retry = 0; retry < 3; ++retry) {
            try {
                return this.doGetGroups(user);
            }
            catch (NamingException e) {
                LOG.warn("Failed to get groups for user " + user + " (retry=" + retry + ") by " + e);
                LOG.trace("TRACE", e);
                this.ctx = null;
                continue;
            }
        }
        return Collections.emptyList();
    }

    List<String> doGetGroups(String user) throws NamingException {
        ArrayList<String> groups = new ArrayList<String>();
        DirContext ctx = this.getDirContext();
        NamingEnumeration<SearchResult> results = ctx.search(this.baseDN, this.userSearchFilter, new Object[]{user}, SEARCH_CONTROLS);
        if (results.hasMoreElements()) {
            SearchResult result = (SearchResult)results.nextElement();
            String userDn = result.getNameInNamespace();
            NamingEnumeration<SearchResult> groupResults = null;
            if (this.isPosix) {
                String gidNumber = null;
                String uidNumber = null;
                Attribute gidAttribute = result.getAttributes().get(this.posixGidAttr);
                Attribute uidAttribute = result.getAttributes().get(this.posixUidAttr);
                if (gidAttribute != null) {
                    gidNumber = gidAttribute.get().toString();
                }
                if (uidAttribute != null) {
                    uidNumber = uidAttribute.get().toString();
                }
                if (uidNumber != null && gidNumber != null) {
                    groupResults = ctx.search(this.baseDN, "(&" + this.groupSearchFilter + "(|(" + this.posixGidAttr + "={0})" + "(" + this.groupMemberAttr + "={1})))", new Object[]{gidNumber, uidNumber}, SEARCH_CONTROLS);
                }
            } else {
                groupResults = ctx.search(this.baseDN, "(&" + this.groupSearchFilter + "(" + this.groupMemberAttr + "={0}))", new Object[]{userDn}, SEARCH_CONTROLS);
            }
            if (groupResults != null) {
                while (groupResults.hasMoreElements()) {
                    SearchResult groupResult = (SearchResult)groupResults.nextElement();
                    Attribute groupName = groupResult.getAttributes().get(this.groupNameAttr);
                    groups.add(groupName.get().toString());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doGetGroups(" + user + ") return " + groups);
        }
        return groups;
    }

    DirContext getDirContext() throws NamingException {
        if (this.ctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", LdapCtxFactory.class.getName());
            env.put("java.naming.provider.url", this.ldapUrl);
            env.put("java.naming.security.authentication", "simple");
            if (this.useSsl) {
                env.put("java.naming.security.protocol", "ssl");
                System.setProperty("javax.net.ssl.keyStore", this.keystore);
                System.setProperty("javax.net.ssl.keyStorePassword", this.keystorePass);
            }
            env.put("java.naming.security.principal", this.bindUser);
            env.put("java.naming.security.credentials", this.bindPassword);
            env.put("org.apache.flink.fs.s3hadoop.shaded.com.sun.jndi.ldap.connect.timeout", this.conf.get(CONNECTION_TIMEOUT, String.valueOf(60000)));
            env.put("org.apache.flink.fs.s3hadoop.shaded.com.sun.jndi.ldap.read.timeout", this.conf.get(READ_TIMEOUT, String.valueOf(60000)));
            this.ctx = new InitialDirContext(env);
        }
        return this.ctx;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.ldapUrl = conf.get(LDAP_URL_KEY, "");
        if (this.ldapUrl == null || this.ldapUrl.isEmpty()) {
            throw new RuntimeException("LDAP URL is not configured");
        }
        this.useSsl = conf.getBoolean(LDAP_USE_SSL_KEY, LDAP_USE_SSL_DEFAULT);
        this.keystore = conf.get(LDAP_KEYSTORE_KEY, "");
        this.keystorePass = this.getPassword(conf, LDAP_KEYSTORE_PASSWORD_KEY, "");
        if (this.keystorePass.isEmpty()) {
            this.keystorePass = this.extractPassword(conf.get(LDAP_KEYSTORE_PASSWORD_FILE_KEY, ""));
        }
        this.bindUser = conf.get(BIND_USER_KEY, "");
        this.bindPassword = this.getPassword(conf, BIND_PASSWORD_KEY, "");
        if (this.bindPassword.isEmpty()) {
            this.bindPassword = this.extractPassword(conf.get(BIND_PASSWORD_FILE_KEY, ""));
        }
        this.baseDN = conf.get(BASE_DN_KEY, "");
        this.groupSearchFilter = conf.get(GROUP_SEARCH_FILTER_KEY, GROUP_SEARCH_FILTER_DEFAULT);
        this.userSearchFilter = conf.get(USER_SEARCH_FILTER_KEY, USER_SEARCH_FILTER_DEFAULT);
        this.isPosix = this.groupSearchFilter.contains(POSIX_GROUP) && this.userSearchFilter.contains(POSIX_ACCOUNT);
        this.groupMemberAttr = conf.get(GROUP_MEMBERSHIP_ATTR_KEY, GROUP_MEMBERSHIP_ATTR_DEFAULT);
        this.groupNameAttr = conf.get(GROUP_NAME_ATTR_KEY, GROUP_NAME_ATTR_DEFAULT);
        this.posixUidAttr = conf.get(POSIX_UID_ATTR_KEY, POSIX_UID_ATTR_DEFAULT);
        this.posixGidAttr = conf.get(POSIX_GID_ATTR_KEY, POSIX_GID_ATTR_DEFAULT);
        int dirSearchTimeout = conf.getInt(DIRECTORY_SEARCH_TIMEOUT, 10000);
        SEARCH_CONTROLS.setTimeLimit(dirSearchTimeout);
        SEARCH_CONTROLS.setReturningAttributes(new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr});
        this.conf = conf;
    }

    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias " + alias + ": ", ioe);
        }
        return password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String extractPassword(String pwFile) {
        if (pwFile.isEmpty()) {
            return "";
        }
        StringBuilder password = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pwFile), StandardCharsets.UTF_8);){
            int c = ((Reader)reader).read();
            while (c > -1) {
                password.append((char)c);
                c = ((Reader)reader).read();
            }
            String string = password.toString().trim();
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not read password file: " + pwFile, ioe);
        }
    }

    static {
        SEARCH_CONTROLS.setSearchScope(2);
    }
}

