/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.web;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.slf4j.Logger;
import org.apache.flink.fs.s3hadoop.shaded.org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DelegationTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenManager.class);
    public static final String ENABLE_ZK_KEY = "zk-dt-secret-manager.enable";
    public static final String PREFIX = "delegation-token.";
    public static final String UPDATE_INTERVAL = "delegation-token.update-interval.sec";
    public static final long UPDATE_INTERVAL_DEFAULT = 86400L;
    public static final String MAX_LIFETIME = "delegation-token.max-lifetime.sec";
    public static final long MAX_LIFETIME_DEFAULT = 604800L;
    public static final String RENEW_INTERVAL = "delegation-token.renew-interval.sec";
    public static final long RENEW_INTERVAL_DEFAULT = 86400L;
    public static final String REMOVAL_SCAN_INTERVAL = "delegation-token.removal-scan-interval.sec";
    public static final long REMOVAL_SCAN_INTERVAL_DEFAULT = 3600L;
    private AbstractDelegationTokenSecretManager secretManager = null;
    private boolean managedSecretManager;

    public DelegationTokenManager(Configuration conf, Text tokenKind) {
        this.secretManager = conf.getBoolean(ENABLE_ZK_KEY, false) ? new ZKSecretManager(conf, tokenKind) : new DelegationTokenSecretManager(conf, tokenKind);
        this.managedSecretManager = true;
    }

    public void setExternalDelegationTokenSecretManager(AbstractDelegationTokenSecretManager secretManager) {
        this.secretManager.stopThreads();
        this.secretManager = secretManager;
        this.managedSecretManager = false;
    }

    public void init() {
        if (this.managedSecretManager) {
            try {
                this.secretManager.startThreads();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not start " + this.secretManager.getClass() + ": " + ex.toString(), ex);
            }
        }
    }

    public void destroy() {
        if (this.managedSecretManager) {
            this.secretManager.stopThreads();
        }
    }

    public Token<? extends AbstractDelegationTokenIdentifier> createToken(UserGroupInformation ugi, String renewer) {
        LOG.debug("Creating token with ugi:{}, renewer:{}.", (Object)ugi, (Object)renewer);
        renewer = renewer == null ? ugi.getShortUserName() : renewer;
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        AbstractDelegationTokenIdentifier tokenIdentifier = (AbstractDelegationTokenIdentifier)this.secretManager.createIdentifier();
        tokenIdentifier.setOwner(owner);
        tokenIdentifier.setRenewer(new Text(renewer));
        tokenIdentifier.setRealUser(realUser);
        return new Token<AbstractDelegationTokenIdentifier>(tokenIdentifier, this.secretManager);
    }

    public long renewToken(Token<? extends AbstractDelegationTokenIdentifier> token, String renewer) throws IOException {
        LOG.debug("Renewing token:{} with renewer:{}.", token, (Object)renewer);
        return this.secretManager.renewToken(token, renewer);
    }

    public void cancelToken(Token<? extends AbstractDelegationTokenIdentifier> token, String canceler) throws IOException {
        LOG.debug("Cancelling token:{} with canceler:{}.", token, (Object)canceler);
        canceler = canceler != null ? canceler : this.verifyToken(token).getShortUserName();
        this.secretManager.cancelToken(token, canceler);
    }

    public UserGroupInformation verifyToken(Token<? extends AbstractDelegationTokenIdentifier> token) throws IOException {
        AbstractDelegationTokenIdentifier id = this.secretManager.decodeTokenIdentifier(token);
        this.secretManager.verifyToken(id, token.getPassword());
        return id.getUser();
    }

    @VisibleForTesting
    public AbstractDelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.secretManager;
    }

    private static DelegationTokenIdentifier decodeToken(Token<DelegationTokenIdentifier> token, Text tokenKind) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream dis = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier(tokenKind);
        id.readFields(dis);
        dis.close();
        return id;
    }

    private static class ZKSecretManager
    extends ZKDelegationTokenSecretManager<DelegationTokenIdentifier> {
        private Text tokenKind;

        public ZKSecretManager(Configuration conf, Text tokenKind) {
            super(conf);
            this.tokenKind = tokenKind;
        }

        @Override
        public DelegationTokenIdentifier createIdentifier() {
            return new DelegationTokenIdentifier(this.tokenKind);
        }

        @Override
        public DelegationTokenIdentifier decodeTokenIdentifier(Token<DelegationTokenIdentifier> token) throws IOException {
            return DelegationTokenManager.decodeToken(token, this.tokenKind);
        }
    }

    private static class DelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        private Text tokenKind;

        public DelegationTokenSecretManager(Configuration conf, Text tokenKind) {
            super(conf.getLong(DelegationTokenManager.UPDATE_INTERVAL, 86400L) * 1000L, conf.getLong(DelegationTokenManager.MAX_LIFETIME, 604800L) * 1000L, conf.getLong(DelegationTokenManager.RENEW_INTERVAL, 86400L) * 1000L, conf.getLong(DelegationTokenManager.REMOVAL_SCAN_INTERVAL, 3600L) * 1000L);
            this.tokenKind = tokenKind;
        }

        @Override
        public DelegationTokenIdentifier createIdentifier() {
            return new DelegationTokenIdentifier(this.tokenKind);
        }

        @Override
        public DelegationTokenIdentifier decodeTokenIdentifier(Token<DelegationTokenIdentifier> token) throws IOException {
            return DelegationTokenManager.decodeToken(token, this.tokenKind);
        }
    }
}

