/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.LocalFileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Shell;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class GenericOptionsParser {
    private static final Log LOG = LogFactory.getLog(GenericOptionsParser.class);
    private Configuration conf;
    private CommandLine commandLine;

    public GenericOptionsParser(Options opts, String[] args) throws IOException {
        this(new Configuration(), opts, args);
    }

    public GenericOptionsParser(String[] args) throws IOException {
        this(new Configuration(), new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, String[] args) throws IOException {
        this(conf, new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, Options options, String[] args) throws IOException {
        this.parseGeneralOptions(options, conf, args);
        this.conf = conf;
    }

    public String[] getRemainingArgs() {
        return this.commandLine == null ? new String[]{} : this.commandLine.getArgs();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    private static synchronized Options buildGeneralOptions(Options opts) {
        OptionBuilder.withArgName("file:///|hdfs://namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify default filesystem URL to use, overrides 'fs.defaultFS' property from configurations.");
        Option fs = OptionBuilder.create("fs");
        OptionBuilder.withArgName("local|resourcemanager:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify a ResourceManager");
        Option jt = OptionBuilder.create("jt");
        OptionBuilder.withArgName("configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("specify an application configuration file");
        Option oconf = OptionBuilder.create("conf");
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("use value for given property");
        Option property = OptionBuilder.create('D');
        OptionBuilder.withArgName("paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("org.apache.flink.fs.s3hadoop.shaded.comma separated jar files to include in the classpath.");
        Option libjars = OptionBuilder.create("libjars");
        OptionBuilder.withArgName("paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("org.apache.flink.fs.s3hadoop.shaded.comma separated files to be copied to the map reduce cluster");
        Option files = OptionBuilder.create("files");
        OptionBuilder.withArgName("paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("org.apache.flink.fs.s3hadoop.shaded.comma separated archives to be unarchived on the compute machines.");
        Option archives = OptionBuilder.create("archives");
        OptionBuilder.withArgName("tokensFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("name of the file with the tokens");
        Option tokensFile = OptionBuilder.create("tokenCacheFile");
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        opts.addOption(libjars);
        opts.addOption(files);
        opts.addOption(archives);
        opts.addOption(tokensFile);
        return opts;
    }

    private void processGeneralOptions(Configuration conf, CommandLine line) throws IOException {
        if (line.hasOption("fs")) {
            FileSystem.setDefaultUri(conf, line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            String optionValue = line.getOptionValue("jt");
            if (optionValue.equalsIgnoreCase("local")) {
                conf.set("mapreduce.framework.name", optionValue);
            }
            conf.set("yarn.resourcemanager.address", optionValue, "from -jt command line option");
        }
        if (line.hasOption("conf")) {
            String[] values;
            for (String value : values = line.getOptionValues("conf")) {
                conf.addResource(new Path(value));
            }
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (String prop : property) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length != 2) continue;
                conf.set(keyval[0], keyval[1], "from command line");
            }
        }
        if (line.hasOption("libjars")) {
            conf.set("tmpjars", this.validateFiles(line.getOptionValue("libjars"), conf), "from -libjars command line option");
            URL[] libjars = GenericOptionsParser.getLibJars(conf);
            if (libjars != null && libjars.length > 0) {
                conf.setClassLoader(new URLClassLoader(libjars, conf.getClassLoader()));
                Thread.currentThread().setContextClassLoader(new URLClassLoader(libjars, Thread.currentThread().getContextClassLoader()));
            }
        }
        if (line.hasOption("files")) {
            conf.set("tmpfiles", this.validateFiles(line.getOptionValue("files"), conf), "from -files command line option");
        }
        if (line.hasOption("archives")) {
            conf.set("tmparchives", this.validateFiles(line.getOptionValue("archives"), conf), "from -archives command line option");
        }
        conf.setBoolean("mapreduce.client.genericoptionsparser.used", true);
        if (line.hasOption("tokenCacheFile")) {
            Path p;
            String fileName = line.getOptionValue("tokenCacheFile");
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            if (!localFs.exists(p = ((FileSystem)localFs).makeQualified(new Path(fileName)))) {
                throw new FileNotFoundException("File " + fileName + " does not exist.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("setting conf tokensFile: " + fileName);
            }
            UserGroupInformation.getCurrentUser().addCredentials(Credentials.readTokenStorageFile(p, conf));
            conf.set("mapreduce.job.credentials.binary", p.toString(), "from -tokenCacheFile command line option");
        }
    }

    public static URL[] getLibJars(Configuration conf) throws IOException {
        String jars = conf.get("tmpjars");
        if (jars == null) {
            return null;
        }
        String[] files = jars.split(",");
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String file : files) {
            Path tmp = new Path(file);
            if (tmp.getFileSystem(conf).equals(FileSystem.getLocal(conf))) {
                cp.add(FileSystem.getLocal(conf).pathToFile(tmp).toURI().toURL());
                continue;
            }
            LOG.warn("The libjars file " + tmp + " is not on the local " + "filesystem. Ignoring.");
        }
        return cp.toArray(new URL[0]);
    }

    private String validateFiles(String files, Configuration conf) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(",");
        if (fileArr.length == 0) {
            throw new IllegalArgumentException("File name can't be empty string");
        }
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            URI pathURI;
            String tmp = fileArr[i];
            if (tmp.isEmpty()) {
                throw new IllegalArgumentException("File name can't be empty string");
            }
            try {
                pathURI = new URI(tmp);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path path = new Path(pathURI);
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            if (pathURI.getScheme() == null) {
                if (!localFs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(((FileSystem)localFs).getUri(), ((FileSystem)localFs).getWorkingDirectory()).toString();
            } else {
                FileSystem fs = path.getFileSystem(conf);
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString(finalArr);
    }

    private String[] preProcessForWindows(String[] args) {
        if (!Shell.WINDOWS) {
            return args;
        }
        if (args == null) {
            return null;
        }
        ArrayList<String> newArgs = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String prop = null;
            if (args[i].equals("-D")) {
                newArgs.add(args[i]);
                if (i < args.length - 1) {
                    prop = args[++i];
                }
            } else if (args[i].startsWith("-D")) {
                prop = args[i];
            } else {
                newArgs.add(args[i]);
            }
            if (prop == null) continue;
            if (!prop.contains("=") && i < args.length - 1) {
                prop = prop + "=" + args[++i];
            }
            newArgs.add(prop);
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    private void parseGeneralOptions(Options opts, Configuration conf, String[] args) throws IOException {
        opts = GenericOptionsParser.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(opts, this.preProcessForWindows(args), true);
            this.processGeneralOptions(conf, this.commandLine);
        }
        catch (ParseException e) {
            LOG.warn("options parsing failed: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
        }
    }

    public static void printGenericCommandUsage(PrintStream out) {
        out.println("Generic options supported are");
        out.println("-conf <configuration file>     specify an application configuration file");
        out.println("-D <property=value>            use value for given property");
        out.println("-fs <file:///|hdfs://namenode:port> specify default filesystem URL to use, overrides 'fs.defaultFS' property from configurations.");
        out.println("-jt <local|resourcemanager:port>    specify a ResourceManager");
        out.println("-files <comma separated list of files>    specify comma separated files to be copied to the map reduce cluster");
        out.println("-libjars <comma separated list of jars>    specify comma separated jar files to include in the classpath.");
        out.println("-archives <comma separated list of archives>    specify comma separated archives to be unarchived on the compute machines.\n");
        out.println("The general command line syntax is");
        out.println("org.apache.flink.fs.s3hadoop.shaded.command [genericOptions] [commandOptions]\n");
    }
}

