/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.annotation.ObjectIdGenerator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.annotation.ObjectIdResolver;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.InjectableValues;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.DeserializerCache;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.DeserializerFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.fasterxml.jackson.databind.util.ClassUtil;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    protected DefaultDeserializationContext(DeserializerFactory df, DeserializerCache cache) {
        super(df, cache);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext src, DeserializationConfig config, JsonParser jp, InjectableValues values) {
        super(src, config, jp, values);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext src, DeserializerFactory factory) {
        super(src, factory);
    }

    @Override
    public ReadableObjectId findObjectId(Object id, ObjectIdGenerator<?> gen, ObjectIdResolver resolverType) {
        ObjectIdGenerator.IdKey key = gen.key(id);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            ReadableObjectId entry = this._objectIds.get(key);
            if (entry != null) {
                return entry;
            }
        }
        ObjectIdResolver resolver = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver res : this._objectIdResolvers) {
                if (!res.canUseFor(resolverType)) continue;
                resolver = res;
                break;
            }
        }
        if (resolver == null) {
            resolver = resolverType.newForDeserialization(this);
            this._objectIdResolvers.add(resolver);
        }
        ReadableObjectId entry = new ReadableObjectId(key);
        entry.setResolver(resolver);
        this._objectIds.put(key, entry);
        return entry;
    }

    @Override
    @Deprecated
    public ReadableObjectId findObjectId(Object id, ObjectIdGenerator<?> gen) {
        return this.findObjectId(id, gen, new SimpleObjectIdResolver());
    }

    @Override
    public void checkUnresolvedObjectId() throws UnresolvedForwardReference {
        if (this._objectIds == null) {
            return;
        }
        UnresolvedForwardReference exception = null;
        for (Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId> entry : this._objectIds.entrySet()) {
            ReadableObjectId roid = entry.getValue();
            if (!roid.hasReferringProperties()) continue;
            if (exception == null) {
                exception = new UnresolvedForwardReference("Unresolved forward references for: ");
            }
            Iterator<ReadableObjectId.Referring> iterator = roid.referringProperties();
            while (iterator.hasNext()) {
                ReadableObjectId.Referring referring = iterator.next();
                exception.addUnresolvedId(roid.getKey().key, referring.getBeanType(), referring.getLocation());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated ann, Object deserDef) throws JsonMappingException {
        JsonDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof JsonDeserializer) {
            deser = (JsonDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == JsonDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator hi = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer = deser = hi == null ? null : hi.deserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (JsonDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)deser)).resolve(this);
        }
        return deser;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated ann, Object deserDef) throws JsonMappingException {
        KeyDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof KeyDeserializer) {
            deser = (KeyDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + deserDef.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == KeyDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator hi = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer = deser = hi == null ? null : hi.keyDeserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (KeyDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)deser)).resolve(this);
        }
        return deser;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory df) {
            super(df, null);
        }

        protected Impl(Impl src, DeserializationConfig config, JsonParser jp, InjectableValues values) {
            super(src, config, jp, values);
        }

        protected Impl(Impl src, DeserializerFactory factory) {
            super(src, factory);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig config, JsonParser jp, InjectableValues values) {
            return new Impl(this, config, jp, values);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory factory) {
            return new Impl(this, factory);
        }
    }
}

