/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.http.impl.cookie;

import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.annotation.Contract;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.cookie.Cookie;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.cookie.CookieOrigin;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.cookie.MalformedCookieException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.cookie.SetCookie;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

