/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.RemoteEnvironment;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.configuration.Configuration;

public class ScalaShellRemoteEnvironment
extends RemoteEnvironment {
    private FlinkILoop flinkILoop;

    public ScalaShellRemoteEnvironment(String host, int port, FlinkILoop flinkILoop, String ... jarFiles) {
        super(host, port, null, jarFiles, null);
        this.flinkILoop = flinkILoop;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        String[] extJars;
        JavaPlan p = this.createProgramPlan(jobName);
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> alljars = new ArrayList<URL>();
        for (String extJar : extJars = this.flinkILoop.getExternalJars()) {
            URL extJarUrl = new File(extJar).getAbsoluteFile().toURI().toURL();
            alljars.add(extJarUrl);
        }
        alljars.add(jarUrl);
        PlanExecutor executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (Configuration)new Configuration(), (URL[])alljars.toArray(new URL[alljars.size()]), null);
        executor.setPrintStatusDuringExecution(p.getExecutionConfig().isSysoutLoggingEnabled());
        return executor.executePlan((Plan)p);
    }

    public static void disableAllContextAndOtherEnvironments() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
            }
        };
        ScalaShellRemoteEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void resetContextEnvironments() {
        ExecutionEnvironment.resetContextEnvironment();
    }
}

