/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.hadoop.shaded.org.apache.http.Header;
import org.apache.flink.hadoop.shaded.org.apache.http.HttpException;
import org.apache.flink.hadoop.shaded.org.apache.http.HttpRequest;
import org.apache.flink.hadoop.shaded.org.apache.http.HttpRequestInterceptor;
import org.apache.flink.hadoop.shaded.org.apache.http.annotation.Immutable;
import org.apache.flink.hadoop.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection defHeaders = (Collection)request.getParams().getParameter("http.default-headers");
        if (defHeaders != null) {
            for (Header defHeader : defHeaders) {
                request.addHeader(defHeader);
            }
        }
    }
}

